/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import java.util.ArrayList;
import java.util.List;

public final class LassoAutomatonBuilder<LETTER> {
    private final NestedWordAutomaton<LETTER, IPredicate> mResult;
    private final PredicateFactory mPredicateFactory;

    public LassoAutomatonBuilder(VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, PredicateFactory predicateFactory, NestedWord<LETTER> nestedWord, NestedWord<LETTER> nestedWord2, IUltimateServiceProvider iUltimateServiceProvider) throws AutomataOperationCanceledException {
        this.mPredicateFactory = predicateFactory;
        this.mResult = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), vpAlphabet, iEmptyStackStateFactory);
        List<IPredicate> list = this.constructListOfDontCarePredicates(nestedWord.length());
        List<IPredicate> list2 = this.constructListOfDontCarePredicates(nestedWord2.length());
        if (nestedWord.length() == 0) {
            IPredicate iPredicate = list2.get(0);
            this.mResult.addState(true, true, (Object)iPredicate);
        } else {
            IPredicate iPredicate = list.get(0);
            this.mResult.addState(true, false, (Object)iPredicate);
        }
        IPredicate iPredicate = list2.get(0);
        if (nestedWord.length() > 0) {
            this.mResult.addState(false, true, (Object)iPredicate);
        }
        list.add(iPredicate);
        list2.add(iPredicate);
        this.addSequenceOfStatesButFirstAndLast(list);
        this.mResult.addTransitions(nestedWord, list);
        this.addSequenceOfStatesButFirstAndLast(list2);
        this.mResult.addTransitions(nestedWord2, list2);
        try {
            assert (new BuchiAccepts(new AutomataLibraryServices(iUltimateServiceProvider), this.mResult, new NestedLassoWord(nestedWord, nestedWord2)).getResult().booleanValue());
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }

    private List<IPredicate> constructListOfDontCarePredicates(int n) {
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add((IPredicate)this.mPredicateFactory.newDontCarePredicate(null));
            ++n2;
        }
        return arrayList;
    }

    private void addSequenceOfStatesButFirstAndLast(List<IPredicate> list) {
        int n = 1;
        while (n < list.size() - 1) {
            this.mResult.addState(false, false, (Object)list.get(n));
            ++n;
        }
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> getResult() {
        return this.mResult;
    }
}

