/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ArrayIndexBasedCostEstimation {
    private final MultiElementCounter<Doubleton<ArrayIndex>> mIndexDoubleton2Occurrence = new MultiElementCounter();
    private final MultiElementCounter<TermVariable> mEliminatee2Cost = new MultiElementCounter();
    private final TreeHashRelation<Integer, TermVariable> mCost2Eliminatee;
    private final TreeHashRelation<Integer, Doubleton<ArrayIndex>> mOccurrence2Doubletons;
    private final int mOccurrenceMaximum;
    private final Doubleton<Term> mProposedCaseSplitDoubleton;

    public ArrayIndexBasedCostEstimation(Script script, ArrayIndexEqualityManager arrayIndexEqualityManager, Set<TermVariable> set, Term term, Set<TermVariable> set2) {
        for (TermVariable termVariable : set) {
            this.computeCostEstimation(script, arrayIndexEqualityManager, term, termVariable);
        }
        this.mCost2Eliminatee = ArrayIndexBasedCostEstimation.computeCost2Eliminatee(set, this.mEliminatee2Cost);
        this.mOccurrence2Doubletons = ArrayIndexBasedCostEstimation.computeOccurrence2Doubletons(this.mIndexDoubleton2Occurrence);
        if (this.mOccurrence2Doubletons.isEmpty()) {
            this.mOccurrenceMaximum = 0;
            this.mProposedCaseSplitDoubleton = null;
        } else {
            this.mOccurrenceMaximum = (Integer)this.mOccurrence2Doubletons.descendingDomain().iterator().next();
            this.mProposedCaseSplitDoubleton = this.computeProposedCaseSplitDoubleton(arrayIndexEqualityManager, set2, this.mOccurrence2Doubletons, this.mOccurrenceMaximum);
        }
    }

    private Doubleton<Term> computeProposedCaseSplitDoubleton(ArrayIndexEqualityManager arrayIndexEqualityManager, Set<TermVariable> set, TreeHashRelation<Integer, Doubleton<ArrayIndex>> treeHashRelation, int n) {
        for (Doubleton doubleton : treeHashRelation.getImage((Object)n)) {
            int n2 = 0;
            while (n2 < ((ArrayIndex)doubleton.getOneElement()).size()) {
                Term term;
                Term term2 = ((ArrayIndex)doubleton.getOneElement()).get(n2);
                EqualityStatus equalityStatus = arrayIndexEqualityManager.checkEqualityStatus(term2, term = ((ArrayIndex)doubleton.getOtherElement()).get(n2));
                if (equalityStatus == EqualityStatus.UNKNOWN) {
                    return new Doubleton((Object)term2, (Object)term);
                }
                ++n2;
            }
        }
        throw new AssertionError((Object)"all values known");
    }

    public TreeHashRelation<Integer, TermVariable> getCost2Eliminatee() {
        return this.mCost2Eliminatee;
    }

    public int getOccurrenceMaximum() {
        return this.mOccurrenceMaximum;
    }

    public Doubleton<Term> getProposedCaseSplitDoubleton() {
        return this.mProposedCaseSplitDoubleton;
    }

    private static TreeHashRelation<Integer, TermVariable> computeCost2Eliminatee(Set<TermVariable> set, MultiElementCounter<TermVariable> multiElementCounter) {
        TreeHashRelation treeHashRelation = new TreeHashRelation();
        for (TermVariable termVariable : set) {
            treeHashRelation.addPair((Object)multiElementCounter.getNumber((Object)termVariable), (Object)termVariable);
        }
        return treeHashRelation;
    }

    private static TreeHashRelation<Integer, Doubleton<ArrayIndex>> computeOccurrence2Doubletons(MultiElementCounter<Doubleton<ArrayIndex>> multiElementCounter) {
        TreeHashRelation treeHashRelation = new TreeHashRelation();
        for (Doubleton doubleton : multiElementCounter.getElements()) {
            treeHashRelation.addPair((Object)multiElementCounter.getNumber((Object)doubleton), (Object)doubleton);
        }
        return treeHashRelation;
    }

    private void computeCostEstimation(Script script, ArrayIndexEqualityManager arrayIndexEqualityManager, Term term, TermVariable termVariable) {
        List<ArrayIndex> n2;
        ArrayOccurrenceAnalysis arrayOccurrenceAnalysis = new ArrayOccurrenceAnalysis(script, term, (Term)termVariable).downgradeDimensionsIfNecessary(script);
        HashSet<ArrayIndex> hashSet = new HashSet<ArrayIndex>();
        List<MultiDimensionalSelectOverNestedStore> list2 = arrayOccurrenceAnalysis.getArraySelectOverStores();
        for (MultiDimensionalSelectOverNestedStore object2 : list2) {
            ArrayIndex n = object2.getSelectIndex();
            boolean arrayIndex = this.sosOuterLoop(arrayIndexEqualityManager, termVariable, n, n2 = object2.getNestedStore().getIndices());
            if (arrayIndex) continue;
            hashSet.add(n);
        }
        Set<ArrayIndex> set = ArrayOccurrenceAnalysis.extractSelectIndices(arrayOccurrenceAnalysis.getArraySelects());
        ArrayList<ArrayIndex> arrayList = new ArrayList<ArrayIndex>(set);
        arrayList.addAll(hashSet);
        int set2 = 0;
        while (set2 < arrayList.size()) {
            int n = 0;
            while (n < set2) {
                Object object;
                ArrayIndex arrayIndex = (ArrayIndex)arrayList.get(set2);
                int arrayIndex2 = ArrayIndexBasedCostEstimation.analyzeCosts(arrayIndexEqualityManager, arrayIndex, (ArrayIndex)(object = (ArrayIndex)arrayList.get(n)));
                if (arrayIndex2 != 0) {
                    this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)arrayIndex, object), arrayIndex2);
                    this.mEliminatee2Cost.increment((Object)termVariable, arrayIndex2);
                }
                ++n;
            }
            ++set2;
        }
        Set<ArrayIndex> set3 = ArrayOccurrenceAnalysis.extractNestedStoreIndices(arrayOccurrenceAnalysis.getNestedArrayStores());
        n2 = new ArrayList<ArrayIndex>(set3);
        for (ArrayIndex arrayIndex : n2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ArrayIndex arrayIndex2 = (ArrayIndex)iterator.next();
                int n = ArrayIndexBasedCostEstimation.analyzeCosts(arrayIndexEqualityManager, arrayIndex, arrayIndex2);
                if (n == 0) continue;
                this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)arrayIndex, (Object)arrayIndex2), n);
                this.mEliminatee2Cost.increment((Object)termVariable, n);
            }
        }
    }

    private boolean sosOuterLoop(ArrayIndexEqualityManager arrayIndexEqualityManager, TermVariable termVariable, ArrayIndex arrayIndex, List<ArrayIndex> list) {
        int n = list.size() - 1;
        while (n >= 0) {
            boolean bl = this.sosInnerLoop(arrayIndexEqualityManager, arrayIndex, list, n);
            this.mEliminatee2Cost.increment((Object)termVariable);
            if (bl) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean sosInnerLoop(ArrayIndexEqualityManager arrayIndexEqualityManager, ArrayIndex arrayIndex, List<ArrayIndex> list, int n) {
        int n2 = list.size() - 1;
        while (n2 >= n) {
            EqualityStatus equalityStatus = arrayIndexEqualityManager.checkIndexEquality(arrayIndex, list.get(n2));
            switch (equalityStatus) {
                case EQUAL: {
                    return true;
                }
                case NOT_EQUAL: {
                    break;
                }
                case UNKNOWN: {
                    this.mIndexDoubleton2Occurrence.increment((Object)new Doubleton((Object)arrayIndex, (Object)list.get(n2)));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            --n2;
        }
        return false;
    }

    private static int analyzeCosts(ArrayIndexEqualityManager arrayIndexEqualityManager, ArrayIndex arrayIndex, ArrayIndex arrayIndex2) {
        if (arrayIndex.size() != arrayIndex2.size()) {
            throw new AssertionError((Object)"incompatible size");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < arrayIndex.size()) {
            Term term = arrayIndex.get(n2);
            Term term2 = arrayIndex2.get(n2);
            EqualityStatus equalityStatus = arrayIndexEqualityManager.checkEqualityStatus(term, term2);
            switch (equalityStatus) {
                case EQUAL: {
                    break;
                }
                case NOT_EQUAL: {
                    return 0;
                }
                case UNKNOWN: {
                    ++n;
                    break;
                }
            }
            ++n2;
        }
        return n;
    }
}

