/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierOverapproximator;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Context {
    private static final CcTransformation OPTION_CCTRANSFORMATION = CcTransformation.OVERAPPROXIMATE_QUANTIFIERS;
    private final Term mCriticalConstraint;
    private final CcTransformation mCcTransformation = OPTION_CCTRANSFORMATION;
    private final Set<TermVariable> mBoundByAncestors;

    public Context(Script script) {
        this.mCriticalConstraint = script.term("true", new Term[0]);
        this.mBoundByAncestors = Collections.emptySet();
    }

    public Context(Term term, Set<TermVariable> set) {
        Objects.requireNonNull(term);
        Objects.requireNonNull(set);
        this.mCriticalConstraint = term;
        this.mBoundByAncestors = set;
    }

    public Term getCriticalConstraint() {
        return this.mCriticalConstraint;
    }

    public Set<TermVariable> getBoundByAncestors() {
        return Collections.unmodifiableSet(this.mBoundByAncestors);
    }

    public Context constructChildContextForQuantifiedFormula(Script script, Collection<TermVariable> collection) {
        Term term = Stream.concat(Arrays.asList(this.mCriticalConstraint.getFreeVars()).stream(), collection.stream()).collect(Collectors.toSet());
        Object object = this.checkForDifferentVariablesWithSameName((Collection<TermVariable>)term);
        if (object != null) {
            throw new UnsupportedOperationException("Different variables with same name: " + (String)object);
        }
        term = Context.buildCriticalContraintForQuantifiedFormula(script, this.mCriticalConstraint, collection, this.mCcTransformation);
        object = new HashSet<TermVariable>(this.mBoundByAncestors);
        object.addAll(collection);
        return new Context(term, (Set<TermVariable>)object);
    }

    public Context constructChildContextForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, FunctionSymbol functionSymbol, List<Term> list, int n) {
        Term term = Context.buildCriticalConstraintForConDis(iUltimateServiceProvider, managedScript, this.mCriticalConstraint, functionSymbol, list, n, this.mCcTransformation);
        return new Context(term, this.mBoundByAncestors);
    }

    public Context constructChildContextForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, FunctionSymbol functionSymbol, List<Term> list) {
        Term term = Context.buildCriticalConstraintForConDis(iUltimateServiceProvider, managedScript, this.mCriticalConstraint, functionSymbol, list, this.mCcTransformation);
        return new Context(term, this.mBoundByAncestors);
    }

    public static Term buildCriticalContraintForQuantifiedFormula(Script script, Term term, Collection<TermVariable> collection, CcTransformation ccTransformation) {
        Term term2 = SmtUtils.quantifier(script, 0, collection, term);
        Term term3 = ccTransformation == CcTransformation.OVERAPPROXIMATE_QUANTIFIERS ? QuantifierOverapproximator.apply(script, term2) : term2;
        return term3;
    }

    public static Term buildConjunctiveCriticalContraintForQuantifiedFormula(Script script, Term term, List<TermVariable> list) {
        Term[] termArray = SmtUtils.getConjuncts(term);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            assert (SmtUtils.isAtomicFormula(term2)) : "non-atom in critical constraint";
            if (!Arrays.stream(term2.getFreeVars()).anyMatch(list::contains)) {
                arrayList.add(term2);
            }
            ++n2;
        }
        return SmtUtils.and(script, arrayList);
    }

    public static Term buildCriticalConstraintForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, FunctionSymbol functionSymbol, List<Term> list, int n, CcTransformation ccTransformation) {
        ArrayList<Term> arrayList = new ArrayList<Term>(list);
        arrayList.remove(n);
        return Context.buildCriticalConstraintForConDis(iUltimateServiceProvider, managedScript, term, functionSymbol, arrayList, ccTransformation);
    }

    private static Term buildCriticalConstraintForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term2, FunctionSymbol functionSymbol, List<Term> list, CcTransformation ccTransformation) {
        Object object;
        Term term3;
        if (functionSymbol.getName().equals("and")) {
            term3 = SmtUtils.and(managedScript.getScript(), list);
        } else if (functionSymbol.getName().equals("or")) {
            switch (ccTransformation) {
                case NONE: {
                    object = list.stream().map(term -> SmtUtils.not(managedScript.getScript(), term)).collect(Collectors.toList());
                    break;
                }
                case TO_NNF: 
                case OVERAPPROXIMATE_QUANTIFIERS: {
                    object = list.stream().map(term -> new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(SmtUtils.not(managedScript.getScript(), term))).collect(Collectors.toList());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + String.valueOf((Object)ccTransformation)));
                }
            }
            term3 = SmtUtils.and(managedScript.getScript(), (Collection<Term>)object);
        } else if (functionSymbol.getName().equals("=")) {
            term3 = managedScript.getScript().term("true", new Term[0]);
        } else {
            throw new AssertionError((Object)("Supported: conjunction and disjunction. Got: " + String.valueOf(functionSymbol)));
        }
        object = SmtUtils.and(managedScript.getScript(), term3, term2);
        Object object2 = ccTransformation == CcTransformation.OVERAPPROXIMATE_QUANTIFIERS ? QuantifierOverapproximator.apply(managedScript.getScript(), object) : object;
        return object2;
    }

    public static Term buildConjunctiveCriticalConstraintForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, FunctionSymbol functionSymbol, List<Term> list, int n) {
        ArrayList<Term> arrayList = new ArrayList<Term>(list);
        arrayList.remove(n);
        return Context.buildConjunctiveCriticalConstraintForConDis(iUltimateServiceProvider, managedScript, term, functionSymbol, arrayList);
    }

    private static Term buildConjunctiveCriticalConstraintForConDis(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term2, FunctionSymbol functionSymbol, List<Term> list) {
        Term term3;
        if (functionSymbol.getName().equals("and")) {
            term3 = SmtUtils.and(managedScript.getScript(), list.stream().filter(SmtUtils::isAtomicFormula).collect(Collectors.toList()));
        } else if (functionSymbol.getName().equals("or")) {
            List<Term> list2 = list.stream().filter(SmtUtils::isAtomicFormula).map(term -> new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.KEEP).transform(SmtUtils.not(managedScript.getScript(), term))).collect(Collectors.toList());
            term3 = SmtUtils.and(managedScript.getScript(), list2);
        } else if (functionSymbol.getName().equals("=")) {
            term3 = managedScript.getScript().term("true", new Term[0]);
        } else {
            throw new AssertionError((Object)"only conjunction and disjunction are supported");
        }
        term3 = SmtUtils.and(managedScript.getScript(), term3, term2);
        return term3;
    }

    public String checkForDifferentVariablesWithSameName(Collection<TermVariable> collection) {
        HashMap<String, TermVariable> hashMap = new HashMap<String, TermVariable>();
        for (TermVariable termVariable : collection) {
            TermVariable termVariable2 = hashMap.put(termVariable.getName(), termVariable);
            if (termVariable2 == null || termVariable2.equals(termVariable)) continue;
            return termVariable2.getName();
        }
        return null;
    }

    public static enum CcTransformation {
        NONE,
        TO_NNF,
        OVERAPPROXIMATE_QUANTIFIERS;

    }
}

