/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.LinkedHashSet;

public class DualJunctionQeAdapter2014
extends DualJunctionQuantifierElimination {
    private final XjunctPartialQuantifierElimination mXjunctPqe;

    public DualJunctionQeAdapter2014(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, XjunctPartialQuantifierElimination xjunctPartialQuantifierElimination) {
        super(managedScript, iUltimateServiceProvider);
        this.mXjunctPqe = xjunctPartialQuantifierElimination;
    }

    @Override
    public String getName() {
        return this.mXjunctPqe.getName();
    }

    @Override
    public String getAcronym() {
        return this.mXjunctPqe.getAcronym();
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>(eliminationTask.getEliminatees());
        Term[] termArray2 = this.mXjunctPqe.tryToEliminate(eliminationTask.getQuantifier(), termArray, linkedHashSet);
        Term term = QuantifierUtils.applyDualFiniteConnective(this.mScript, eliminationTask.getQuantifier(), termArray2);
        EliminationTask eliminationTask2 = eliminationTask.update(linkedHashSet, term);
        if (eliminationTask2.getEliminatees().containsAll(eliminationTask.getEliminatees())) {
            return null;
        }
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, Collections.emptySet());
    }
}

