/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.mcr;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.IInterpolantProvider;
import de.uni_freiburg.informatik.ultimate.lib.mcr.McrUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IpInterpolantProvider<LETTER extends IIcfgTransition<?>>
implements IInterpolantProvider<LETTER> {
    private final IPredicateUnifier mPredicateUnifier;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final MultiElementCounter<IProgramVar> mConstVarCounter;

    public IpInterpolantProvider(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IPredicateUnifier iPredicateUnifier, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mLogger = iLogger;
        this.mManagedScript = managedScript;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mConstVarCounter = new MultiElementCounter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <STATE> void addInterpolants(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Map<STATE, IPredicate> map2) {
        void var15_18;
        Term term2;
        Collection<Object> collection;
        List<List<STATE>> list = this.getTopologicalHierachicalSort(iNestedWordAutomaton, map2);
        HashMap hashMap = new HashMap();
        HashMap<IProgramVar, Term> hashMap2 = new HashMap<IProgramVar, Term>();
        Map<Object, Map> map3 = list.stream().flatMap(Collection::stream).collect(Collectors.toMap(object -> object, object -> new HashMap()));
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size() + 1);
        Set<IProgramVar> set = map2.values().stream().flatMap(iPredicate -> iPredicate.getVars().stream()).collect(Collectors.toSet());
        Script script = this.mManagedScript.getScript();
        ArrayList<TransFormula> arrayList2 = new ArrayList<TransFormula>();
        ArrayList<Map<IProgramVar, Term>> arrayList3 = new ArrayList<Map<IProgramVar, Term>>();
        for (List<STATE> termArray2 : list) {
            collection = new ArrayList();
            for (STATE n : termArray2) {
                Object object2;
                ArrayList<TransFormula> arrayList4 = new ArrayList<TransFormula>();
                term2 = new ArrayList();
                Map map4 = map3.get(n);
                for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors(n)) {
                    object2 = incomingInternalTransition.getPred();
                    IPredicate iPredicate2 = map2.get(object2);
                    UnmodifiableTransFormula unmodifiableTransFormula = ((IIcfgTransition)incomingInternalTransition.getLetter()).getTransformula();
                    if (iPredicate2 == null) {
                        arrayList4.add((TransFormula)unmodifiableTransFormula);
                        term2.add((Map<IProgramVar, Term>)map3.get(object2));
                        continue;
                    }
                    arrayList4.add((TransFormula)this.addCondition(unmodifiableTransFormula, iPredicate2, true));
                    term2.add(hashMap);
                }
                collection.add(this.substituteTransformulas((List<TransFormula>)arrayList4, (List<Map<IProgramVar, Term>>)term2, map4, set));
                for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalSuccessors(n)) {
                    object2 = map2.get(incomingInternalTransition.getSucc());
                    if (object2 == null) continue;
                    arrayList2.add((TransFormula)this.addCondition(((IIcfgTransition)incomingInternalTransition.getLetter()).getTransformula(), (IPredicate)object2, false));
                    arrayList3.add(map4);
                }
            }
            arrayList.add(SmtUtils.and((Script)script, collection));
        }
        arrayList.add(this.substituteTransformulas(arrayList2, arrayList3, hashMap2, set));
        this.mLogger.info((Object)"Calculating interpolants for SSA");
        Term[] termArray = this.getInterpolantsForSsa(arrayList);
        this.mLogger.info((Object)"Finished");
        ScopedHashMap scopedHashMap = new ScopedHashMap();
        map3.values().forEach(map -> map.forEach((iProgramVar, term) -> {
            Object object = scopedHashMap.put(term, (Object)this.mManagedScript.constructFreshCopy(iProgramVar.getTermVariable()));
        }));
        collection = McrUtils.getTermVariables(set);
        boolean bl = false;
        while (var15_18 < termArray.length) {
            for (Iterator<Object> iterator : list.get((int)var15_18)) {
                scopedHashMap.beginScope();
                map3.get(iterator).forEach((iProgramVar, term) -> {
                    Object object = scopedHashMap.put(term, (Object)iProgramVar.getTermVariable());
                });
                term2 = this.renameAndAbstract(termArray[var15_18], (Map<Term, Term>)scopedHashMap, (Set<TermVariable>)collection);
                map2.put(iterator, this.mPredicateUnifier.getOrConstructPredicate(term2));
                scopedHashMap.endScope();
            }
            ++var15_18;
        }
    }

    private <STATE> List<List<STATE>> getTopologicalHierachicalSort(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Map<STATE, IPredicate> map) {
        Object object;
        ArrayList<List<STATE>> arrayList = new ArrayList<List<STATE>>();
        ArrayList<Object> arrayList2 = new ArrayList();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object2 : iNestedWordAutomaton.getStates()) {
            if (map.containsKey(object2)) continue;
            HashSet hashSet = new HashSet();
            for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors(object2)) {
                object = incomingInternalTransition.getPred();
                if (map.containsKey(object)) continue;
                hashSet.add(object);
            }
            if (hashSet.isEmpty()) {
                arrayList2.add(object2);
                continue;
            }
            hashMap.put(object2, hashSet);
        }
        while (!arrayList2.isEmpty()) {
            Object object2;
            object2 = new ArrayList();
            arrayList.add(arrayList2);
            for (Object e : arrayList2) {
                hashMap.remove(e);
                for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalSuccessors(e)) {
                    object = (Set)hashMap.get(incomingInternalTransition.getSucc());
                    if (object == null || !object.remove(e) || !object.isEmpty()) continue;
                    object2.add((Object)incomingInternalTransition.getSucc());
                }
            }
            arrayList2 = object2;
        }
        return arrayList;
    }

    private UnmodifiableTransFormula addCondition(UnmodifiableTransFormula unmodifiableTransFormula, IPredicate iPredicate, boolean bl) {
        Term term = bl ? iPredicate.getFormula() : SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)iPredicate.getFormula());
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaBuilder.constructTransFormulaFromTerm((Term)term, (Set)iPredicate.getVars(), (ManagedScript)this.mManagedScript);
        List<UnmodifiableTransFormula> list = bl ? Arrays.asList(unmodifiableTransFormula2, unmodifiableTransFormula) : Arrays.asList(unmodifiableTransFormula, unmodifiableTransFormula2);
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)false, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, list);
    }

    private Term substituteTransformulas(List<TransFormula> list, List<Map<IProgramVar, Term>> list2, Map<IProgramVar, Term> map2, Set<IProgramVar> set) {
        Set set2 = list.stream().flatMap(transFormula -> transFormula.getAssignedVars().stream()).collect(Collectors.toSet());
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (IProgramVar object2 : set) {
            if (set2.contains(object2) || list2.stream().map(map -> (Term)map.get(object2)).distinct().limit(2L).count() >= 2L) continue;
            hashSet.add(object2);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size());
        Script script = this.mManagedScript.getScript();
        int n = 0;
        while (n < list.size()) {
            HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            TransFormula transFormula2 = list.get(n);
            Map<IProgramVar, Term> map3 = list2.get(n);
            for (IProgramVar iProgramVar : set) {
                Term term;
                Term term2;
                Term term3 = this.getOrConstructConstant(iProgramVar, map3);
                if (hashSet.contains(iProgramVar)) {
                    term2 = term3;
                    map2.put(iProgramVar, term2);
                } else {
                    term2 = this.getOrConstructConstant(iProgramVar, map2);
                    if (!transFormula2.getAssignedVars().contains(iProgramVar)) {
                        arrayList2.add(SmtUtils.binaryEquality((Script)script, (Term)term2, (Term)term3));
                    }
                }
                Term term4 = (Term)transFormula2.getInVars().get(iProgramVar);
                if (term4 != null) {
                    hashMap.put(term4, term3);
                }
                if ((term = (Term)transFormula2.getOutVars().get(iProgramVar)) == null) continue;
                hashMap.put(term, term2);
            }
            arrayList2.add(this.renameAndAbstract(transFormula2.getFormula(), hashMap, Collections.emptySet()));
            arrayList.add(SmtUtils.and((Script)script, arrayList2));
            ++n;
        }
        return SmtUtils.or((Script)script, arrayList);
    }

    private Term getOrConstructConstant(IProgramVar iProgramVar, Map<IProgramVar, Term> map) {
        Term term = map.get(iProgramVar);
        if (term == null) {
            String string = SmtUtils.removeSmtQuoteCharacters((String)iProgramVar.getGloballyUniqueId());
            String string2 = "c_" + string + "_" + String.valueOf(this.mConstVarCounter.increment((Object)iProgramVar));
            this.mManagedScript.getScript().declareFun(string2, new Sort[0], iProgramVar.getSort());
            term = this.mManagedScript.getScript().term(string2, new Term[0]);
            map.put(iProgramVar, term);
        }
        return term;
    }

    private Term renameAndAbstract(Term term, Map<Term, Term> map, Set<TermVariable> set) {
        Term term2 = Substitution.apply((ManagedScript)this.mManagedScript, map, (Term)term);
        Term term3 = McrUtils.abstractVariables(term2, set, 0, this.mManagedScript, this.mServices, this.mLogger, this.mSimplificationTechnique);
        return PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term3);
    }

    private Term[] getInterpolantsForSsa(List<Term> list) {
        int n = 0;
        Script script = this.mManagedScript.getScript();
        Term[] termArray2 = new Term[list.size()];
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.push((Object)this, 1);
        for (Term termArray3 : list) {
            String string = "ssa_" + n;
            this.mManagedScript.assertTerm((Object)this, script.annotate(termArray3, new Annotation[]{new Annotation(":named", (Object)string)}));
            termArray2[n] = script.term(string, new Term[0]);
            ++n;
        }
        if (this.mManagedScript.checkSat((Object)this) != Script.LBool.UNSAT) {
            throw new AssertionError((Object)"The SSA of the DAG is satisfiable!");
        }
        Term[] termArray = this.mManagedScript.getInterpolants((Object)this, termArray2);
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.unlock((Object)this);
        return termArray;
    }
}

