/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Set;

public interface ILooperCheck<L> {
    public Script.LBool isUniversalLooper(L var1, Set<IPredicate> var2);

    public static class HoareLooperCheck<L extends IAction>
    implements ILooperCheck<L> {
        private final IHoareTripleChecker mHtc;
        private final IPredicateCoverageChecker mCoverage;
        private final IndependentLooperCheck<L> mIndependentCheck = new IndependentLooperCheck();

        public HoareLooperCheck(IHoareTripleChecker iHoareTripleChecker, IPredicateCoverageChecker iPredicateCoverageChecker) {
            this.mHtc = iHoareTripleChecker;
            this.mCoverage = iPredicateCoverageChecker;
        }

        @Override
        public Script.LBool isUniversalLooper(L l, Set<IPredicate> set) {
            if (l.getTransformula().isInfeasible() != UnmodifiableTransFormula.Infeasibility.UNPROVEABLE) {
                return Script.LBool.SAT;
            }
            if (this.mIndependentCheck.isUniversalLooper(l, set) == Script.LBool.UNSAT) {
                return Script.LBool.UNSAT;
            }
            for (IPredicate iPredicate : set) {
                IncrementalPlicationChecker.Validity validity = this.mHtc.checkInternal(iPredicate, (IInternalAction)l, iPredicate);
                switch (validity) {
                    case INVALID: {
                        return Script.LBool.SAT;
                    }
                    case UNKNOWN: 
                    case NOT_CHECKED: {
                        return Script.LBool.UNKNOWN;
                    }
                    case VALID: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown Validity " + String.valueOf(validity));
                    }
                }
                for (IPredicate iPredicate2 : set) {
                    if (this.mCoverage.isCovered(iPredicate, iPredicate2) == IncrementalPlicationChecker.Validity.VALID) continue;
                    IncrementalPlicationChecker.Validity validity2 = this.mHtc.checkInternal(iPredicate, (IInternalAction)l, iPredicate2);
                    switch (validity2) {
                        case UNKNOWN: 
                        case NOT_CHECKED: {
                            return Script.LBool.UNKNOWN;
                        }
                        case VALID: {
                            return Script.LBool.SAT;
                        }
                        case INVALID: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown Validity " + String.valueOf(validity2));
                        }
                    }
                }
            }
            return Script.LBool.UNSAT;
        }
    }

    public static class IndependentLooperCheck<L extends IAction>
    implements ILooperCheck<L> {
        @Override
        public Script.LBool isUniversalLooper(L l, Set<IPredicate> set) {
            if (l.getTransformula().isInfeasible() != UnmodifiableTransFormula.Infeasibility.UNPROVEABLE) {
                return Script.LBool.SAT;
            }
            for (IPredicate iPredicate : set) {
                boolean bl = this.isIndependent(l, iPredicate);
                if (bl) continue;
                return Script.LBool.SAT;
            }
            return Script.LBool.UNSAT;
        }

        private boolean isIndependent(L l, IPredicate iPredicate) {
            Set set = l.getTransformula().getInVars().keySet();
            Set set2 = l.getTransformula().getOutVars().keySet();
            return !DataStructureUtils.haveNonEmptyIntersection(set, (Set)iPredicate.getVars()) && !DataStructureUtils.haveNonEmptyIntersection(set2, (Set)iPredicate.getVars());
        }
    }
}

