/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStore;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStoreFactory;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AliasAnalysis;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySegment;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceException;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBase;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MayAlias {
    private final UnionFind<AddressStore> mAddressStores;
    private final Map<PointerBase, MemorySegment> mPointerBaseToMemorySegment;

    public MayAlias() {
        this.mAddressStores = new UnionFind();
        this.mPointerBaseToMemorySegment = new HashMap<PointerBase, MemorySegment>();
    }

    public MayAlias(UnionFind<AddressStore> unionFind, Map<PointerBase, MemorySegment> map) {
        this.mAddressStores = unionFind;
        this.mPointerBaseToMemorySegment = map;
    }

    public void reportEquivalence(AddressStoreFactory addressStoreFactory, AddressStore addressStore, AddressStore addressStore2) {
        AddressStore addressStore3;
        AddressStore addressStore4;
        AddressStore addressStore5 = (AddressStore)this.mAddressStores.find((Object)addressStore2);
        AddressStore addressStore6 = (AddressStore)this.mAddressStores.find((Object)addressStore);
        if (addressStore2 == addressStore) {
            if (addressStore2 instanceof PointerBase) {
                PointerBase pointerBase = (PointerBase)addressStore2;
                this.addPointerBase(addressStoreFactory, pointerBase);
            } else if (addressStore2 instanceof MemorySegment) {
                MemorySegment memorySegment = (MemorySegment)addressStore2;
                PointerBase pointerBase = memorySegment.getPointerBase();
                this.addPointerBase(addressStoreFactory, pointerBase);
            } else {
                throw new MemorySliceException("Expect that each AddressStore is either PointerBase or MemorySegment");
            }
            return;
        }
        if (addressStore5 == addressStore6 && addressStore5 != null) {
            return;
        }
        if (addressStore5 == null) {
            this.mAddressStores.makeEquivalenceClass((Object)addressStore2);
            if (addressStore2 instanceof PointerBase) {
                addressStore4 = addressStoreFactory.getMemorySegment((PointerBase)addressStore2);
                this.mPointerBaseToMemorySegment.put((PointerBase)addressStore2, (MemorySegment)addressStore4);
                addressStore3 = (AddressStore)this.mAddressStores.find((Object)addressStore4);
                if (addressStore3 == null) {
                    this.mAddressStores.makeEquivalenceClass((Object)addressStore4);
                }
            }
        }
        if (addressStore6 == null) {
            this.mAddressStores.makeEquivalenceClass((Object)addressStore);
            if (addressStore instanceof PointerBase) {
                addressStore4 = addressStoreFactory.getMemorySegment((PointerBase)addressStore);
                this.mPointerBaseToMemorySegment.put((PointerBase)addressStore, (MemorySegment)addressStore4);
                addressStore3 = (AddressStore)this.mAddressStores.find((Object)addressStore4);
                if (addressStore3 == null) {
                    this.mAddressStores.makeEquivalenceClass((Object)addressStore4);
                }
            }
        }
        if (addressStore instanceof PointerBase && AliasAnalysis.isNullPointer((PointerBase)addressStore) || addressStore2 instanceof PointerBase && AliasAnalysis.isNullPointer((PointerBase)addressStore2)) {
            return;
        }
        this.mAddressStores.union((Object)addressStore, (Object)addressStore2);
        addressStore4 = (AddressStore)this.mAddressStores.find((Object)addressStore);
        this.applyCongruenceExhaustively(addressStoreFactory, this.mAddressStores, addressStore4);
    }

    private void applyCongruenceExhaustively(AddressStoreFactory addressStoreFactory, UnionFind<AddressStore> unionFind, AddressStore addressStore) {
        ImmutableSet immutableSet;
        boolean bl;
        while (bl = this.applyCongruence(addressStoreFactory, unionFind, (Set<AddressStore>)(immutableSet = this.mAddressStores.getEquivalenceClassMembers((Object)addressStore)))) {
        }
    }

    private boolean applyCongruence(AddressStoreFactory addressStoreFactory, UnionFind<AddressStore> unionFind, Set<AddressStore> set) {
        ArrayList<PointerBase> arrayList = new ArrayList<PointerBase>();
        for (AddressStore addressStore : set) {
            if (!(addressStore instanceof PointerBase)) continue;
            arrayList.add((PointerBase)addressStore);
        }
        boolean bl = false;
        if (!arrayList.isEmpty()) {
            MemorySegment memorySegment = addressStoreFactory.getMemorySegment((PointerBase)arrayList.get(0));
            int n = 1;
            while (n < arrayList.size()) {
                MemorySegment memorySegment2 = addressStoreFactory.getMemorySegment((PointerBase)arrayList.get(n));
                bl |= unionFind.union((Object)memorySegment, (Object)memorySegment2);
                ++n;
            }
        }
        return bl;
    }

    public void addPointerBase(AddressStoreFactory addressStoreFactory, PointerBase pointerBase) {
        AddressStore addressStore = (AddressStore)this.mAddressStores.find((Object)pointerBase);
        MemorySegment memorySegment = addressStoreFactory.getMemorySegment(pointerBase);
        AddressStore addressStore2 = (AddressStore)this.mAddressStores.find((Object)memorySegment);
        if (addressStore == null || addressStore2 == null) {
            this.mPointerBaseToMemorySegment.put(pointerBase, memorySegment);
            if (addressStore == null) {
                this.mAddressStores.makeEquivalenceClass((Object)pointerBase);
            }
            if (addressStore2 == null) {
                this.mAddressStores.makeEquivalenceClass((Object)memorySegment);
            }
        }
    }

    public UnionFind<AddressStore> getAddressStores() {
        return this.mAddressStores;
    }

    public Map<PointerBase, MemorySegment> getPointerBaseToMemorySegment() {
        return this.mPointerBaseToMemorySegment;
    }

    public String toString() {
        return this.mAddressStores.toString();
    }
}

