/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class FunctionSymbol {
    public static final int INTERNAL = 1;
    public static final int LEFTASSOC = 2;
    public static final int RIGHTASSOC = 4;
    public static final int CHAINABLE = 6;
    public static final int PAIRWISE = 8;
    public static final int ASSOCMASK = 14;
    public static final int RETURNOVERLOAD = 16;
    public static final int MODELVALUE = 32;
    public static final int UNINTERPRETEDINTERNAL = 64;
    public static final int CONSTRUCTOR = 128;
    public static final int SELECTOR = 256;
    final String mName;
    final String[] mIndices;
    final Sort[] mParamSort;
    final Sort mReturnSort;
    final int mFlags;
    final TermVariable[] mDefinitionVars;
    final Term mDefinition;
    final int mHash;

    FunctionSymbol(String string, String[] stringArray, Sort[] sortArray, Sort sort, TermVariable[] termVariableArray, Term term, int n) {
        this.mName = string;
        this.mIndices = stringArray;
        this.mParamSort = sortArray;
        this.mReturnSort = sort;
        this.mFlags = n;
        this.mDefinition = term;
        this.mDefinitionVars = termVariableArray;
        if (this.isLeftAssoc() && (sortArray.length != 2 || !sortArray[0].equalsSort(sort))) {
            throw new IllegalArgumentException("Wrong sorts for left-associative symbol");
        }
        if (this.isRightAssoc() && (sortArray.length != 2 || !sortArray[1].equalsSort(sort))) {
            throw new IllegalArgumentException("Wrong sorts for right-associative symbol");
        }
        if (!(!this.isChainable() && !this.isPairwise() || sortArray.length == 2 && sortArray[0].equalsSort(sortArray[1]) && sort.equalsSort(this.getTheory().getBooleanSort()))) {
            throw new IllegalArgumentException("Wrong sorts for chainable symbol");
        }
        int n2 = HashUtils.hashJenkins((int)this.mName.hashCode(), (Object[])this.mParamSort);
        if (this.mIndices != null) {
            n2 = HashUtils.hashJenkins((int)n2, (Object[])this.mIndices);
        }
        if (this.mReturnSort != null) {
            n2 = HashUtils.hashJenkins((int)n2, (Object)this.mReturnSort);
        }
        this.mHash = n2;
    }

    public int hashCode() {
        return this.mHash;
    }

    public String getName() {
        return this.mName;
    }

    public String[] getIndices() {
        return this.mIndices;
    }

    public boolean isIntern() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isModelValue() {
        return (this.mFlags & 0x20) != 0;
    }

    public Theory getTheory() {
        return this.mReturnSort.mSymbol.mTheory;
    }

    @Deprecated
    public int getParameterCount() {
        return this.mParamSort.length;
    }

    @Deprecated
    public Sort getParameterSort(int n) {
        return this.mParamSort[n];
    }

    public TermVariable[] getDefinitionVars() {
        return this.mDefinitionVars;
    }

    public Term getDefinition() {
        return this.mDefinition;
    }

    public Sort getReturnSort() {
        return this.mReturnSort;
    }

    public Sort[] getParameterSorts() {
        return this.mParamSort;
    }

    private final void checkSort(Term term, Sort sort) {
        Sort sort2 = term.getSort();
        if (!sort.equalsSort(sort2)) {
            if (sort2.toString().equals(sort.toString())) {
                throw new SMTLIBException("Argument " + String.valueOf(term) + " comes from wrong theory.");
            }
            throw new SMTLIBException("Argument " + String.valueOf(term) + " has type " + String.valueOf(sort2) + " but function " + this.mName + " expects " + String.valueOf(sort));
        }
    }

    public void typecheck(Term[] termArray) throws SMTLIBException {
        assert (termArray.getClass() == Term[].class);
        if ((this.mFlags & 0xE) != 0) {
            if (termArray.length < 2) {
                throw new SMTLIBException("Function " + this.mName + " expects at least two arguments.");
            }
            this.checkSort(termArray[0], this.mParamSort[0]);
            this.checkSort(termArray[termArray.length - 1], this.mParamSort[1]);
            Sort sort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            int n = 1;
            while (n < termArray.length - 1) {
                this.checkSort(termArray[n], sort);
                ++n;
            }
        } else {
            if (termArray.length != this.mParamSort.length) {
                throw new SMTLIBException("Function " + this.mName + " expects " + this.mParamSort.length + " arguments.");
            }
            int n = 0;
            while (n < this.mParamSort.length) {
                this.checkSort(termArray[n], this.mParamSort[n]);
                ++n;
            }
        }
    }

    public boolean typecheck(Sort[] sortArray) {
        if ((this.mFlags & 0xE) != 0) {
            assert (this.mParamSort.length == 2);
            if (sortArray.length < 2) {
                return false;
            }
            if (!sortArray[0].equalsSort(this.mParamSort[0])) {
                return false;
            }
            if (!sortArray[sortArray.length - 1].equalsSort(this.mParamSort[1])) {
                return false;
            }
            Sort sort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            int n = 1;
            while (n < sortArray.length - 1) {
                if (!sortArray[n].equalsSort(sort)) {
                    return false;
                }
                ++n;
            }
        } else {
            if (sortArray.length != this.mParamSort.length) {
                return false;
            }
            int n = 0;
            while (n < this.mParamSort.length) {
                if (!sortArray[n].equalsSort(this.mParamSort[n])) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String toString() {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer();
        String string = PrintTerm.quoteIdentifier(this.mName);
        stringBuffer.append('(');
        if (this.mIndices == null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("(_ ").append(string);
            objectArray = this.mIndices;
            n2 = this.mIndices.length;
            n = 0;
            while (n < n2) {
                object = objectArray[n];
                stringBuffer.append(' ').append((String)object);
                ++n;
            }
            stringBuffer.append(')');
        }
        objectArray = this.mParamSort;
        n2 = this.mParamSort.length;
        n = 0;
        while (n < n2) {
            object = objectArray[n];
            stringBuffer.append(' ').append(object);
            ++n;
        }
        stringBuffer.append(' ').append(this.mReturnSort);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final boolean isChainable() {
        return (this.mFlags & 0xE) == 6;
    }

    public final boolean isPairwise() {
        return (this.mFlags & 0xE) == 8;
    }

    public final boolean isLeftAssoc() {
        return (this.mFlags & 0xE) == 2;
    }

    public final boolean isRightAssoc() {
        return (this.mFlags & 0xE) == 4;
    }

    public final boolean isReturnOverload() {
        return (this.mFlags & 0x10) != 0;
    }

    public String getApplicationString() {
        String string = PrintTerm.quoteIdentifier(this.mName);
        if (this.mIndices == null && !this.isReturnOverload()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isReturnOverload()) {
            stringBuffer.append("(as ");
        }
        if (this.mIndices != null) {
            stringBuffer.append("(_ ");
        }
        stringBuffer.append(string);
        if (this.mIndices != null) {
            String[] stringArray = this.mIndices;
            int n = this.mIndices.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                stringBuffer.append(' ').append(string2);
                ++n2;
            }
            stringBuffer.append(')');
        }
        if (this.isReturnOverload()) {
            stringBuffer.append(' ').append(this.getReturnSort()).append(')');
        }
        return stringBuffer.toString();
    }

    public boolean isInterpreted() {
        return this.isModelValue() || this.isIntern() && (this.mFlags & 0x40) == 0;
    }

    public boolean isConstructor() {
        return (this.mFlags & 0x80) != 0;
    }

    public boolean isSelector() {
        return (this.mFlags & 0x100) != 0;
    }
}

