/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation;

import de.uni_freiburg.informatik.ultimate.core.model.IGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.IcfgTransformationObserver;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.preferences.IcfgTransformationPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IcfgTransformation
implements IGenerator {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private ILogger mLogger;
    private IcfgTransformationObserver mObserver;
    private IUltimateServiceProvider mServices;
    private IcfgTransformationBacktranslator mBacktranslator;
    private ModelType mOldGraphType;

    public ModelType getOutputDefinition() {
        return new ModelType(Activator.PLUGIN_ID, ModelType.Type.CFG, (Collection)this.mOldGraphType.getFileNames());
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.LAST;
    }

    public void setInputDefinition(ModelType modelType) {
        this.mOldGraphType = modelType;
    }

    public List<IObserver> getObservers() {
        ArrayList<IObserver> arrayList = new ArrayList<IObserver>();
        this.mObserver = new IcfgTransformationObserver(this.mLogger, this.mServices, this.mBacktranslator, SIMPLIFICATION_TECHNIQUE);
        arrayList.add((IObserver)this.mObserver);
        return arrayList;
    }

    public void init() {
    }

    public String getPluginName() {
        return "IcfgTransformer";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IElement getModel() {
        return this.mObserver.getModel();
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public IPreferenceInitializer getPreferences() {
        return new IcfgTransformationPreferences();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mBacktranslator = new IcfgTransformationBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        this.mServices.getBacktranslationService().addTranslator((ITranslator)this.mBacktranslator);
    }

    public void finish() {
    }
}

