/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.impulse;

import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.impulse.ImpulseChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.preferences.CodeCheckPreferenceInitializer;
import java.util.ArrayList;
import java.util.HashSet;

public class RedirectionFinder {
    private final ImpulseChecker codeChecker;

    public RedirectionFinder(ImpulseChecker impulseChecker) {
        this.codeChecker = impulseChecker;
    }

    public AnnotatedProgramPoint getStrongestValidCopy(AppEdge appEdge) {
        return this.depthFirstSearch(appEdge, (AnnotatedProgramPoint)appEdge.getTarget());
    }

    private AnnotatedProgramPoint depthFirstSearch(AppEdge appEdge, AnnotatedProgramPoint annotatedProgramPoint) {
        ArrayList<AnnotatedProgramPoint> arrayList = new ArrayList<AnnotatedProgramPoint>();
        for (AnnotatedProgramPoint annotatedProgramPoint2 : annotatedProgramPoint.getNextClones()) {
            if (!this.codeChecker.isValidRedirection(appEdge, annotatedProgramPoint2)) continue;
            if (this.codeChecker.getGlobalSettings().getRedirectionStrategy() == CodeCheckPreferenceInitializer.RedirectionStrategy.FIRST) {
                return this.depthFirstSearch(appEdge, annotatedProgramPoint2);
            }
            arrayList.add(this.depthFirstSearch(appEdge, annotatedProgramPoint2));
        }
        return this.pickUp(annotatedProgramPoint, arrayList);
    }

    private AnnotatedProgramPoint pickUp(AnnotatedProgramPoint annotatedProgramPoint, ArrayList<AnnotatedProgramPoint> arrayList) {
        AnnotatedProgramPoint annotatedProgramPoint2 = annotatedProgramPoint;
        if (!arrayList.isEmpty()) {
            if (this.codeChecker.getGlobalSettings().getRedirectionStrategy() == CodeCheckPreferenceInitializer.RedirectionStrategy.RANDOM) {
                annotatedProgramPoint2 = arrayList.get((int)(Math.random() * (double)arrayList.size()));
            }
            if (this.codeChecker.getGlobalSettings().getRedirectionStrategy() == CodeCheckPreferenceInitializer.RedirectionStrategy.RANDOmSTRONGEST) {
                annotatedProgramPoint2 = this.strongRandomPickup(arrayList);
            }
        }
        return annotatedProgramPoint2;
    }

    private AnnotatedProgramPoint strongRandomPickup(ArrayList<AnnotatedProgramPoint> arrayList) {
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        hashSet.addAll(arrayList);
        for (AnnotatedProgramPoint annotatedProgramPointArray2 : arrayList) {
            AnnotatedProgramPoint[] annotatedProgramPointArray;
            if (!hashSet.contains((Object)annotatedProgramPointArray2)) continue;
            AnnotatedProgramPoint[] annotatedProgramPointArray3 = annotatedProgramPointArray = hashSet.toArray(new AnnotatedProgramPoint[0]);
            int n = annotatedProgramPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotatedProgramPoint annotatedProgramPoint = annotatedProgramPointArray3[n2];
                if (annotatedProgramPoint != annotatedProgramPointArray2 && this.codeChecker.isStrongerPredicate(annotatedProgramPointArray2, annotatedProgramPoint)) {
                    hashSet.remove((Object)annotatedProgramPoint);
                }
                ++n2;
            }
        }
        AnnotatedProgramPoint[] annotatedProgramPointArray = hashSet.toArray(new AnnotatedProgramPoint[0]);
        return annotatedProgramPointArray[(int)((double)annotatedProgramPointArray.length * Math.random())];
    }
}

