/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.TopologicalSorter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CallGraph {
    private final IIcfg<IcfgLocation> mIcfg;
    private final HashRelation<String, IcfgLocation> mLOIsInsideProcedure = new HashRelation();
    private final HashRelation<String, String> mCalledBy = new HashRelation();
    private final HashRelation<String, String> mCalls = new HashRelation();
    private final HashRelation<String, String> mSuccessorsOfInterest = new HashRelation();
    private List<String> mTopsortRelevant;

    public CallGraph(IIcfg<IcfgLocation> iIcfg, Collection<IcfgLocation> collection) {
        this.mIcfg = iIcfg;
        this.assignLOIsToProcedures(collection);
        this.buildGraph();
        this.computeSuccOfInterest();
        this.topsortRelevant();
    }

    private void assignLOIsToProcedures(Collection<IcfgLocation> collection) {
        collection.forEach(icfgLocation -> {
            boolean bl = this.mLOIsInsideProcedure.addPair((Object)icfgLocation.getProcedure(), icfgLocation);
        });
    }

    private void buildGraph() {
        new IcfgEdgeIterator(this.mIcfg).asStream().filter(icfgEdge -> icfgEdge instanceof IIcfgCallTransition).forEach(this::addCall);
    }

    private void addCall(IcfgEdge icfgEdge) {
        String string = ((IcfgLocation)icfgEdge.getSource()).getProcedure();
        String string2 = ((IcfgLocation)icfgEdge.getTarget()).getProcedure();
        this.mCalledBy.addPair((Object)string2, (Object)string);
        this.mCalls.addPair((Object)string, (Object)string2);
    }

    private void computeSuccOfInterest() {
        this.mLOIsInsideProcedure.getDomain().stream().forEach(this::markPredecessors);
    }

    private void markPredecessors(String string) {
        this.mCalledBy.getImage((Object)string).stream().filter(string2 -> this.mSuccessorsOfInterest.addPair(string2, (Object)string)).forEach(this::markPredecessors);
    }

    private void topsortRelevant() {
        Optional optional = new TopologicalSorter(arg_0 -> this.mCalls.getImage(arg_0)).topologicalOrdering(this.callClosure(this.initialProceduresOfInterest()));
        if (!optional.isPresent()) {
            throw new IllegalArgumentException("Recursive programs are not supported.");
        }
        this.mTopsortRelevant = (List)optional.get();
    }

    private Set<String> callClosure(Collection<String> collection) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(collection);
        HashSet<String> hashSet = new HashSet<String>();
        while (!arrayDeque.isEmpty()) {
            String string = (String)arrayDeque.remove();
            if (!hashSet.add(string)) continue;
            arrayDeque.addAll(this.mCalls.getImage((Object)string));
        }
        return hashSet;
    }

    public Collection<String> initialProceduresOfInterest() {
        return this.mIcfg.getInitialNodes().stream().map(IcfgLocation::getProcedure).filter(this::hasLoiOrSuccessorWithLoi).collect(Collectors.toList());
    }

    private boolean hasLoiOrSuccessorWithLoi(String string) {
        return !this.mLOIsInsideProcedure.hasEmptyImage((Object)string) || !this.mSuccessorsOfInterest.hasEmptyImage((Object)string);
    }

    public Set<IcfgLocation> locationsOfInterest(String string) {
        return this.mLOIsInsideProcedure.getImage((Object)string);
    }

    public Set<String> successorsOfInterest(String string) {
        return this.mSuccessorsOfInterest.getImage((Object)string);
    }

    public List<String> relevantProceduresTopsorted() {
        return this.mTopsortRelevant;
    }
}

