/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.sifa.IWorklistWithInputs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class PriorityWorklist<W, I>
implements IWorklistWithInputs<W, I> {
    private final List<W> mIdxToWork;
    private final Map<W, Integer> mWorkToIdx = new HashMap<W, Integer>();
    private final PriorityQueue<Integer> mWorklistOfIndices = new PriorityQueue();
    private final Map<Integer, I> mInputsForElemsInWorklist = new HashMap<Integer, I>();
    private final BinaryOperator<I> mMergeFunction;
    private W mCurrentWork;
    private I mCurrentInput;

    public PriorityWorklist(List<W> list, BinaryOperator<I> binaryOperator) {
        this.mIdxToWork = list;
        list.forEach(object -> {
            Integer n = this.mWorkToIdx.put(object, this.mWorkToIdx.size());
        });
        this.mMergeFunction = binaryOperator;
    }

    @Override
    public void add(W w, I i) {
        Integer n2 = this.mWorkToIdx.get(w);
        if (n2 == null) {
            throw new IllegalArgumentException("Tried to insert element unknown in custom order: " + String.valueOf(w));
        }
        this.mInputsForElemsInWorklist.compute(n2, (n, object2) -> this.addInternal((Integer)n, (I)object2, i));
    }

    private I addInternal(Integer n, I i, I i2) {
        if (i != null) {
            return (I)this.mMergeFunction.apply(i, i2);
        }
        this.mWorklistOfIndices.add(n);
        return i2;
    }

    @Override
    public boolean advance() {
        if (this.mWorklistOfIndices.isEmpty()) {
            return false;
        }
        Integer n = this.mWorklistOfIndices.poll();
        this.mCurrentWork = this.mIdxToWork.get(n);
        this.mCurrentInput = this.mInputsForElemsInWorklist.remove(n);
        return true;
    }

    @Override
    public W getWork() {
        return this.mCurrentWork;
    }

    @Override
    public I getInput() {
        return this.mCurrentInput;
    }

    public String toString() {
        return this.mWorklistOfIndices.stream().sorted(this.mWorklistOfIndices.comparator()).map(this::workIdxToString).collect(Collectors.joining("\n"));
    }

    private String workIdxToString(Integer n) {
        return String.format("%s=%s", this.mIdxToWork.get(n), this.mInputsForElemsInWorklist.get(n));
    }
}

