/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.buchiprogramproduct.productgenerator;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.Activator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.ProductBacktranslator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.productgenerator.ProductLocationNameGenerator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.productgenerator.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.BuchiProgramAcceptingStateAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LTLStepAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class ProductGenerator {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final ProductBacktranslator mBacktranslator;
    private final BuchiProgramAcceptingStateAnnotation mAcceptingNodeAnnotation;
    private final BoogieIcfgContainer mRcfgRoot;
    private final BoogieIcfgContainer mProductRoot;
    private final INestedWordAutomaton<CodeBlock, String> mNWA;
    private final CodeBlockFactory mCodeblockFactory;
    private final ProductLocationNameGenerator mNameGenerator;
    private final Set<BoogieIcfgLocation> mRCFGLocations;
    private final Set<BoogieIcfgLocation> mRcfgSinks;
    private final Set<BoogieIcfgLocation> mHelperProductStates;
    private final Map<BoogieIcfgLocation, BoogieIcfgLocation> mResultProgramPointsNoNwa;
    private final NestedMap2<BoogieIcfgLocation, String, BoogieIcfgLocation> mResultProgramPointsProduct;
    private final Map<BoogieIcfgLocation, List<Call>> mOrigRcfgCallLocs2CallEdges;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final boolean mEverythingIsAStep;

    public ProductGenerator(INestedWordAutomaton<CodeBlock, String> iNestedWordAutomaton, BoogieIcfgContainer boogieIcfgContainer, LTLPropertyCheck lTLPropertyCheck, IUltimateServiceProvider iUltimateServiceProvider, ProductBacktranslator productBacktranslator, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mNWA = iNestedWordAutomaton;
        this.mRcfgRoot = boogieIcfgContainer;
        this.mCodeblockFactory = this.mRcfgRoot.getCodeBlockFactory();
        this.mBacktranslator = productBacktranslator;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mRCFGLocations = new HashSet<BoogieIcfgLocation>();
        this.mResultProgramPointsNoNwa = new HashMap<BoogieIcfgLocation, BoogieIcfgLocation>();
        this.mResultProgramPointsProduct = new NestedMap2();
        this.mOrigRcfgCallLocs2CallEdges = new HashMap<BoogieIcfgLocation, List<Call>>();
        this.mAcceptingNodeAnnotation = new BuchiProgramAcceptingStateAnnotation();
        this.mRcfgSinks = new HashSet<BoogieIcfgLocation>();
        this.mHelperProductStates = new HashSet<BoogieIcfgLocation>();
        this.mNameGenerator = new ProductLocationNameGenerator();
        this.mEverythingIsAStep = new IcfgEdgeIterator((IIcfg)this.mRcfgRoot).asStream().allMatch(icfgEdge -> LTLStepAnnotation.getAnnotation((IElement)icfgEdge) == null);
        if (this.mEverythingIsAStep) {
            this.mLogger.info((Object)"The program has no step specification, so we assume maximum atomicity");
        }
        this.mProductRoot = this.mRcfgRoot;
        this.mProductRoot.getProgramPoints().clear();
        lTLPropertyCheck.annotate((IElement)this.mProductRoot);
        this.collectRcfgLocations();
        this.createProductStates();
        this.createEdges();
        this.generateTransFormulas();
    }

    public BoogieIcfgContainer getProductRcfg() {
        return this.mProductRoot;
    }

    private void collectRcfgLocations() {
        LinkedHashSet<BoogieIcfgLocation> linkedHashSet = new LinkedHashSet<BoogieIcfgLocation>();
        for (Map.Entry boogieIcfgLocation : this.mRcfgRoot.getProcedureEntryNodes().entrySet()) {
            linkedHashSet.add((BoogieIcfgLocation)boogieIcfgLocation.getValue());
        }
        while (!linkedHashSet.isEmpty()) {
            IcfgEdge icfgEdge222;
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)linkedHashSet.iterator().next();
            linkedHashSet.remove(boogieIcfgLocation);
            this.mRCFGLocations.add(boogieIcfgLocation);
            for (IcfgEdge icfgEdge222 : boogieIcfgLocation.getOutgoingEdges()) {
                if (this.mRCFGLocations.contains(icfgEdge222.getTarget()) || linkedHashSet.contains(icfgEdge222.getTarget())) continue;
                linkedHashSet.add((BoogieIcfgLocation)icfgEdge222.getTarget());
            }
            if (ProductGenerator.isNonProductNode(boogieIcfgLocation) || boogieIcfgLocation.getOutgoingEdges().stream().filter(icfgEdge -> !ProductGenerator.isNonProductNode((BoogieIcfgLocation)icfgEdge.getTarget())).findAny().isPresent()) continue;
            this.mRcfgSinks.add(boogieIcfgLocation);
            icfgEdge222 = ProductGenerator.generateNeverClaimAssumeStatement((Expression)new BooleanLiteral(null, true));
            StatementSequence statementSequence = this.mCodeblockFactory.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation, (Statement)icfgEdge222);
            new LTLStepAnnotation().annotate((IElement)statementSequence);
        }
    }

    private void createProductStates() {
        for (BoogieIcfgLocation boogieIcfgLocation : this.mRCFGLocations) {
            BoogieIcfgLocation boogieIcfgLocation2;
            if (ProductGenerator.isNonProductNode(boogieIcfgLocation)) {
                Object object = ProductLocationNameGenerator.generateStateName(boogieIcfgLocation);
                BoogieIcfgLocation boogieIcfgLocation3 = this.createProductProgramPoint((DebugIdentifier)object, boogieIcfgLocation);
                boogieIcfgLocation2 = this.mResultProgramPointsNoNwa.put(boogieIcfgLocation, boogieIcfgLocation3);
                if (boogieIcfgLocation2 != null) {
                    throw new AssertionError((Object)"Constructed program point twice");
                }
                continue;
            }
            for (Object object : this.mNWA.getStates()) {
                BoogieIcfgLocation boogieIcfgLocation4;
                BoogieIcfgLocation boogieIcfgLocation5 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.put((Object)boogieIcfgLocation, object, (Object)(boogieIcfgLocation4 = this.createProductProgramPoint((DebugIdentifier)(boogieIcfgLocation2 = ProductLocationNameGenerator.generateStateName(boogieIcfgLocation, (String)object)), boogieIcfgLocation)));
                if (boogieIcfgLocation5 != null) {
                    throw new AssertionError((Object)"Constructed program point twice");
                }
                if (!this.mNWA.isFinal(object)) continue;
                this.mAcceptingNodeAnnotation.annotate((IElement)boogieIcfgLocation4);
            }
        }
    }

    private static boolean isNonProductNode(BoogieIcfgLocation boogieIcfgLocation) {
        String string = boogieIcfgLocation.getProcedure();
        return "ULTIMATE.init".equals(string) || "ULTIMATE.start".equals(string);
    }

    private void createEdges() {
        this.createAllEdgesExceptReturn();
        this.createAllReturnEdges();
    }

    private void createAllReturnEdges() {
        for (BoogieIcfgLocation boogieIcfgLocation : this.mRCFGLocations) {
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getOutgoingEdges()) {
                if (!(icfgEdge instanceof Return)) continue;
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Handling return edge from " + String.valueOf(icfgEdge.getSource()) + " to " + String.valueOf(icfgEdge.getTarget())));
                }
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)icfgEdge.getTarget();
                Return return_ = (Return)icfgEdge;
                if (ProductGenerator.isNonProductNode(boogieIcfgLocation) && ProductGenerator.isNonProductNode(boogieIcfgLocation2)) {
                    this.createReturnEdgesNonProduct(boogieIcfgLocation, boogieIcfgLocation2, return_);
                    continue;
                }
                if (ProductGenerator.isNonProductNode(boogieIcfgLocation)) {
                    this.createReturnEdgesNonProductToProduct(boogieIcfgLocation, boogieIcfgLocation2, return_);
                    continue;
                }
                this.createReturnEdgesOther(boogieIcfgLocation, return_, false);
            }
        }
    }

    private void createAllEdgesExceptReturn() {
        for (BoogieIcfgLocation boogieIcfgLocation : this.mRCFGLocations) {
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getOutgoingEdges()) {
                if (icfgEdge instanceof Summary && ((Summary)icfgEdge).calledProcedureHasImplementation() || icfgEdge instanceof Return) continue;
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Processing [" + icfgEdge.hashCode() + "][" + icfgEdge.getClass().getSimpleName() + "] " + String.valueOf(icfgEdge.getSource()) + " --> " + String.valueOf(icfgEdge.getTarget())));
                    this.mLogger.debug((Object)("\t" + String.valueOf(icfgEdge)));
                }
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)icfgEdge.getTarget();
                if (ProductGenerator.isNonProductNode(boogieIcfgLocation) && ProductGenerator.isNonProductNode(boogieIcfgLocation2)) {
                    this.createEdgesNonProduct(boogieIcfgLocation, icfgEdge, boogieIcfgLocation2);
                    continue;
                }
                if (ProductGenerator.isNonProductNode(boogieIcfgLocation)) {
                    this.createEdgeFromNonProductToProduct(boogieIcfgLocation, icfgEdge);
                    continue;
                }
                if (ProductGenerator.isNonProductNode(boogieIcfgLocation2)) {
                    this.createEdgesFromProductToNonProduct(boogieIcfgLocation, icfgEdge, boogieIcfgLocation2);
                    continue;
                }
                this.createEdgesProduct(boogieIcfgLocation, icfgEdge);
            }
        }
    }

    private void createReturnEdgesOther(BoogieIcfgLocation boogieIcfgLocation, Return return_, boolean bl) {
        for (String string : this.mNWA.getStates()) {
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation, (Object)string);
            assert (boogieIcfgLocation2 != null);
            this.handleEdgeReturn(boogieIcfgLocation2, string, return_, bl);
        }
    }

    private void createReturnEdgesNonProductToProduct(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Return return_) {
        BoogieIcfgLocation boogieIcfgLocation3 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation);
        assert (boogieIcfgLocation3 != null);
        assert (this.mOrigRcfgCallLocs2CallEdges.get(return_.getCallerProgramPoint()).size() == 1);
        for (String string : this.mNWA.getStates()) {
            BoogieIcfgLocation boogieIcfgLocation4 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation2, (Object)string);
            this.createNewReturnEdge(boogieIcfgLocation3, return_, boogieIcfgLocation4, this.mOrigRcfgCallLocs2CallEdges.get(return_.getCallerProgramPoint()).get(0));
        }
    }

    private void createReturnEdgesNonProduct(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Return return_) {
        BoogieIcfgLocation boogieIcfgLocation3 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation);
        BoogieIcfgLocation boogieIcfgLocation4 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation2);
        assert (boogieIcfgLocation3 != null);
        assert (boogieIcfgLocation4 != null);
        assert (this.mOrigRcfgCallLocs2CallEdges.get(return_.getCallerProgramPoint()).size() == 1);
        this.createNewReturnEdge(boogieIcfgLocation3, return_, boogieIcfgLocation4, this.mOrigRcfgCallLocs2CallEdges.get(return_.getCallerProgramPoint()).get(0));
    }

    private void createEdgesProduct(BoogieIcfgLocation boogieIcfgLocation, IcfgEdge icfgEdge) {
        boolean bl = this.mEverythingIsAStep || LTLStepAnnotation.getAnnotation((IElement)icfgEdge) != null;
        for (String string : this.mNWA.getStates()) {
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation, (Object)string);
            if (icfgEdge instanceof StatementSequence) {
                this.mLogger.info((Object)(String.valueOf(ProductLocationNameGenerator.generateStateName(boogieIcfgLocation, string)) + " --> " + String.valueOf(ProductLocationNameGenerator.generateStateName(boogieIcfgLocation, string))));
                this.handleEdgeStatementSequence(boogieIcfgLocation2, string, (StatementSequence)icfgEdge, bl);
                continue;
            }
            if (icfgEdge instanceof Call) {
                this.handleEdgeCall(boogieIcfgLocation2, string, (Call)icfgEdge, boogieIcfgLocation, bl);
                continue;
            }
            if (icfgEdge instanceof Summary) {
                this.handleEdgeSummary(boogieIcfgLocation2, string, (Summary)icfgEdge);
                continue;
            }
            throw new UnsupportedOperationException("BuchiProgramProduct does not support RCFGEdges of type " + icfgEdge.getClass().getSimpleName());
        }
    }

    private void createEdgesFromProductToNonProduct(BoogieIcfgLocation boogieIcfgLocation, IcfgEdge icfgEdge, BoogieIcfgLocation boogieIcfgLocation2) throws AssertionError {
        for (String string : this.mNWA.getStates()) {
            BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation, (Object)string);
            BoogieIcfgLocation boogieIcfgLocation4 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation2);
            assert (boogieIcfgLocation3 != null);
            assert (boogieIcfgLocation4 != null);
            if (icfgEdge instanceof Call) {
                this.createNewCallEdge(boogieIcfgLocation, boogieIcfgLocation3, (Call)icfgEdge, boogieIcfgLocation4);
                continue;
            }
            if (icfgEdge instanceof Summary) {
                this.createNewSummaryEdge(boogieIcfgLocation3, (Summary)icfgEdge, boogieIcfgLocation4);
                continue;
            }
            throw new AssertionError((Object)"You cannot go from product to non-product parts without using Call, Return or Summary edges");
        }
    }

    private void createEdgeFromNonProductToProduct(BoogieIcfgLocation boogieIcfgLocation, IcfgEdge icfgEdge) throws AssertionError {
        BoogieIcfgLocation boogieIcfgLocation2 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation);
        if (icfgEdge instanceof Call) {
            this.handleEdgeCallFromNonProduct(boogieIcfgLocation2, (Call)icfgEdge, boogieIcfgLocation);
        } else if (icfgEdge instanceof Summary) {
            this.handleEdgeSummaryFromNonProduct(boogieIcfgLocation2, (Summary)icfgEdge);
        } else {
            throw new AssertionError();
        }
    }

    private void createEdgesNonProduct(BoogieIcfgLocation boogieIcfgLocation, IcfgEdge icfgEdge, BoogieIcfgLocation boogieIcfgLocation2) throws AssertionError {
        BoogieIcfgLocation boogieIcfgLocation3 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation);
        BoogieIcfgLocation boogieIcfgLocation4 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation2);
        assert (boogieIcfgLocation3 != null);
        assert (boogieIcfgLocation4 != null);
        if (icfgEdge instanceof StatementSequence) {
            this.createNewStatementSequence(boogieIcfgLocation3, (StatementSequence)icfgEdge, boogieIcfgLocation4, null, false);
        } else if (icfgEdge instanceof Call) {
            this.createNewCallEdge(boogieIcfgLocation, boogieIcfgLocation3, (Call)icfgEdge, boogieIcfgLocation4);
        } else if (icfgEdge instanceof Summary) {
            this.createNewSummaryEdge(boogieIcfgLocation3, (Summary)icfgEdge, boogieIcfgLocation4);
        } else {
            throw new AssertionError((Object)("Did not expect edge of type " + icfgEdge.getClass().getSimpleName()));
        }
    }

    private static boolean areAllIncomingEdgesReturn(BoogieIcfgLocation boogieIcfgLocation) {
        for (IcfgEdge icfgEdge : boogieIcfgLocation.getIncomingEdges()) {
            if (icfgEdge instanceof Return) continue;
            return false;
        }
        return true;
    }

    private static boolean areAllDirectPredecessorsProductNodes(BoogieIcfgLocation boogieIcfgLocation) {
        for (IcfgLocation icfgLocation : boogieIcfgLocation.getIncomingNodes()) {
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)icfgLocation;
            if (!ProductGenerator.isNonProductNode(boogieIcfgLocation2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areAllDirectSuccessorsNonProductNodes(BoogieIcfgLocation boogieIcfgLocation) {
        for (IcfgLocation icfgLocation : boogieIcfgLocation.getOutgoingNodes()) {
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)icfgLocation;
            if (ProductGenerator.isNonProductNode(boogieIcfgLocation2)) continue;
            return false;
        }
        return true;
    }

    private void removeProductProgramPointAndSuccessors(BoogieIcfgLocation boogieIcfgLocation) {
        BoogieIcfgContainer boogieIcfgContainer;
        HashSet<BoogieIcfgContainer> hashSet = new HashSet<BoogieIcfgContainer>();
        LinkedList<BoogieIcfgLocation> linkedList = new LinkedList<BoogieIcfgLocation>();
        linkedList.add(boogieIcfgLocation);
        while (!linkedList.isEmpty()) {
            boogieIcfgContainer = (BoogieIcfgLocation)linkedList.removeFirst();
            if (hashSet.contains(boogieIcfgContainer)) continue;
            hashSet.add(boogieIcfgContainer);
            for (IcfgEdge boogieIcfgLocation2 : boogieIcfgContainer.getOutgoingEdges()) {
                linkedList.addFirst((BoogieIcfgLocation)boogieIcfgLocation2.getTarget());
            }
        }
        boogieIcfgContainer = this.mProductRoot;
        for (BoogieIcfgLocation boogieIcfgLocation2 : hashSet) {
            BoogieIcfgLocation boogieIcfgLocation3;
            DebugIdentifier debugIdentifier = boogieIcfgLocation2.getDebugIdentifier();
            Map map = (Map)boogieIcfgContainer.getProgramPoints().get(boogieIcfgLocation2.getProcedure());
            if (map != null) {
                map.remove(debugIdentifier);
            }
            boogieIcfgContainer.getLoopLocations().remove(boogieIcfgLocation2);
            BoogieIcfgLocation boogieIcfgLocation4 = (BoogieIcfgLocation)boogieIcfgContainer.getProcedureEntryNodes().get(boogieIcfgLocation2.getProcedure());
            if (boogieIcfgLocation2.equals((Object)boogieIcfgLocation4)) {
                boogieIcfgContainer.getProcedureEntryNodes().remove(boogieIcfgLocation2.getProcedure());
            }
            if (boogieIcfgLocation2.equals((Object)(boogieIcfgLocation3 = (BoogieIcfgLocation)boogieIcfgContainer.getProcedureExitNodes().get(boogieIcfgLocation2.getProcedure())))) {
                boogieIcfgContainer.getProcedureExitNodes().remove(boogieIcfgLocation2.getProcedure());
            }
            if (!ProductLocationNameGenerator.isHelperState(boogieIcfgLocation2)) continue;
            this.mHelperProductStates.remove(boogieIcfgLocation2);
        }
    }

    private void generateTransFormulas() {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(this.mProductRoot, this.mServices, this.mSimplificationTechnique);
        Set set = this.mProductRoot.getProgramPoints().entrySet();
        for (Map.Entry entry : set) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                for (IcfgEdge icfgEdge : ((BoogieIcfgLocation)entry2.getValue()).getOutgoingEdges()) {
                    ProductGenerator.generateTransformula(transFormulaBuilder, (String)entry.getKey(), icfgEdge);
                }
            }
        }
    }

    private static void generateTransformula(TransFormulaBuilder transFormulaBuilder, String string, IcfgEdge icfgEdge) {
        if (icfgEdge instanceof StatementSequence || icfgEdge instanceof Summary) {
            transFormulaBuilder.addTransFormula((CodeBlock)icfgEdge, string);
        }
    }

    private void handleEdgeStatementSequence(BoogieIcfgLocation boogieIcfgLocation, String string, StatementSequence statementSequence, boolean bl) {
        if (bl) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNWA.internalSuccessors((Object)string)) {
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)((BoogieIcfgLocation)statementSequence.getTarget()), (Object)((String)outgoingInternalTransition.getSucc()));
                this.createNewStatementSequence(boogieIcfgLocation, statementSequence, boogieIcfgLocation2, (IActionWithBranchEncoders)outgoingInternalTransition.getLetter(), bl);
            }
        } else {
            BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)((BoogieIcfgLocation)statementSequence.getTarget()), (Object)string);
            this.createNewStatementSequence(boogieIcfgLocation, statementSequence, boogieIcfgLocation3, null, bl);
        }
    }

    private void handleEdgeReturn(BoogieIcfgLocation boogieIcfgLocation, String string, Return return_, boolean bl) {
        BoogieIcfgLocation boogieIcfgLocation2 = return_.getCallerProgramPoint();
        assert (boogieIcfgLocation2 != null);
        assert (this.mOrigRcfgCallLocs2CallEdges != null);
        if (this.mOrigRcfgCallLocs2CallEdges.get(boogieIcfgLocation2) == null) {
            Call call = return_.getCorrespondingCall();
            this.mLogger.warn((Object)("Ignoring return edge from " + String.valueOf(return_.getSource()) + " to " + String.valueOf(return_.getTarget()) + " (Corresponding call: " + String.valueOf(call) + " from " + String.valueOf(call.getSource()) + ")"));
            return;
        }
        BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)return_.getTarget();
        DebugIdentifier debugIdentifier = this.mNameGenerator.generateHelperStateName(boogieIcfgLocation3.getDebugIdentifier());
        BoogieIcfgLocation boogieIcfgLocation4 = this.createProductProgramPoint(debugIdentifier, boogieIcfgLocation3);
        for (Call call : this.mOrigRcfgCallLocs2CallEdges.get(boogieIcfgLocation2)) {
            this.createNewReturnEdge(boogieIcfgLocation, return_, boogieIcfgLocation4, call);
        }
        for (Call call : this.mNWA.internalSuccessors((Object)string)) {
            if (!bl && !((String)call.getSucc()).equals(string)) continue;
            BoogieIcfgLocation boogieIcfgLocation5 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation3, (Object)((String)call.getSucc()));
            if (boogieIcfgLocation5 == null) {
                boogieIcfgLocation5 = this.mResultProgramPointsNoNwa.get(boogieIcfgLocation3);
            }
            this.createNewStatementSequence(boogieIcfgLocation4, null, boogieIcfgLocation5, (IActionWithBranchEncoders)call.getLetter(), bl);
        }
    }

    private void handleEdgeSummary(BoogieIcfgLocation boogieIcfgLocation, String string, Summary summary) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(this.mProductRoot, this.mServices, this.mSimplificationTechnique);
        for (OutgoingInternalTransition outgoingInternalTransition : this.mNWA.internalSuccessors((Object)string)) {
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)((BoogieIcfgLocation)summary.getTarget()), (Object)((String)outgoingInternalTransition.getSucc()));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StatementSequence statementSequence = this.mCodeblockFactory.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, ProductGenerator.checkLetter((IActionWithBranchEncoders)outgoingInternalTransition.getLetter()));
            transFormulaBuilder.addTransFormula((CodeBlock)statementSequence, ((IcfgLocation)summary.getSource()).getProcedure());
            arrayList.add(this.createNewSummaryEdge(boogieIcfgLocation, summary, boogieIcfgLocation2));
            arrayList.add(statementSequence);
            this.mCodeblockFactory.constructSequentialCompositionAndDisconnectEdges(boogieIcfgLocation, boogieIcfgLocation2, true, true, arrayList, this.mSimplificationTechnique);
        }
    }

    private void handleEdgeSummaryFromNonProduct(BoogieIcfgLocation boogieIcfgLocation, Summary summary) {
        BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)summary.getTarget();
        for (String string : this.mNWA.getInitialStates()) {
            BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation2, (Object)string);
            this.createNewSummaryEdge(boogieIcfgLocation, summary, boogieIcfgLocation3);
        }
    }

    private void handleEdgeCall(BoogieIcfgLocation boogieIcfgLocation, String string, Call call, BoogieIcfgLocation boogieIcfgLocation2, boolean bl) {
        DebugIdentifier debugIdentifier = this.mNameGenerator.generateHelperStateName(boogieIcfgLocation.getDebugIdentifier());
        BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)call.getTarget();
        BoogieIcfgLocation boogieIcfgLocation4 = this.createProductProgramPoint(debugIdentifier, boogieIcfgLocation3);
        this.createNewCallEdge(boogieIcfgLocation2, boogieIcfgLocation, call, boogieIcfgLocation4);
        for (OutgoingInternalTransition outgoingInternalTransition : this.mNWA.internalSuccessors((Object)string)) {
            BoogieIcfgLocation boogieIcfgLocation5 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation3, (Object)((String)outgoingInternalTransition.getSucc()));
            if (!bl && !((String)outgoingInternalTransition.getSucc()).equals(string)) continue;
            this.createNewStatementSequence(boogieIcfgLocation4, null, boogieIcfgLocation5, (IActionWithBranchEncoders)outgoingInternalTransition.getLetter(), bl);
        }
    }

    private void handleEdgeCallFromNonProduct(BoogieIcfgLocation boogieIcfgLocation, Call call, BoogieIcfgLocation boogieIcfgLocation2) {
        BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)call.getTarget();
        for (String string : this.mNWA.getInitialStates()) {
            BoogieIcfgLocation boogieIcfgLocation4 = (BoogieIcfgLocation)this.mResultProgramPointsProduct.get((Object)boogieIcfgLocation3, (Object)string);
            this.createNewCallEdge(boogieIcfgLocation2, boogieIcfgLocation, call, boogieIcfgLocation4);
        }
    }

    private Summary createNewSummaryEdge(BoogieIcfgLocation boogieIcfgLocation, Summary summary, BoogieIcfgLocation boogieIcfgLocation2) {
        assert (boogieIcfgLocation != null);
        assert (boogieIcfgLocation2 != null);
        Summary summary2 = this.mCodeblockFactory.constructSummary(boogieIcfgLocation, boogieIcfgLocation2, summary.getCallStatement(), false);
        summary2.setTransitionFormula(summary.getTransformula());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Created summary edge (" + String.valueOf(boogieIcfgLocation) + ", " + String.valueOf(boogieIcfgLocation2) + ") for call " + BoogiePrettyPrinter.print((Statement)summary.getCallStatement())));
        }
        return summary2;
    }

    private Return createNewReturnEdge(BoogieIcfgLocation boogieIcfgLocation, Return return_, BoogieIcfgLocation boogieIcfgLocation2, Call call) {
        assert (boogieIcfgLocation != null);
        assert (boogieIcfgLocation2 != null);
        Return return_2 = this.mCodeblockFactory.constructReturn(boogieIcfgLocation, boogieIcfgLocation2, call);
        return_2.setTransitionFormula(return_.getTransformula());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Created return edge (" + String.valueOf(boogieIcfgLocation) + ", " + String.valueOf(boogieIcfgLocation2) + ") for call from " + String.valueOf(call.getSource())));
        }
        this.mapNewEdge2OldEdge((IcfgEdge)return_2, (IcfgEdge)return_);
        return return_2;
    }

    private Call createNewCallEdge(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, Call call, BoogieIcfgLocation boogieIcfgLocation3) {
        assert (boogieIcfgLocation2 != null);
        assert (boogieIcfgLocation3 != null);
        Call call2 = this.mCodeblockFactory.constructCall(boogieIcfgLocation2, boogieIcfgLocation3, call.getCallStatement());
        call2.setTransitionFormula(call.getTransformula());
        this.mapNewEdge2OldEdge((IcfgEdge)call2, (IcfgEdge)call);
        List<Call> list = this.mOrigRcfgCallLocs2CallEdges.get(boogieIcfgLocation);
        if (list == null) {
            list = new ArrayList<Call>();
            this.mOrigRcfgCallLocs2CallEdges.put(boogieIcfgLocation, list);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Adding call to " + String.valueOf(call2) + " for " + String.valueOf(boogieIcfgLocation2) + ", " + String.valueOf(boogieIcfgLocation3) + " under " + String.valueOf(boogieIcfgLocation)));
        }
        list.add(call2);
        return call2;
    }

    private BoogieIcfgLocation createProductProgramPoint(DebugIdentifier debugIdentifier, BoogieIcfgLocation boogieIcfgLocation) {
        BoogieIcfgLocation boogieIcfgLocation2;
        BoogieIcfgLocation boogieIcfgLocation3;
        Predicate<IAnnotations> predicate = iAnnotations -> !(iAnnotations instanceof LTLStepAnnotation);
        BoogieIcfgLocation boogieIcfgLocation4 = new BoogieIcfgLocation(debugIdentifier, boogieIcfgLocation.getProcedure(), false, boogieIcfgLocation.getBoogieASTNode(), predicate);
        HashMap<DebugIdentifier, BoogieIcfgLocation> hashMap = (HashMap<DebugIdentifier, BoogieIcfgLocation>)this.mProductRoot.getProgramPoints().get(boogieIcfgLocation.getProcedure());
        if (hashMap == null) {
            hashMap = new HashMap<DebugIdentifier, BoogieIcfgLocation>();
            this.mProductRoot.getProgramPoints().put(boogieIcfgLocation.getProcedure(), hashMap);
        }
        hashMap.put(debugIdentifier, boogieIcfgLocation4);
        if (this.mProductRoot.getLoopLocations().remove(boogieIcfgLocation)) {
            this.mProductRoot.getLoopLocations().add(boogieIcfgLocation4);
        }
        if (this.mProductRoot.getInitialNodes().remove(boogieIcfgLocation)) {
            this.mProductRoot.getInitialNodes().add(boogieIcfgLocation4);
        }
        if ((boogieIcfgLocation3 = (BoogieIcfgLocation)this.mProductRoot.getProcedureEntryNodes().get(boogieIcfgLocation.getProcedure())) != null && boogieIcfgLocation == boogieIcfgLocation3) {
            this.mProductRoot.getProcedureEntryNodes().put(boogieIcfgLocation.getProcedure(), boogieIcfgLocation4);
        }
        if ((boogieIcfgLocation2 = (BoogieIcfgLocation)this.mProductRoot.getProcedureExitNodes().get(boogieIcfgLocation.getProcedure())) != null && boogieIcfgLocation == boogieIcfgLocation2) {
            this.mProductRoot.getProcedureExitNodes().put(boogieIcfgLocation.getProcedure(), boogieIcfgLocation4);
        }
        if (ProductLocationNameGenerator.isHelperState(boogieIcfgLocation4)) {
            this.mHelperProductStates.add(boogieIcfgLocation4);
        }
        return boogieIcfgLocation4;
    }

    private StatementSequence createNewStatementSequence(BoogieIcfgLocation boogieIcfgLocation, StatementSequence statementSequence, BoogieIcfgLocation boogieIcfgLocation2, IActionWithBranchEncoders iActionWithBranchEncoders, boolean bl) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        if (statementSequence != null) {
            arrayList.addAll(statementSequence.getStatements());
        }
        if (bl) {
            arrayList.addAll(ProductGenerator.checkLetter(iActionWithBranchEncoders));
        }
        assert (boogieIcfgLocation != null);
        assert (boogieIcfgLocation2 != null);
        StatementSequence statementSequence2 = statementSequence == null ? this.mCodeblockFactory.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, arrayList) : this.mCodeblockFactory.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, arrayList);
        this.mapNewEdge2OldEdge((IcfgEdge)statementSequence2, (IcfgEdge)statementSequence);
        return statementSequence2;
    }

    private static List<Statement> checkLetter(IActionWithBranchEncoders iActionWithBranchEncoders) {
        if (iActionWithBranchEncoders == null) {
            return Collections.emptyList();
        }
        if (iActionWithBranchEncoders instanceof StatementSequence) {
            StatementSequence statementSequence = (StatementSequence)iActionWithBranchEncoders;
            return statementSequence.getStatements();
        }
        throw new UnsupportedOperationException("Letter has to be a statement sequence, but is " + iActionWithBranchEncoders.getClass().getSimpleName());
    }

    private void mapNewEdge2OldEdge(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        this.mBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge, (IIcfgTransition<IcfgLocation>)icfgEdge2);
    }

    private static AssumeStatement generateNeverClaimAssumeStatement(Expression expression) {
        return new AssumeStatement(null, expression);
    }
}

