/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IteratedSymbolicMemory {
    private final IUltimateServiceProvider mServices;
    private final Map<IProgramVar, Term> mIteratedMemory;
    private final Map<IProgramVar, Term> mMemoryMapping;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private final Loop mLoop;
    private final List<TermVariable> mPathCounters;
    private final Map<TermVariable, TermVariable> mNewPathCounters;
    private final ManagedScript mScript;
    private final ILogger mLogger;
    private Term mAbstractPathCondition;
    private UnmodifiableTransFormula mAbstractFormula;
    private boolean mOverapprox;
    private final List<Term> mTerms;
    private final List<IProgramVar> mIllegal;

    public IteratedSymbolicMemory(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Loop loop, List<TermVariable> list, Map<TermVariable, TermVariable> map) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mIteratedMemory = new HashMap<IProgramVar, Term>();
        this.mPathCounters = list;
        this.mNewPathCounters = map;
        this.mScript = managedScript;
        this.mAbstractPathCondition = this.mScript.getScript().term("true", new Term[0]);
        this.mLoop = loop;
        this.mInVars = this.mLoop.getInVars();
        this.mOutVars = this.mLoop.getOutVars();
        this.mAbstractFormula = null;
        this.mOverapprox = false;
        this.mTerms = new ArrayList<Term>();
        this.mIllegal = new ArrayList<IProgramVar>();
        if (list.size() > 1) {
            this.mOverapprox = true;
        }
        this.mMemoryMapping = new HashMap<IProgramVar, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mOutVars.entrySet()) {
            if (this.mMemoryMapping.containsKey(entry.getKey())) continue;
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mMemoryMapping.entrySet()) {
            this.mIteratedMemory.put(entry.getKey(), null);
        }
    }

    public void updateMemory() {
        for (Map.Entry<IProgramVar, Term> iProgramVar : this.mIteratedMemory.entrySet()) {
            Term term;
            Term term2 = term = this.mMemoryMapping.get(iProgramVar.getKey());
            caseType caseType2 = caseType.NOT_CHANGED;
            caseType caseType3 = caseType.NOT_CHANGED;
            for (Backbone backbone : this.mLoop.getBackbones()) {
                if (!caseType2.equals((Object)caseType3) && !caseType3.equals((Object)caseType.NOT_CHANGED)) {
                    term2 = null;
                    this.mLogger.debug((Object)("None of the cases applicable " + String.valueOf(iProgramVar.getKey()) + " value = unknown"));
                    break;
                }
                Term term3 = backbone.getSymbolicMemory().getValue(iProgramVar.getKey());
                TransFormula transFormula = backbone.getFormula();
                if (term3 == null || term3.equals(term) || term3 instanceof TermVariable) continue;
                if (term3 instanceof ConstantTerm || !transFormula.getAssignedVars().contains(iProgramVar.getKey())) {
                    term2 = term3;
                    caseType3 = caseType2;
                    caseType2 = caseType.CONSTANT_ASSIGNMENT;
                    this.mOverapprox = true;
                    this.mLogger.debug((Object)"Assignment");
                    continue;
                }
                if ("+".equals(((ApplicationTerm)term3).getFunction().getName())) {
                    this.mLogger.debug((Object)"Addition");
                    term2 = this.mScript.getScript().term("+", new Term[]{term2, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)term3).getParameters()[1], backbone.getPathCounter()})});
                    caseType3 = caseType2;
                    caseType2 = caseType.ADDITION;
                }
                if ("-".equals(((ApplicationTerm)term3).getFunction().getName())) {
                    this.mLogger.debug((Object)"Subtraction");
                    term2 = this.mScript.getScript().term("-", new Term[]{term2, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)term3).getParameters()[1], backbone.getPathCounter()})});
                    caseType3 = caseType2;
                    caseType2 = caseType.SUBTRACTION;
                }
                if ("*".equals(((ApplicationTerm)term3).getFunction().getName())) {
                    this.mIllegal.add(iProgramVar.getKey());
                    this.mLogger.debug((Object)"Multiplication");
                    term2 = this.mScript.getScript().term("*", new Term[]{term2, this.mScript.getScript().term("*", new Term[]{((ApplicationTerm)term3).getParameters()[0], backbone.getPathCounter()})});
                    caseType3 = caseType2;
                    caseType2 = caseType.MULTIPLICATION;
                }
                if (Arrays.asList(((ApplicationTerm)term3).getParameters()).contains(term) || !Arrays.asList(((ApplicationTerm)term3).getParameters()).contains(backbone.getPathCounter())) continue;
                this.mLogger.debug((Object)"Constant assignment");
                HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
                Term term4 = this.mScript.getScript().term("-", new Term[]{backbone.getPathCounter(), Rational.ONE.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript))});
                hashMap.put(backbone.getPathCounter(), term4);
                term2 = Substitution.apply((ManagedScript)this.mScript, hashMap, (Term)term3);
            }
            this.mIteratedMemory.replace(iProgramVar.getKey(), term2);
        }
        for (IProgramVar iProgramVar : this.mIllegal) {
            this.mOverapprox = true;
            this.mIteratedMemory.remove(iProgramVar);
            this.mMemoryMapping.remove(iProgramVar);
        }
    }

    public void updateCondition() {
        Backbone backbone22;
        for (Backbone backbone22 : this.mLoop.getBackbones()) {
            TermVariable termVariable2;
            Object object;
            ArrayList<Object> object4 = new ArrayList<Object>();
            Iterator<TermVariable> iterator = new ArrayList();
            Term term = this.mLoop.updateVars(backbone22.getCondition().getFormula(), backbone22.getCondition().getInVars(), backbone22.getCondition().getOutVars());
            Object object2 = term.getFreeVars();
            int n = ((TermVariable[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                if (this.mPathCounters.contains(object)) {
                    object4.add(object);
                }
                ++n2;
            }
            if (term instanceof QuantifiedFormula) {
                term = ((QuantifiedFormula)term).getSubformula();
            }
            object = new HashMap();
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term term2 = applicationTerm.getParameters();
            int n3 = ((Term[])term2).length;
            int n4 = 0;
            while (n4 < n3) {
                Term term3 = term2[n4];
                object.putAll(this.termUnravel(term3));
                ++n4;
            }
            Term term4 = Substitution.apply((ManagedScript)this.mScript, (Map)object, (Term)applicationTerm);
            object.clear();
            object.put(backbone22.getPathCounter(), (Term)this.mNewPathCounters.get(backbone22.getPathCounter()));
            term4 = Substitution.apply((ManagedScript)this.mScript, (Map)object, (Term)term4);
            object2 = new ArrayList<TermVariable>(this.mPathCounters);
            object2.remove(backbone22.getPathCounter());
            ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>(this.mNewPathCounters.values());
            arrayList.remove(this.mNewPathCounters.get(backbone22.getPathCounter()));
            term2 = this.mScript.getScript().term("<", new Term[]{(Term)this.mNewPathCounters.get(backbone22.getPathCounter()), backbone22.getPathCounter()});
            Term term5 = this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), (Term)this.mNewPathCounters.get(backbone22.getPathCounter())});
            Term term6 = this.mScript.getScript().term("and", new Term[]{term2, term5});
            TermVariable[] termVariableArray = object2.iterator();
            while (termVariableArray.hasNext()) {
                termVariable2 = (TermVariable)termVariableArray.next();
                iterator.add((TermVariable)this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), (Term)this.mNewPathCounters.get(termVariable2), termVariable2}));
            }
            for (TermVariable termVariable2 : object4) {
                iterator.add((TermVariable)this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), termVariable2}));
            }
            iterator.add((TermVariable)term4);
            termVariable2 = SmtUtils.and((Script)this.mScript.getScript(), iterator);
            iterator.clear();
            if (!object4.isEmpty()) {
                termVariable2 = this.mScript.getScript().quantifier(0, object4.toArray(new TermVariable[object4.size()]), (Term)termVariable2, (Term[][])new Term[0][]);
            }
            iterator.add(termVariable2);
            termVariable2 = SmtUtils.and((Script)this.mScript.getScript(), iterator);
            iterator.clear();
            if (!arrayList.isEmpty()) {
                termVariable2 = this.mScript.getScript().quantifier(0, arrayList.toArray(new TermVariable[arrayList.size()]), (Term)termVariable2, (Term[][])new Term[0][]);
            }
            iterator.add(termVariable2);
            termVariable2 = SmtUtils.and((Script)this.mScript.getScript(), iterator);
            term6 = Util.implies((Script)this.mScript.getScript(), (Term[])new Term[]{term6, termVariable2});
            termVariableArray = new TermVariable[]{this.mNewPathCounters.get(backbone22.getPathCounter())};
            Term term7 = this.mScript.getScript().quantifier(1, termVariableArray, term6, (Term[][])new Term[0][]);
            this.mTerms.add(PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term7));
        }
        backbone22 = new TransFormulaBuilder(this.mInVars, this.mOutVars, true, null, true, null, false);
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.mOutVars.entrySet()) {
            if (IteratedSymbolicMemory.checkIfVarContained((TermVariable)entry.getValue(), this.mAbstractPathCondition) || !this.mIteratedMemory.containsKey(entry.getKey())) continue;
            arrayList.add(this.mScript.getScript().term("=", new Term[]{(Term)entry.getValue(), this.mIteratedMemory.get(entry.getKey())}));
        }
        for (TermVariable termVariable : this.mPathCounters) {
            arrayList.add(this.mScript.getScript().term("<=", new Term[]{Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript)), termVariable}));
        }
        this.mAbstractPathCondition = SmtUtils.or((Script)this.mScript.getScript(), (Term[])this.mTerms.toArray(new Term[this.mTerms.size()]));
        arrayList.add(this.mAbstractPathCondition);
        this.mAbstractPathCondition = SmtUtils.and((Script)this.mScript.getScript(), (Term[])arrayList.toArray(new Term[arrayList.size()]));
        backbone22.setFormula(this.mAbstractPathCondition);
        backbone22.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        backbone22.addAuxVarsButRenameToFreshCopies(this.mNewPathCounters.keySet(), this.mScript);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(this.mLoop.getVars());
        backbone22.addAuxVarsButRenameToFreshCopies(hashSet, this.mScript);
        this.mAbstractFormula = backbone22.finishConstruction(this.mScript);
        this.mLogger.debug((Object)("ITERATEDSYMBOLIC MEMORY: " + String.valueOf(this.mAbstractPathCondition)));
    }

    public Term updateBackboneTerm(Backbone backbone) {
        Term term = backbone.getFormula().getFormula();
        Map<Term, Term> map = this.termUnravel(term);
        return Substitution.apply((ManagedScript)this.mScript, map, (Term)term);
    }

    private static boolean checkIfVarContained(TermVariable termVariable, Term term) {
        Term term2 = term;
        if (term2 instanceof TermVariable) {
            return term2.equals(termVariable);
        }
        if (term2 instanceof ConstantTerm) {
            return false;
        }
        if (term2 instanceof QuantifiedFormula) {
            term2 = ((QuantifiedFormula)term2).getSubformula();
        }
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>(Arrays.asList(((ApplicationTerm)term2).getParameters()));
        while (!arrayDeque.isEmpty()) {
            Term term3 = (Term)arrayDeque.pop();
            if (term3 instanceof ConstantTerm || term3 instanceof TermVariable) continue;
            if (term3 instanceof QuantifiedFormula) {
                term3 = ((QuantifiedFormula)term3).getSubformula();
            }
            if (Arrays.asList(((ApplicationTerm)term3).getParameters()).contains(termVariable) && "=".equals(((ApplicationTerm)term3).getFunction().getName())) {
                return true;
            }
            arrayDeque.addAll(Arrays.asList(((ApplicationTerm)term3).getParameters()));
        }
        return false;
    }

    private Map<Term, Term> termUnravel(Term term) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        if (term instanceof QuantifiedFormula || term instanceof ConstantTerm) {
            return hashMap;
        }
        if (term instanceof TermVariable) {
            TermVariable termVariable = (TermVariable)term;
            for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
                if (!termVariable.equals(entry.getValue()) || this.mIteratedMemory.get(entry.getKey()) instanceof ConstantTerm) continue;
                hashMap.put(term, this.mIteratedMemory.get(entry.getKey()));
                break;
            }
            return hashMap;
        }
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.add(term);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.pop();
            if (term2 instanceof ConstantTerm || term2 instanceof TermVariable) continue;
            if (term2 instanceof QuantifiedFormula) {
                term2 = ((QuantifiedFormula)term2).getSubformula();
            }
            for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
                if (!Arrays.asList(((ApplicationTerm)term2).getParameters()).contains(entry.getValue()) || this.mIteratedMemory.get(entry.getKey()) instanceof ConstantTerm) continue;
                Sort sort = term2.getSort();
                if (sort.equals(this.mScript.getScript().sort("Int", new Sort[0]))) {
                    hashMap.put(term2, this.mIteratedMemory.get(entry.getKey()));
                }
                if (!sort.equals(this.mScript.getScript().sort("Bool", new Sort[0]))) continue;
                Term[] termArray = ((ApplicationTerm)term2).getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term3 = termArray[n2];
                    hashMap.putAll(this.termUnravel(term3));
                    ++n2;
                }
            }
            arrayDeque.addAll(Arrays.asList(((ApplicationTerm)term2).getParameters()));
        }
        return hashMap;
    }

    public Term updateBackboneTerm(TransFormula transFormula) {
        Term term = transFormula.getFormula();
        Map<Term, Term> map = this.termUnravel(term);
        return Substitution.apply((ManagedScript)this.mScript, map, (Term)term);
    }

    public Map<IProgramVar, Term> getIteratedMemory() {
        return this.mIteratedMemory;
    }

    public List<TermVariable> getPathCounters() {
        return this.mPathCounters;
    }

    public Term getAbstractCondition() {
        return this.mAbstractPathCondition;
    }

    public UnmodifiableTransFormula getAbstractFormula() {
        return this.mAbstractFormula;
    }

    public boolean isOverapprox() {
        return this.mOverapprox;
    }

    private static enum caseType {
        NOT_CHANGED,
        ADDITION,
        SUBTRACTION,
        MULTIPLICATION,
        CONSTANT_ASSIGNMENT,
        CONSTANT_ASSIGNMENT_PATHCOUNTER;

    }
}

