/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DuplicatedDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmallBlockEncoder
extends BaseBlockEncoder<IcfgLocation> {
    private static final int DNF_ONLY_IF_LESS_THAN = 35;
    private final IcfgEdgeBuilder mEdgeBuilder;
    private DnfTransformer mDnfTransformer;
    private NnfTransformer mNnfTransformer;
    private final Map<DebugIdentifier, Integer> mCloneCount;
    private Script mScript;

    public SmallBlockEncoder(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mEdgeBuilder = icfgEdgeBuilder;
        this.mCloneCount = new HashMap<DebugIdentifier, Integer>();
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedEdges > 0;
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        CfgSmtToolkit cfgSmtToolkit = basicIcfg.getCfgSmtToolkit();
        this.mDnfTransformer = new DnfTransformer(cfgSmtToolkit.getManagedScript(), this.mServices, n -> n > 35);
        this.mNnfTransformer = new NnfTransformer(cfgSmtToolkit.getManagedScript(), this.mServices, NnfTransformer.QuantifierHandling.KEEP);
        this.mScript = cfgSmtToolkit.getManagedScript().getScript();
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(basicIcfg);
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation = icfgLocationIterator.next();
            this.processLocation(basicIcfg, hashSet, icfgLocation);
        }
        this.removeOldEdges(hashSet);
        return basicIcfg;
    }

    private void processLocation(BasicIcfg<IcfgLocation> basicIcfg, Set<IcfgEdge> set, IcfgLocation icfgLocation) {
        ArrayList arrayList = new ArrayList(icfgLocation.getOutgoingEdges());
        for (IcfgEdge icfgEdge : arrayList) {
            IcfgLocation icfgLocation2;
            IcfgLocation icfgLocation3;
            Term term;
            if (!(icfgEdge instanceof IIcfgInternalTransition) || icfgEdge instanceof Summary) continue;
            if (icfgEdge instanceof IActionWithBranchEncoders && !((IActionWithBranchEncoders)icfgEdge).getTransitionFormulaWithBranchEncoders().getBranchEncoders().isEmpty()) {
                this.mLogger.warn((Object)("Skipping small block encoding for transition with branch encoders: " + String.valueOf(icfgEdge)));
                continue;
            }
            UnmodifiableTransFormula unmodifiableTransFormula = icfgEdge.getTransformula();
            try {
                term = this.mDnfTransformer.transform(unmodifiableTransFormula.getFormula());
            }
            catch (XnfTransformer.AbortBeforeBlowup abortBeforeBlowup) {
                if (!icfgEdge.getTransformula().getAssignedVars().isEmpty()) continue;
                term = this.mNnfTransformer.transform(unmodifiableTransFormula.getFormula());
            }
            Term[] termArray = SmtUtils.getDisjuncts((Term)term);
            if (termArray.length > 1) {
                if (!set.add(icfgEdge)) {
                    this.mLogger.warn((Object)"Unncessecary transformation");
                    continue;
                }
                this.addEdgesFromDisjuncts(icfgEdge, termArray);
                continue;
            }
            Term[] termArray2 = SmtUtils.getConjuncts((Term)term);
            if (termArray2.length == 1) continue;
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            IcfgLocation icfgLocation4 = null;
            ArrayList<Term> arrayList3 = new ArrayList<Term>();
            int n = 0;
            while (n < termArray2.length) {
                icfgLocation3 = SmtUtils.getDisjuncts((Term)termArray2[n]);
                if (((Term[])icfgLocation3).length != 1) {
                    icfgLocation4 = icfgLocation3;
                    int n2 = n + 1;
                    while (n2 < termArray2.length) {
                        arrayList3.add(termArray2[n2]);
                        ++n2;
                    }
                    break;
                }
                arrayList2.add(icfgLocation3[0]);
                ++n;
            }
            if (icfgLocation4 == null) continue;
            if (!set.add(icfgEdge)) {
                this.mLogger.warn((Object)"Unncessecary transformation");
                continue;
            }
            if (arrayList2.isEmpty()) {
                icfgLocation2 = (IcfgLocation)icfgEdge.getSource();
            } else {
                icfgLocation2 = this.createNewLocation(basicIcfg, (IcfgLocation)icfgEdge.getTarget());
                icfgLocation3 = SmtUtils.and((Script)this.mScript, arrayList2);
                IcfgEdge icfgEdge2 = this.mEdgeBuilder.constructAndConnectInternalTransition(icfgEdge, (IcfgLocation)icfgEdge.getSource(), icfgLocation2, (Term)icfgLocation3);
                this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)icfgEdge);
            }
            if (arrayList3.isEmpty()) {
                icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
            } else {
                icfgLocation3 = this.createNewLocation(basicIcfg, (IcfgLocation)icfgEdge.getTarget());
                Term term2 = SmtUtils.and((Script)this.mScript, arrayList3);
                IcfgEdge icfgEdge3 = this.mEdgeBuilder.constructAndConnectInternalTransition(icfgEdge, icfgLocation3, (IcfgLocation)icfgEdge.getTarget(), term2);
                this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge3, (IIcfgTransition<?>)icfgEdge);
            }
            IcfgLocation icfgLocation5 = icfgLocation4;
            int n3 = ((IcfgLocation)icfgLocation5).length;
            int n4 = 0;
            while (n4 < n3) {
                IcfgLocation icfgLocation6 = icfgLocation5[n4];
                IcfgEdge icfgEdge4 = this.mEdgeBuilder.constructAndConnectInternalTransition(icfgEdge, icfgLocation2, icfgLocation3, (Term)icfgLocation6);
                this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge4, (IIcfgTransition<?>)icfgEdge);
                ++n4;
            }
        }
    }

    private void removeOldEdges(Set<IcfgEdge> set) throws AssertionError {
        ArrayList arrayList = new ArrayList();
        set.stream().forEach(icfgEdge -> {
            arrayList.add(new Pair((Object)((IcfgLocation)icfgEdge.getSource()), (Object)((IcfgLocation)icfgEdge.getTarget())));
            icfgEdge.disconnectSource();
            icfgEdge.disconnectTarget();
        });
        for (Pair pair : arrayList) {
            IcfgLocationIterator icfgLocationIterator;
            IcfgLocation icfgLocation = (IcfgLocation)pair.getFirst();
            IcfgLocation icfgLocation3 = (IcfgLocation)pair.getSecond();
            if (icfgLocation3 != null && icfgLocation != null && (icfgLocationIterator = new IcfgLocationIterator(icfgLocation)).asStream().allMatch(icfgLocation2 -> !icfgLocation2.equals((Object)icfgLocation3))) {
                throw new AssertionError((Object)("Disconnected graph by removing connection between " + String.valueOf(icfgLocation.getDebugIdentifier()) + " and " + String.valueOf(icfgLocation3.getDebugIdentifier())));
            }
        }
        this.mRemovedEdges = set.size();
    }

    private IcfgLocation createNewLocation(BasicIcfg<IcfgLocation> basicIcfg, IcfgLocation icfgLocation) {
        DuplicatedDebugIdentifier duplicatedDebugIdentifier;
        DebugIdentifier debugIdentifier = icfgLocation.getDebugIdentifier();
        Integer n = this.mCloneCount.get(debugIdentifier);
        if (n == null) {
            duplicatedDebugIdentifier = new DuplicatedDebugIdentifier(debugIdentifier, 0);
            this.mCloneCount.put(debugIdentifier, 0);
        } else {
            n = n + 1;
            duplicatedDebugIdentifier = new DuplicatedDebugIdentifier(debugIdentifier, n.intValue());
            this.mCloneCount.put(debugIdentifier, n);
        }
        String string = icfgLocation.getProcedure();
        IcfgLocation icfgLocation2 = new IcfgLocation((DebugIdentifier)duplicatedDebugIdentifier, string);
        Set set = (Set)basicIcfg.getProcedureErrorNodes().get(string);
        boolean bl = set != null && set.contains(icfgLocation);
        boolean bl2 = icfgLocation.equals(basicIcfg.getProcedureEntryNodes().get(string));
        boolean bl3 = icfgLocation.equals(basicIcfg.getProcedureExitNodes().get(string));
        boolean bl4 = basicIcfg.getLoopLocations().contains(icfgLocation);
        boolean bl5 = basicIcfg.getInitialNodes().contains(icfgLocation);
        boolean bl6 = basicIcfg.getLocationsOfInterest().contains(icfgLocation);
        basicIcfg.addLocation(icfgLocation2, bl5, bl, bl2, bl3, bl4, bl6);
        return icfgLocation2;
    }

    private void addEdgesFromDisjuncts(IcfgEdge icfgEdge, Term[] termArray) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
        IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            IcfgEdge icfgEdge2 = this.mEdgeBuilder.constructAndConnectInternalTransition(icfgEdge, icfgLocation, icfgLocation2, term);
            this.rememberEdgeMapping((IIcfgTransition<?>)icfgEdge2, (IIcfgTransition<?>)icfgEdge);
            ++n2;
        }
    }
}

