/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLResultExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Assertion;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.AtLabelExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BaseAddrExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BlockLengthExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CastExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnotStmt;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Ensures;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FieldAccessExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FreeableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostDeclaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.GlobalGhostDeclaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.MallocableExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.NotDefinedExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.NullPointer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.OldValueExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Requires;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.SizeOfExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.SyntacticNamingExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ValidExpression;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class ACSLPrettyPrinter {
    private static final String STRING_AND = "&";
    private static final String STRING_MINUS = "-";
    private static final String STRING_TIMES = "*";
    private static final String STRING_PLUS = "+";

    public static String print(ACSLNode aCSLNode) {
        ACSLNode aCSLNode2 = aCSLNode;
        Objects.requireNonNull(aCSLNode2);
        ACSLNode aCSLNode3 = aCSLNode2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CodeAnnotStmt.class, Assertion.class, Expression.class, GhostDeclaration.class, GlobalGhostDeclaration.class, GhostUpdate.class, LoopInvariant.class, Requires.class, Ensures.class}, (Object)aCSLNode3, 0)) {
            case 0: {
                CodeAnnotStmt codeAnnotStmt = (CodeAnnotStmt)aCSLNode3;
                return ACSLPrettyPrinter.print(codeAnnotStmt.getCodeStmt());
            }
            case 1: {
                Assertion assertion = (Assertion)aCSLNode3;
                return "//@ assert " + ACSLPrettyPrinter.printExpression(assertion.getFormula()) + ";";
            }
            case 2: {
                Expression expression = (Expression)aCSLNode3;
                return ACSLPrettyPrinter.printExpression(expression);
            }
            case 3: {
                GhostDeclaration ghostDeclaration = (GhostDeclaration)aCSLNode3;
                return ACSLPrettyPrinter.printGhostDeclaration(ghostDeclaration.getType(), ghostDeclaration.getIdentifier(), ghostDeclaration.getExpr());
            }
            case 4: {
                GlobalGhostDeclaration globalGhostDeclaration = (GlobalGhostDeclaration)aCSLNode3;
                return ACSLPrettyPrinter.printGhostDeclaration(globalGhostDeclaration.getType(), globalGhostDeclaration.getIdentifier(), globalGhostDeclaration.getExpr());
            }
            case 5: {
                GhostUpdate ghostUpdate = (GhostUpdate)aCSLNode3;
                return String.format("//@ ghost %s = %s;", ghostUpdate.getIdentifier(), ACSLPrettyPrinter.printExpression(ghostUpdate.getExpr()));
            }
            case 6: {
                LoopInvariant loopInvariant = (LoopInvariant)aCSLNode3;
                return "//@ loop invariant " + ACSLPrettyPrinter.printExpression(loopInvariant.getFormula()) + ";";
            }
            case 7: {
                Requires requires = (Requires)aCSLNode3;
                return "//@ requires " + ACSLPrettyPrinter.printExpression(requires.getFormula()) + ";";
            }
            case 8: {
                Ensures ensures = (Ensures)aCSLNode3;
                return "//@ ensures " + ACSLPrettyPrinter.printExpression(ensures.getFormula()) + ";";
            }
        }
        return aCSLNode.toString();
    }

    private static String printGhostDeclaration(ACSLType aCSLType, String string, Expression expression) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("//@ ghost ").append(aCSLType.getTypeName()).append(' ').append(string);
        if (expression != null) {
            stringBuilder.append(" = ").append(ACSLPrettyPrinter.printExpression(expression));
        }
        return stringBuilder.append(';').toString();
    }

    private static String printExpression(Expression expression2) {
        Expression expression3 = expression2;
        Objects.requireNonNull(expression3);
        Expression expression4 = expression3;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ACSLResultExpression.class, ArrayAccessExpression.class, AtLabelExpression.class, BaseAddrExpression.class, BinaryExpression.class, BlockLengthExpression.class, BooleanLiteral.class, CastExpression.class, FieldAccessExpression.class, FreeableExpression.class, FunctionApplication.class, IdentifierExpression.class, IfThenElseExpression.class, IntegerLiteral.class, MallocableExpression.class, NotDefinedExpression.class, NullPointer.class, OldValueExpression.class, QuantifierExpression.class, RealLiteral.class, SizeOfExpression.class, StringLiteral.class, SyntacticNamingExpression.class, UnaryExpression.class, ValidExpression.class}, (Object)expression4, 0)) {
            case 0 -> {
                ACSLResultExpression var2_2 = (ACSLResultExpression)expression4;
                yield "\\result";
            }
            case 1 -> {
                ArrayAccessExpression var3_3 = (ArrayAccessExpression)expression4;
                yield "%s[%s]".formatted(ACSLPrettyPrinter.printExpression(var3_3.getArray(), var3_3), ACSLPrettyPrinter.printExpression(var3_3.getIndex()));
            }
            case 2 -> {
                AtLabelExpression var4_4 = (AtLabelExpression)expression4;
                yield "\\at(%s, %s)".formatted(ACSLPrettyPrinter.printExpression(var4_4.getExpression()), var4_4.getLabel());
            }
            case 3 -> {
                BaseAddrExpression var5_5 = (BaseAddrExpression)expression4;
                yield "\\base_addr{%s}".formatted(ACSLPrettyPrinter.printExpression(var5_5.getExpression()));
            }
            case 4 -> {
                BinaryExpression var6_6 = (BinaryExpression)expression4;
                yield ACSLPrettyPrinter.printBinaryExpression(var6_6);
            }
            case 5 -> {
                BlockLengthExpression var7_7 = (BlockLengthExpression)expression4;
                yield "\\block_length{%s}".formatted(ACSLPrettyPrinter.printExpression(var7_7.getExpression()));
            }
            case 6 -> {
                BooleanLiteral var8_8 = (BooleanLiteral)expression4;
                yield "\\" + var8_8.getValue();
            }
            case 7 -> {
                CastExpression var9_9 = (CastExpression)expression4;
                yield "(%s) %s".formatted(var9_9.getCastedType().getTypeName(), ACSLPrettyPrinter.printExpression(var9_9.getExpression(), var9_9));
            }
            case 8 -> {
                FieldAccessExpression var10_10 = (FieldAccessExpression)expression4;
                yield "%s.%s".formatted(ACSLPrettyPrinter.printExpression(var10_10.getStruct(), var10_10), var10_10.getField());
            }
            case 9 -> {
                FreeableExpression var11_11 = (FreeableExpression)expression4;
                yield "\\freeable{%s}".formatted(ACSLPrettyPrinter.printExpression(var11_11.getExpression()));
            }
            case 10 -> {
                FunctionApplication var12_12 = (FunctionApplication)expression4;
                yield "%s(%s)".formatted(var12_12.getIdentifier(), Arrays.stream(var12_12.getArguments()).map(expression -> ACSLPrettyPrinter.printExpression(expression)).collect(Collectors.joining(", ")));
            }
            case 11 -> {
                IdentifierExpression var13_13 = (IdentifierExpression)expression4;
                yield var13_13.getIdentifier();
            }
            case 12 -> {
                IfThenElseExpression var14_14 = (IfThenElseExpression)expression4;
                yield "%s ? %s : %s".formatted(ACSLPrettyPrinter.printExpression(var14_14.getCondition(), var14_14), ACSLPrettyPrinter.printExpression(var14_14.getThenPart(), var14_14), ACSLPrettyPrinter.printExpression(var14_14.getElsePart(), var14_14));
            }
            case 13 -> {
                IntegerLiteral var15_15 = (IntegerLiteral)expression4;
                yield var15_15.getValue();
            }
            case 14 -> {
                MallocableExpression var16_16 = (MallocableExpression)expression4;
                yield "\\mallocable{%s}".formatted(ACSLPrettyPrinter.printExpression(var16_16.getExpression()));
            }
            case 15 -> {
                NotDefinedExpression var17_17 = (NotDefinedExpression)expression4;
                throw new AssertionError((Object)"NotDefinedExpression should not be shown as a string, it should be only used for unsupported ACSL expressions.");
            }
            case 16 -> {
                NullPointer var18_18 = (NullPointer)expression4;
                yield "\\null";
            }
            case 17 -> {
                OldValueExpression var19_19 = (OldValueExpression)expression4;
                yield "\\old(%s)".formatted(ACSLPrettyPrinter.printExpression(var19_19.getExpression()));
            }
            case 18 -> {
                QuantifierExpression var20_20 = (QuantifierExpression)expression4;
                yield ACSLPrettyPrinter.printQuantifierExpression(var20_20);
            }
            case 19 -> {
                RealLiteral var21_21 = (RealLiteral)expression4;
                yield var21_21.getValue();
            }
            case 20 -> {
                SizeOfExpression var22_22 = (SizeOfExpression)expression4;
                yield "sizeof(%s)".formatted(ACSLPrettyPrinter.printExpression(var22_22.getExpression()));
            }
            case 21 -> {
                StringLiteral var23_23 = (StringLiteral)expression4;
                yield "\"%s\"".formatted(var23_23.getValue());
            }
            case 22 -> {
                SyntacticNamingExpression var24_24 = (SyntacticNamingExpression)expression4;
                yield "%s : %s".formatted(var24_24.getIdentifier(), ACSLPrettyPrinter.printExpression(var24_24.getExpression(), var24_24));
            }
            case 23 -> {
                UnaryExpression var25_25 = (UnaryExpression)expression4;
                yield ACSLPrettyPrinter.printUnaryExpression(var25_25);
            }
            case 24 -> {
                ValidExpression var26_26 = (ValidExpression)expression4;
                yield "\\valid(%s)".formatted(ACSLPrettyPrinter.printExpression(var26_26.getExpression()));
            }
            default -> throw new MatchException(null, null);
        };
    }

    private static String printQuantifierExpression(QuantifierExpression quantifierExpression) {
        String string = quantifierExpression.isUniversal() ? "\\forall" : "\\exists";
        String string2 = Arrays.stream(quantifierExpression.getVariables()).map(declaration -> declaration.getType().getTypeName() + " " + declaration.getName()).collect(Collectors.joining(", "));
        return "%s %s; %s".formatted(string, string2, ACSLPrettyPrinter.printExpression(quantifierExpression.getSubformula(), quantifierExpression));
    }

    private static String printUnaryExpression(UnaryExpression unaryExpression) {
        return ACSLPrettyPrinter.unaryOperatorToString(unaryExpression.getOperator()) + ACSLPrettyPrinter.printExpression(unaryExpression.getExpr(), unaryExpression);
    }

    private static String printBinaryExpression(BinaryExpression binaryExpression) {
        String string = ACSLPrettyPrinter.binaryOperatorToString(binaryExpression.getOperator());
        String string2 = ACSLPrettyPrinter.printExpression(binaryExpression.getLeft(), binaryExpression.getOperator(), Associativity.LEFT_ASSOCIATIVE);
        String string3 = ACSLPrettyPrinter.printExpression(binaryExpression.getRight(), binaryExpression.getOperator(), Associativity.RIGHT_ASSOCIATIVE);
        return String.format("%s %s %s", string2, string, string3);
    }

    private static String printExpression(Expression expression, Expression expression2) {
        Precedence precedence;
        String string = ACSLPrettyPrinter.printExpression(expression);
        Precedence precedence2 = ACSLPrettyPrinter.getPrecedence(expression);
        if (precedence2.compareTo(precedence = ACSLPrettyPrinter.getPrecedence(expression2)) > 0) {
            return string;
        }
        return "(" + string + ")";
    }

    private static String printExpression(Expression expression, BinaryExpression.Operator operator, Associativity associativity) {
        BinaryExpression binaryExpression;
        Precedence precedence;
        String string = ACSLPrettyPrinter.printExpression(expression);
        Precedence precedence2 = ACSLPrettyPrinter.getPrecedence(expression);
        if (precedence2.compareTo(precedence = ACSLPrettyPrinter.getPrecedence(operator)) > 0) {
            return string;
        }
        if (expression instanceof BinaryExpression && (binaryExpression = (BinaryExpression)expression).getOperator() == operator && ACSLPrettyPrinter.getAssociativity(operator).satisfies(associativity)) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unaryOperatorToString(UnaryExpression.Operator operator) {
        return switch (operator) {
            case UnaryExpression.Operator.ADDROF -> STRING_AND;
            case UnaryExpression.Operator.LOGICNEG -> "!";
            case UnaryExpression.Operator.LTLFINALLY -> "F";
            case UnaryExpression.Operator.LTLGLOBALLY -> "G";
            case UnaryExpression.Operator.LTLNEXT -> "X";
            case UnaryExpression.Operator.MINUS -> STRING_MINUS;
            case UnaryExpression.Operator.PLUS -> STRING_PLUS;
            case UnaryExpression.Operator.POINTER -> STRING_TIMES;
            case UnaryExpression.Operator.LOGICCOMPLEMENT -> "~";
            default -> throw new MatchException(null, null);
        };
    }

    public static String binaryOperatorToString(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.ARITHDIV -> "/";
            case BinaryExpression.Operator.ARITHMINUS -> STRING_MINUS;
            case BinaryExpression.Operator.ARITHMOD -> "%";
            case BinaryExpression.Operator.ARITHMUL -> STRING_TIMES;
            case BinaryExpression.Operator.ARITHPLUS -> STRING_PLUS;
            case BinaryExpression.Operator.BITAND -> STRING_AND;
            case BinaryExpression.Operator.BITIFF -> "<-->";
            case BinaryExpression.Operator.BITIMPLIES -> "-->";
            case BinaryExpression.Operator.BITOR -> "|";
            case BinaryExpression.Operator.BITXOR -> "^";
            case BinaryExpression.Operator.COMPEQ -> "==";
            case BinaryExpression.Operator.COMPGEQ -> ">=";
            case BinaryExpression.Operator.COMPGT -> ">";
            case BinaryExpression.Operator.COMPLEQ -> "<=";
            case BinaryExpression.Operator.COMPLT -> "<";
            case BinaryExpression.Operator.COMPNEQ -> "!=";
            case BinaryExpression.Operator.LOGICAND -> "&&";
            case BinaryExpression.Operator.LOGICIFF -> "<==>";
            case BinaryExpression.Operator.LOGICIMPLIES -> "==>";
            case BinaryExpression.Operator.LOGICOR -> "||";
            case BinaryExpression.Operator.LOGICXOR -> "^^";
            case BinaryExpression.Operator.BITSHIFTLEFT -> "<<";
            case BinaryExpression.Operator.BITSHIFTRIGHT -> ">>";
            case BinaryExpression.Operator.LTLUNTIL -> "U";
            case BinaryExpression.Operator.LTLRELEASE -> "R";
            case BinaryExpression.Operator.LTLWEAKUNTIL -> "WU";
            case BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT -> throw new AssertionError((Object)("Unhandled operator " + String.valueOf((Object)operator)));
            default -> throw new MatchException(null, null);
        };
    }

    private static Precedence getPrecedence(Expression expression) {
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryExpression.class, CastExpression.class, FieldAccessExpression.class, IfThenElseExpression.class, QuantifierExpression.class, UnaryExpression.class, SyntacticNamingExpression.class, ACSLResultExpression.class, AtLabelExpression.class, BaseAddrExpression.class, BlockLengthExpression.class, BooleanLiteral.class, FreeableExpression.class, FunctionApplication.class, IdentifierExpression.class, IntegerLiteral.class, MallocableExpression.class, NullPointer.class, OldValueExpression.class, RealLiteral.class, SizeOfExpression.class, StringLiteral.class, ValidExpression.class}, (Object)expression3, 0)) {
            case 0 -> {
                BinaryExpression var2_2 = (BinaryExpression)expression3;
                yield ACSLPrettyPrinter.getPrecedence(var2_2.getOperator());
            }
            case 1 -> {
                CastExpression var3_3 = (CastExpression)expression3;
                yield Precedence.UNARY;
            }
            case 2 -> {
                FieldAccessExpression var4_4 = (FieldAccessExpression)expression3;
                yield Precedence.SELECTION;
            }
            case 3 -> {
                IfThenElseExpression var5_5 = (IfThenElseExpression)expression3;
                yield Precedence.TERNARY;
            }
            case 4 -> {
                QuantifierExpression var6_6 = (QuantifierExpression)expression3;
                yield Precedence.BINDING;
            }
            case 5 -> {
                UnaryExpression var7_7 = (UnaryExpression)expression3;
                yield Precedence.UNARY;
            }
            case 6 -> {
                SyntacticNamingExpression var8_8 = (SyntacticNamingExpression)expression3;
                yield Precedence.NAMING;
            }
            case 7 -> {
                ACSLResultExpression var9_9 = (ACSLResultExpression)expression3;
                yield Precedence.TOP;
            }
            case 8 -> {
                AtLabelExpression var10_10 = (AtLabelExpression)expression3;
                yield Precedence.TOP;
            }
            case 9 -> {
                BaseAddrExpression var11_11 = (BaseAddrExpression)expression3;
                yield Precedence.TOP;
            }
            case 10 -> {
                BlockLengthExpression var12_12 = (BlockLengthExpression)expression3;
                yield Precedence.TOP;
            }
            case 11 -> {
                BooleanLiteral var13_13 = (BooleanLiteral)expression3;
                yield Precedence.TOP;
            }
            case 12 -> {
                FreeableExpression var14_14 = (FreeableExpression)expression3;
                yield Precedence.TOP;
            }
            case 13 -> {
                FunctionApplication var15_15 = (FunctionApplication)expression3;
                yield Precedence.TOP;
            }
            case 14 -> {
                IdentifierExpression var16_16 = (IdentifierExpression)expression3;
                yield Precedence.TOP;
            }
            case 15 -> {
                IntegerLiteral var17_17 = (IntegerLiteral)expression3;
                yield Precedence.TOP;
            }
            case 16 -> {
                MallocableExpression var18_18 = (MallocableExpression)expression3;
                yield Precedence.TOP;
            }
            case 17 -> {
                NullPointer var19_19 = (NullPointer)expression3;
                yield Precedence.TOP;
            }
            case 18 -> {
                OldValueExpression var20_20 = (OldValueExpression)expression3;
                yield Precedence.TOP;
            }
            case 19 -> {
                RealLiteral var21_21 = (RealLiteral)expression3;
                yield Precedence.TOP;
            }
            case 20 -> {
                SizeOfExpression var22_22 = (SizeOfExpression)expression3;
                yield Precedence.TOP;
            }
            case 21 -> {
                StringLiteral var23_23 = (StringLiteral)expression3;
                yield Precedence.TOP;
            }
            case 22 -> {
                ValidExpression var24_24 = (ValidExpression)expression3;
                yield Precedence.TOP;
            }
            default -> Precedence.BOTTOM;
        };
    }

    private static Precedence getPrecedence(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF -> Precedence.EQUIV;
            case BinaryExpression.Operator.LOGICIMPLIES -> Precedence.IMPLIES;
            case BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR, BinaryExpression.Operator.LOGICXOR -> Precedence.OR_XOR_AND;
            case BinaryExpression.Operator.BITOR -> Precedence.BIT_OR;
            case BinaryExpression.Operator.BITIFF -> Precedence.BIT_EQUIV;
            case BinaryExpression.Operator.BITIMPLIES -> Precedence.BIT_IMPLIES;
            case BinaryExpression.Operator.BITXOR -> Precedence.BIT_XOR;
            case BinaryExpression.Operator.BITAND -> Precedence.BIT_AND;
            case BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ -> Precedence.COMPARISON;
            case BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ -> Precedence.EQUALITY;
            case BinaryExpression.Operator.BITSHIFTLEFT, BinaryExpression.Operator.BITSHIFTRIGHT -> Precedence.SHIFT;
            case BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMINUS -> Precedence.ADDITIVE;
            case BinaryExpression.Operator.ARITHMUL, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> Precedence.MULTIPLICATIVE;
            case BinaryExpression.Operator.LTLUNTIL, BinaryExpression.Operator.LTLRELEASE, BinaryExpression.Operator.LTLWEAKUNTIL -> Precedence.LTL_INFIX;
            case BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT -> Precedence.BOTTOM;
            default -> throw new MatchException(null, null);
        };
    }

    private static Associativity getAssociativity(BinaryExpression.Operator operator) {
        return switch (operator) {
            case BinaryExpression.Operator.LOGICIFF -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.LOGICIMPLIES -> Associativity.RIGHT_ASSOCIATIVE;
            case BinaryExpression.Operator.LOGICAND, BinaryExpression.Operator.LOGICOR -> Associativity.ASSOCIATIVE;
            case BinaryExpression.Operator.LOGICXOR -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.BITAND, BinaryExpression.Operator.BITOR -> Associativity.ASSOCIATIVE;
            case BinaryExpression.Operator.BITIFF -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.BITIMPLIES -> Associativity.RIGHT_ASSOCIATIVE;
            case BinaryExpression.Operator.BITXOR -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.COMPLT, BinaryExpression.Operator.COMPGT, BinaryExpression.Operator.COMPLEQ, BinaryExpression.Operator.COMPGEQ -> Associativity.NO_ASSOCIATIVITY;
            case BinaryExpression.Operator.COMPEQ, BinaryExpression.Operator.COMPNEQ -> Associativity.NO_ASSOCIATIVITY;
            case BinaryExpression.Operator.BITSHIFTLEFT, BinaryExpression.Operator.BITSHIFTRIGHT -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.ARITHPLUS, BinaryExpression.Operator.ARITHMUL -> Associativity.ASSOCIATIVE;
            case BinaryExpression.Operator.ARITHMINUS, BinaryExpression.Operator.ARITHDIV, BinaryExpression.Operator.ARITHMOD -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.LTLUNTIL, BinaryExpression.Operator.LTLRELEASE, BinaryExpression.Operator.LTLWEAKUNTIL -> Associativity.LEFT_ASSOCIATIVE;
            case BinaryExpression.Operator.COMPPO, BinaryExpression.Operator.BITVECCONCAT -> Associativity.NO_ASSOCIATIVITY;
            default -> throw new MatchException(null, null);
        };
    }

    private static enum Associativity {
        ASSOCIATIVE,
        LEFT_ASSOCIATIVE,
        RIGHT_ASSOCIATIVE,
        NO_ASSOCIATIVITY;


        public boolean satisfies(Associativity associativity) {
            return this == ASSOCIATIVE || associativity == NO_ASSOCIATIVITY || this == associativity;
        }
    }

    private static enum Precedence {
        BOTTOM,
        NAMING,
        BINDING,
        TERNARY,
        EQUIV,
        IMPLIES,
        OR_XOR_AND,
        BIT_EQUIV,
        BIT_IMPLIES,
        BIT_OR,
        BIT_XOR,
        BIT_AND,
        EQUALITY,
        COMPARISON,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        LTL_INFIX,
        UNARY,
        SELECTION,
        TOP;

    }
}

