/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Invariant;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Parameter;
import java.util.List;
import java.util.function.Predicate;

public final class TypeInvariant
extends Invariant {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(TypeInvariant.class);
    Parameter parameters;

    public TypeInvariant(String string, Expression expression) {
        super(string, expression);
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid TypeInvariant: " + String.valueOf(this);
    }

    public TypeInvariant(String string, Expression expression, Parameter parameter) {
        super(string, expression);
        this.parameters = parameter;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid TypeInvariant: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TypeInvariant").append('[');
        stringBuffer.append(this.parameters);
        return stringBuffer.append(']').toString();
    }

    public Parameter getParameters() {
        return this.parameters;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.parameters);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Invariant)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.parameters != null) {
                this.parameters.accept(aCSLVisitor);
            }
            if (this.formula != null) {
                this.formula.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Invariant accept(ACSLTransformer aCSLTransformer) {
        Invariant invariant = aCSLTransformer.transform(this);
        if (invariant != this) {
            return invariant;
        }
        Parameter parameter = null;
        if (this.parameters != null) {
            parameter = this.parameters.accept(aCSLTransformer);
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        if (this.parameters != parameter || this.formula != expression) {
            return new TypeInvariant(this.identifier, expression, parameter);
        }
        return this;
    }
}

