/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IValuation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.VariableValuesMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BoogieProgramExecution
implements IProgramExecution<BoogieASTNode, Expression> {
    private final List<AtomicTraceElement<BoogieASTNode>> mTrace;
    private final Map<Integer, IProgramExecution.ProgramState<Expression>> mPartialProgramStateMapping;
    private final boolean mIsConcurrent;

    public BoogieProgramExecution(List<AtomicTraceElement<BoogieASTNode>> list, boolean bl) {
        this(Collections.emptyMap(), list, bl);
    }

    public BoogieProgramExecution(Map<Integer, IProgramExecution.ProgramState<Expression>> map, List<AtomicTraceElement<BoogieASTNode>> list, boolean bl) {
        this.mTrace = list;
        this.mPartialProgramStateMapping = map;
        this.mIsConcurrent = bl;
        assert (!bl || this.mTrace.stream().allMatch(atomicTraceElement -> atomicTraceElement.hasThreadId())) : "Is concurrent but has trace element without thread id";
    }

    public int getLength() {
        return this.mTrace.size();
    }

    public AtomicTraceElement<BoogieASTNode> getTraceElement(int n) {
        return this.mTrace.get(n);
    }

    public IProgramExecution.ProgramState<Expression> getProgramState(int n) {
        if (n < 0 || n >= this.mTrace.size()) {
            throw new IllegalArgumentException("out of range");
        }
        return this.mPartialProgramStateMapping.get(n);
    }

    public IProgramExecution.ProgramState<Expression> getInitialProgramState() {
        return this.mPartialProgramStateMapping.get(-1);
    }

    public String toString() {
        ProgramExecutionFormatter programExecutionFormatter = new ProgramExecutionFormatter((IBacktranslationValueProvider)new BoogieBacktranslationValueProvider());
        return programExecutionFormatter.formatProgramExecution((IProgramExecution)this);
    }

    public IValuation getValuation(List<ITranslator<?, ?, ?, ?, ?, ?, ?>> list) {
        return new BoogieValuation(list);
    }

    public Class<Expression> getExpressionClass() {
        return Expression.class;
    }

    public Class<BoogieASTNode> getTraceElementClass() {
        return BoogieASTNode.class;
    }

    public IBacktranslationValueProvider<BoogieASTNode, Expression> getBacktranslationValueProvider() {
        return new BoogieBacktranslationValueProvider();
    }

    public boolean isConcurrent() {
        return this.mIsConcurrent;
    }

    private final class BoogieValuation
    implements IValuation {
        private final List<ITranslator<?, ?, ?, ?, ?, ?, ?>> mTranslatorSequence;

        private BoogieValuation(List<ITranslator<?, ?, ?, ?, ?, ?, ?>> list) {
            this.mTranslatorSequence = list;
        }

        public VariableValuesMap getValuesForFailurePathIndex(int n) {
            IProgramExecution.ProgramState<Expression> programState = BoogieProgramExecution.this.getProgramState(n);
            if (programState == null) {
                return new VariableValuesMap(this.getEmtpyProgramState());
            }
            return new VariableValuesMap(this.translateProgramState(programState));
        }

        public Map<String, Map.Entry<IBoogieType, List<String>>> getEmtpyProgramState() {
            return Collections.emptyMap();
        }

        public Map<String, Map.Entry<IBoogieType, List<String>>> translateProgramState(IProgramExecution.ProgramState<Expression> programState) {
            HashMap<String, Map.Entry<IBoogieType, List<String>>> hashMap = new HashMap<String, Map.Entry<IBoogieType, List<String>>>();
            for (Expression expression : programState.getVariables()) {
                String string = this.backtranslationWorkaround(this.mTranslatorSequence, expression);
                List<String> list = this.exprSet2StringList(programState.getValues((Object)expression));
                hashMap.put(string, new AbstractMap.SimpleEntry<IBoogieType, List<String>>(expression.getType(), list));
            }
            return hashMap;
        }

        private List<String> exprSet2StringList(Collection<Expression> collection) {
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (Expression expression : collection) {
                arrayList.add(this.backtranslationWorkaround(this.mTranslatorSequence, expression));
            }
            return arrayList;
        }

        private <SE> String backtranslationWorkaround(List<ITranslator<?, ?, ?, ?, ?, ?, ?>> list, SE SE) {
            Object object = DefaultTranslator.translateExpressionIteratively(SE, (ITranslator[])list.toArray(new ITranslator[list.size()]));
            String string = object instanceof String ? (String)object : (object instanceof Expression ? BoogiePrettyPrinter.print((Expression)((Object)object)) : object.toString());
            return string;
        }
    }
}

