/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.abduction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public class MaximumUniversalSetComputation {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private final ToIntFunction<TermVariable> mCost;
    private final Term mContext;
    private Set<TermVariable> mUniversalSet;
    private Term mQuantifiedUniversalFormula;
    private int mUniversalSetCost;

    public MaximumUniversalSetComputation(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, Term term2, ToIntFunction<TermVariable> toIntFunction) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(MaximumUniversalSetComputation.class);
        this.mMgdScript = managedScript;
        this.mContext = term2;
        this.mCost = toIntFunction;
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = Arrays.stream(termVariableArray).collect(Collectors.summingInt(this.mCost));
        this.computeMUS(term, termVariableArray, 0, n, 0);
    }

    public Set<TermVariable> getVariables() {
        return this.mUniversalSet;
    }

    public Term getQuantifiedFormula() {
        return this.mQuantifiedUniversalFormula;
    }

    public int getCost() {
        return this.mUniversalSetCost;
    }

    private void computeMUS(Term term, TermVariable[] termVariableArray, int n, int n2, int n3) {
        if (n >= termVariableArray.length || n2 <= n3) {
            this.mUniversalSet = new HashSet<TermVariable>();
            this.mQuantifiedUniversalFormula = term;
            this.mUniversalSetCost = 0;
            return;
        }
        Set<TermVariable> set = new HashSet<TermVariable>();
        Term term2 = term;
        int n4 = 0;
        TermVariable termVariable = termVariableArray[n];
        int n5 = this.mCost.applyAsInt(termVariable);
        Term term3 = this.tryEliminateUniversal(termVariable, term);
        Script.LBool lBool = SmtUtils.checkSatTerm(this.mMgdScript.getScript(), this.getWithContext(term3));
        if (lBool == Script.LBool.SAT) {
            this.computeMUS(term3, termVariableArray, n + 1, n2 - n5, n3 - n5);
            if (this.mUniversalSetCost + n5 > n3) {
                set = this.mUniversalSet;
                set.add(termVariable);
                term2 = this.mQuantifiedUniversalFormula;
                n3 = n4 = this.mUniversalSetCost + n5;
            }
        }
        this.computeMUS(term, termVariableArray, n + 1, n2 - n5, n3);
        if (this.mUniversalSetCost > n3) {
            set = this.mUniversalSet;
            term2 = this.mQuantifiedUniversalFormula;
            n4 = this.mUniversalSetCost;
        }
        this.mUniversalSet = set;
        this.mQuantifiedUniversalFormula = term2;
        this.mUniversalSetCost = n4;
    }

    private Term getWithContext(Term term) {
        if (this.mContext == null) {
            return term;
        }
        return SmtUtils.and(this.mMgdScript.getScript(), this.mContext, term);
    }

    private Term tryEliminateUniversal(TermVariable termVariable, Term term) {
        Term term2 = new FormulaUnLet().transform(term);
        return PartialQuantifierElimination.eliminate(this.mServices, this.mMgdScript, SmtUtils.quantifier(this.mMgdScript.getScript(), 1, Set.of(termVariable), term2), SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
    }
}

