/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionPartition {
    Map<NonTheorySymbol<?>, Set<Term>> mNonTheorySymbols2Terms = new HashMap();
    UnionFind<NonTheorySymbol<?>> mUnionFind = new UnionFind();
    List<Term> mTermWithoutNonTheorySymbols = new ArrayList<Term>();

    public ConnectionPartition(Collection<Term> collection) {
        for (Term term : collection) {
            this.addTerm(term);
        }
    }

    private void addTerm(Term term) {
        Set<NonTheorySymbol<?>> set = NonTheorySymbol.extractNonTheorySymbols(term);
        if (set.isEmpty()) {
            this.mTermWithoutNonTheorySymbols.add(term);
            return;
        }
        NonTheorySymbol<?> nonTheorySymbol = null;
        for (NonTheorySymbol<?> nonTheorySymbol2 : set) {
            this.add(term, nonTheorySymbol2);
            if (this.mUnionFind.find(nonTheorySymbol2) == null) {
                this.mUnionFind.makeEquivalenceClass(nonTheorySymbol2);
            }
            if (nonTheorySymbol != null && !((NonTheorySymbol)this.mUnionFind.find(nonTheorySymbol)).equals(this.mUnionFind.find(nonTheorySymbol2))) {
                this.mUnionFind.union(nonTheorySymbol2, nonTheorySymbol);
            }
            nonTheorySymbol = nonTheorySymbol2;
        }
    }

    private void add(Term term, NonTheorySymbol<?> nonTheorySymbol) {
        Set<Term> set = this.mNonTheorySymbols2Terms.get(nonTheorySymbol);
        if (set == null) {
            set = new HashSet<Term>();
            this.mNonTheorySymbols2Terms.put(nonTheorySymbol, set);
        }
        set.add(term);
    }

    public Iterable<Set<NonTheorySymbol<?>>> getConnectedNonTheorySymbols() {
        return () -> new Iterator<Set<NonTheorySymbol<?>>>(){
            private final Iterator<NonTheorySymbol<?>> mIt;
            {
                this.mIt = ConnectionPartition.this.mUnionFind.getAllRepresentatives().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mIt.hasNext();
            }

            @Override
            public Set<NonTheorySymbol<?>> next() {
                ImmutableSet immutableSet = ConnectionPartition.this.mUnionFind.getEquivalenceClassMembers(this.mIt.next());
                return immutableSet;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<Term> getTermsOfConnectedNonTheorySymbols(Set<NonTheorySymbol<?>> set) {
        HashSet<Term> hashSet = new HashSet<Term>();
        for (NonTheorySymbol<?> nonTheorySymbol : set) {
            hashSet.addAll((Collection<Term>)this.mNonTheorySymbols2Terms.get(nonTheorySymbol));
        }
        return hashSet;
    }

    public List<Term> getTermsWithNonTheorySymbols() {
        return this.mTermWithoutNonTheorySymbols;
    }
}

