/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SMTFeature {
    public int numberOfFunctions = 0;
    public int numberOfQuantifiers = 0;
    public int numberOfVariables = 0;
    public int numberOfArrays = 0;
    public int numberOfSelectFunctions = 0;
    public int numberOfStoreFunctions = 0;
    public int dagsize = 0;
    public long treesize = 0L;
    public int dependencyScore = 0;
    public ArrayList<Integer> variableEquivalenceClassSizes;
    public int biggestEquivalenceClass;
    public Map<String, Integer> occuringSorts = new HashMap<String, Integer>();
    public Map<String, Integer> occuringFunctions = new HashMap<String, Integer>();
    public Map<Integer, Integer> occuringQuantifiers = new HashMap<Integer, Integer>();
    public boolean containsArrays = false;
    public ArrayList<String> assertionStack = new ArrayList();
    public int assertionStackHashCode = 0;
    public String solverresult = "";
    public String solvername = "";
    public double solvertime = 0.0;

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n" + SMTFeature.getCsvHeader(";") + "\n");
            stringBuilder.append(this.toCsv(";"));
            return stringBuilder.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return "";
        }
    }

    private String mapToJson(Map<?, ?> map) {
        return "{" + map.entrySet().stream().map(entry -> "\"" + String.valueOf(entry.getKey()) + "\":" + String.valueOf(entry.getValue())).collect(Collectors.joining(", ")) + "}";
    }

    public String toCsv(String string) throws IllegalAccessException {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.valueOf(this.numberOfFunctions));
        arrayList.add(String.valueOf(this.numberOfQuantifiers));
        arrayList.add(String.valueOf(this.numberOfVariables));
        arrayList.add(String.valueOf(this.numberOfArrays));
        arrayList.add(String.valueOf(this.dagsize));
        arrayList.add(String.valueOf(this.treesize));
        arrayList.add(String.valueOf(this.dependencyScore));
        arrayList.add(String.valueOf(this.variableEquivalenceClassSizes));
        arrayList.add(String.valueOf(this.biggestEquivalenceClass));
        arrayList.add(this.mapToJson(this.occuringSorts));
        arrayList.add(this.mapToJson(this.occuringFunctions));
        arrayList.add(this.mapToJson(this.occuringQuantifiers));
        arrayList.add(String.valueOf(this.containsArrays));
        arrayList.add(String.valueOf(this.assertionStack));
        arrayList.add(String.valueOf(this.assertionStackHashCode));
        arrayList.add(String.valueOf(this.solverresult));
        arrayList.add(String.valueOf(this.solvername));
        arrayList.add(String.valueOf(this.solvertime));
        stringBuilder.append(String.join((CharSequence)string, arrayList));
        return stringBuilder.toString();
    }

    public static String getCsvHeader(String string) throws IllegalAccessException {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = SMTFeature.class.getFields();
        ArrayList<String> arrayList = new ArrayList<String>();
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            arrayList.add(field.getName());
            ++n2;
        }
        stringBuilder.append(String.join((CharSequence)string, arrayList));
        return stringBuilder.toString();
    }

    public static SMTFeature chooseLooser(SMTFeature sMTFeature, SMTFeature sMTFeature2) {
        String[] stringArray;
        int n = 0;
        int n2 = 0;
        String[] stringArray2 = stringArray = new String[]{"numberOfFunctions", "numberOfArrays", "dagsize", "numberOfVariables", "dependencyScore", "biggestEquivalenceClass", "numberOfSelectFunctions", "numberOfStoreFunctions"};
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            int n5 = 0;
            try {
                n5 = (Integer)sMTFeature.getClass().getField(string).get(sMTFeature);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                exception.printStackTrace();
            }
            int n6 = 0;
            try {
                n6 = (Integer)sMTFeature2.getClass().getField(string).get(sMTFeature2);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                exception.printStackTrace();
            }
            if (n5 < n6) {
                ++n;
            } else if (n6 < n5) {
                ++n2;
            }
            ++n4;
        }
        if (n > n2) {
            return sMTFeature2;
        }
        return sMTFeature;
    }
}

