/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Stack;

class ModelTranslationContainer
implements IBacktranslationService {
    private final ArrayDeque<ITranslator<?, ?, ?, ?, ?, ?, ?>> mTranslationSequence;

    protected ModelTranslationContainer() {
        this.mTranslationSequence = new ArrayDeque();
    }

    protected ModelTranslationContainer(ModelTranslationContainer modelTranslationContainer) {
        this.mTranslationSequence = new ArrayDeque(modelTranslationContainer.mTranslationSequence);
    }

    public <STE, TTE, SE, TE, SVL, TVL, LOC> void addTranslator(ITranslator<STE, TTE, SE, TE, SVL, TVL, LOC> iTranslator) {
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator2;
        if (this.mTranslationSequence.size() > 0 && !ModelTranslationContainer.isAllowedNext(iTranslator2 = this.mTranslationSequence.getLast(), iTranslator)) {
            throw new IllegalArgumentException("The supplied ITranslator is not compatible with the existing ones. It has to be compatible with " + String.valueOf(iTranslator2) + ", but it is " + String.valueOf(iTranslator));
        }
        this.mTranslationSequence.addLast(iTranslator);
    }

    private static boolean isAllowedNext(ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator, ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator2) {
        return iTranslator.getSourceExpressionClass() == iTranslator2.getTargetExpressionClass() && iTranslator.getSourceTraceElementClass() == iTranslator2.getTargetTraceElementClass();
    }

    public <SE, TE> TE translateExpression(SE SE, Class<SE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceExpression(clazz);
        return this.translateExpression(stack, SE);
    }

    public <SE, TE, CTX> TE translateExpressionWithContext(SE SE, CTX CTX, Class<SE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceExpression(clazz);
        return this.translateExpressionWithContext(stack, SE, CTX);
    }

    private <TE, SE, CTX> TE translateExpressionWithContext(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, SE SE, CTX CTX) {
        if (stack.isEmpty()) {
            return (TE)SE;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        return this.translateExpressionWithContext(stack, iTranslator.translateExpressionWithContext(SE, CTX), CTX);
    }

    public <TE> String targetExpressionToString(TE TE) {
        return ModelTranslationContainer.translateExpressionToString(TE, this.mTranslationSequence.getFirst());
    }

    private static <TE> String translateExpressionToString(TE TE, ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator) {
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator2 = iTranslator;
        return iTranslator2.targetExpressionToString(TE);
    }

    private <TE, SE> TE translateExpression(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, SE SE) {
        if (stack.isEmpty()) {
            return (TE)SE;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        return this.translateExpression(stack, iTranslator.translateExpression(SE));
    }

    public <STE> List<?> translateTrace(List<STE> list, Class<STE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceTraceElement(clazz);
        return this.translateTrace(stack, list);
    }

    public <STE> List<String> translateTraceToHumanReadableString(List<STE> list, Class<STE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceTraceElement(clazz);
        ITranslator iTranslator = (ITranslator)stack.firstElement();
        return ModelTranslationContainer.translateTraceToString(this.translateTrace(stack, list), iTranslator);
    }

    private static <TTE> List<String> translateTraceToString(List<TTE> list, ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator) {
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator2 = iTranslator;
        return iTranslator2.targetTraceToString(list);
    }

    private <STE> Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> prepareTranslatorStackAndCheckSourceTraceElement(Class<STE> clazz) {
        Stack stack = new Stack();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            stack.push(iTranslator);
            if (!iTranslator.getSourceTraceElementClass().isAssignableFrom(clazz)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + clazz.getSimpleName() + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)stack.peek()).getSourceTraceElementClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("You cannot translate " + clazz.getSimpleName() + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return stack;
    }

    private <STE> Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> prepareTranslatorStackAndCheckSourceExpression(Class<STE> clazz) {
        Stack stack = new Stack();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            stack.push(iTranslator);
            if (!iTranslator.getSourceExpressionClass().isAssignableFrom(clazz)) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + clazz.getSimpleName() + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)stack.peek()).getSourceExpressionClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("You cannot translate " + clazz.getSimpleName() + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return stack;
    }

    private <TTE, STE> List<TTE> translateTrace(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, List<STE> list) {
        if (stack.isEmpty()) {
            return list;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        return this.translateTrace(stack, iTranslator.translateTrace(list));
    }

    public <STE, SE> IProgramExecution<?, ?> translateProgramExecution(IProgramExecution<STE, SE> iProgramExecution) {
        ArrayDeque arrayDeque = new ArrayDeque();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            arrayDeque.push(iTranslator);
            if (!iTranslator.getSourceTraceElementClass().isAssignableFrom(iProgramExecution.getTraceElementClass()) || !iTranslator.getSourceExpressionClass().isAssignableFrom(iProgramExecution.getExpressionClass())) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(iProgramExecution) + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)arrayDeque.peek()).getSourceTraceElementClass().isAssignableFrom(iProgramExecution.getTraceElementClass()) || !((ITranslator)arrayDeque.peek()).getSourceExpressionClass().isAssignableFrom(iProgramExecution.getExpressionClass())) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(iProgramExecution) + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return this.translateProgramExecution(arrayDeque, iProgramExecution);
    }

    private <STE, TTE, SE, TE> IProgramExecution<TTE, TE> translateProgramExecution(ArrayDeque<ITranslator<?, ?, ?, ?, ?, ?, ?>> arrayDeque, IProgramExecution<STE, SE> iProgramExecution) {
        if (arrayDeque.isEmpty()) {
            return iProgramExecution;
        }
        ArrayDeque arrayDeque2 = new ArrayDeque(arrayDeque);
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = arrayDeque2.pop();
        IProgramExecution iProgramExecution2 = iTranslator.translateProgramExecution(iProgramExecution);
        return this.translateProgramExecution(arrayDeque2, iProgramExecution2);
    }

    public <STE, SE> IBacktranslationService.Lasso<IProgramExecution<?, ?>> translateLassoProgramExecution(IBacktranslationService.Lasso<IProgramExecution<STE, SE>> lasso) {
        ArrayDeque arrayDeque = new ArrayDeque();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            arrayDeque.push(iTranslator);
            bl |= iTranslator.getSourceTraceElementClass().isAssignableFrom(lasso.stem().getTraceElementClass()) && iTranslator.getSourceExpressionClass().isAssignableFrom(lasso.stem().getExpressionClass()) && iTranslator.getSourceTraceElementClass().isAssignableFrom(lasso.loop().getTraceElementClass()) && iTranslator.getSourceExpressionClass().isAssignableFrom(lasso.loop().getExpressionClass());
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(lasso) + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!(((ITranslator)arrayDeque.peek()).getSourceTraceElementClass().isAssignableFrom(lasso.stem().getTraceElementClass()) && ((ITranslator)arrayDeque.peek()).getSourceExpressionClass().isAssignableFrom(lasso.stem().getExpressionClass()) && ((ITranslator)arrayDeque.peek()).getSourceTraceElementClass().isAssignableFrom(lasso.loop().getTraceElementClass()) && ((ITranslator)arrayDeque.peek()).getSourceExpressionClass().isAssignableFrom(lasso.loop().getExpressionClass()))) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(lasso) + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return this.translateLassoProgramExecution(arrayDeque, lasso);
    }

    private <STE, TTE, SE, TE> IBacktranslationService.Lasso<IProgramExecution<TTE, TE>> translateLassoProgramExecution(ArrayDeque<ITranslator<?, ?, ?, ?, ?, ?, ?>> arrayDeque, IBacktranslationService.Lasso<IProgramExecution<STE, SE>> lasso) {
        if (arrayDeque.isEmpty()) {
            return lasso;
        }
        ArrayDeque arrayDeque2 = new ArrayDeque(arrayDeque);
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = arrayDeque2.pop();
        IBacktranslationService.Lasso lasso2 = iTranslator.translateLassoProgramExecution(lasso);
        return this.translateLassoProgramExecution(arrayDeque2, lasso2);
    }

    public <SE> IProgramExecution.ProgramState<?> translateProgramState(IProgramExecution.ProgramState<SE> programState) {
        Stack stack = new Stack();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            stack.push(iTranslator);
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(programState) + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        return this.translateProgramState(stack, programState);
    }

    private <SE, TE> IProgramExecution.ProgramState<TE> translateProgramState(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, IProgramExecution.ProgramState<SE> programState) {
        if (stack.isEmpty()) {
            return programState;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        IProgramExecution.ProgramState programState2 = iTranslator.translateProgramState(programState);
        return this.translateProgramState(stack, programState2);
    }

    public <SE> String translateProgramStateToString(IProgramExecution.ProgramState<SE> programState) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceExpression(programState.getClassOfExpression());
        ITranslator iTranslator = (ITranslator)stack.firstElement();
        return ModelTranslationContainer.translateProgramStateToString(this.translateProgramState(stack, programState), iTranslator);
    }

    private static <TE> String translateProgramStateToString(IProgramExecution.ProgramState<TE> programState, ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator) {
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator2 = iTranslator;
        return programState.toString(object -> iTranslator2.targetExpressionToString(object));
    }

    public <STE, SE> IBacktranslatedCFG<?, ?> translateCFG(IBacktranslatedCFG<?, STE> iBacktranslatedCFG) {
        Stack stack = new Stack();
        boolean bl = false;
        for (ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator : this.mTranslationSequence) {
            stack.push(iTranslator);
            if (!iTranslator.getSourceTraceElementClass().isAssignableFrom(iBacktranslatedCFG.getTraceElementClass())) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(iBacktranslatedCFG) + " with this backtranslation service, as there is no compatible ITranslator available");
        }
        if (!((ITranslator)stack.peek()).getSourceTraceElementClass().isAssignableFrom(iBacktranslatedCFG.getTraceElementClass())) {
            throw new IllegalArgumentException("You cannot translate " + String.valueOf(iBacktranslatedCFG) + " with this backtranslation service, as the last ITranslator in this chain is not compatible");
        }
        return this.translateCFG(stack, iBacktranslatedCFG);
    }

    private <STE, TTE, SE, TE, SVL, TVL> IBacktranslatedCFG<TVL, TTE> translateCFG(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, IBacktranslatedCFG<SVL, STE> iBacktranslatedCFG) {
        if (stack.isEmpty()) {
            return iBacktranslatedCFG;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        IBacktranslatedCFG iBacktranslatedCFG2 = iTranslator.translateCFG(iBacktranslatedCFG);
        return this.translateCFG(stack, iBacktranslatedCFG2);
    }

    public <TE, SE, CTX> ProcedureContract<TE, ? extends TE> translateProcedureContract(ProcedureContract<SE, ? extends SE> procedureContract, CTX CTX, Class<SE> clazz) {
        Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack = this.prepareTranslatorStackAndCheckSourceExpression(clazz);
        return this.translateProcedureContract(stack, procedureContract, CTX);
    }

    private <TE, SE, CTX> ProcedureContract<TE, ? extends TE> translateProcedureContract(Stack<ITranslator<?, ?, ?, ?, ?, ?, ?>> stack, ProcedureContract<SE, ? extends SE> procedureContract, CTX CTX) {
        if (stack.isEmpty()) {
            return procedureContract;
        }
        ITranslator<?, ?, ?, ?, ?, ?, ?> iTranslator = stack.pop();
        return this.translateProcedureContract(stack, iTranslator.translateProcedureContract(procedureContract, CTX), CTX);
    }

    public IBacktranslationService getTranslationServiceCopy() {
        return new ModelTranslationContainer(this);
    }

    public String toString() {
        return CoreUtil.join(this.mTranslationSequence, (String)",");
    }
}

