/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataStructureUtils {
    private DataStructureUtils() {
    }

    public static <T> Set<T> intersection(Set<T> set, Set<T> set2) {
        Set<T> set3;
        Set<T> set4;
        if (set.size() > set2.size()) {
            set4 = set;
            set3 = set2;
        } else {
            set4 = set2;
            set3 = set;
        }
        return set3.stream().filter(set4::contains).collect(Collectors.toSet());
    }

    public static <T> Set<T> intersection(List<Set<T>> list) {
        Collections.sort(list, (set, set2) -> set.size() - set2.size());
        Iterator<Set<T>> iterator = list.iterator();
        HashSet hashSet = new HashSet(iterator.next());
        while (iterator.hasNext()) {
            hashSet.retainAll((Collection)iterator.next());
        }
        return hashSet;
    }

    public static <T> Optional<T> getSomeCommonElement(Set<T> set, Set<T> set2) {
        Set<T> set3;
        Set<T> set4;
        if (set.isEmpty() || set2.isEmpty()) {
            return Optional.empty();
        }
        if (set.size() > set2.size()) {
            set4 = set;
            set3 = set2;
        } else {
            set4 = set2;
            set3 = set;
        }
        return set3.stream().filter(set4::contains).findFirst();
    }

    public static <T> Set<T> difference(Set<T> set, Set<T> set2) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set2.isEmpty()) {
            return new HashSet<T>(set);
        }
        return set.stream().filter(object -> !set2.contains(object)).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> Set<T> toSet(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(TArray));
    }

    public static <T> Set<T> union(Set<T> set, Set<T> set2) {
        Set<T> set3 = DataStructureUtils.getFreshSet(set, set.size() + set2.size());
        set3.addAll(set2);
        return set3;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> ... setArray) {
        if (setArray.length == 0) {
            return Collections.emptySet();
        }
        int n = Arrays.stream(setArray).mapToInt(Set::size).sum();
        Set<T> set = DataStructureUtils.getFreshSet(setArray[0], n);
        Arrays.stream(setArray).forEach(set::addAll);
        return set;
    }

    public static <T> Set<T> getFreshSet(Set<T> set) {
        return DataStructureUtils.getFreshSet(set, set.size());
    }

    public static <T> Set<T> getFreshSet(Set<T> set, int n) {
        HashSet<T> hashSet = new HashSet<T>(n);
        hashSet.addAll(set);
        return hashSet;
    }

    public static <T> boolean haveNonEmptyIntersection(Set<T> set, Set<T> set2) {
        Set<T> set3;
        Set<T> set4;
        if (set.size() > set2.size()) {
            set4 = set;
            set3 = set2;
        } else {
            set4 = set2;
            set3 = set;
        }
        return set3.stream().anyMatch(set4::contains);
    }

    public static <T> boolean haveEmptyIntersection(Set<T> set, Set<T> set2) {
        return !DataStructureUtils.haveNonEmptyIntersection(set, set2);
    }

    public static <T> boolean haveNonEmptyIntersection(Collection<T> collection, Set<T> set) {
        return collection.stream().anyMatch(set::contains);
    }

    public static <T> boolean haveEmptyIntersection(Collection<T> collection, Set<T> set) {
        return !DataStructureUtils.haveNonEmptyIntersection(collection, set);
    }

    public static <E> String prettyPrint(Set<E> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Set: \n");
        String string = "";
        for (E e : set) {
            stringBuilder.append(string);
            stringBuilder.append(String.format("\t%s", e));
            string = "\n";
        }
        return stringBuilder.toString();
    }

    public static <K, V> String prettyPrint(Map<K, V> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Map: \n");
        String string = "";
        for (Map.Entry<K, V> entry : map.entrySet()) {
            stringBuilder.append(string);
            stringBuilder.append(String.format("\t%-80s : \t %s", entry.getKey(), entry.getValue()));
            string = "\n";
        }
        return stringBuilder.toString();
    }

    public static <K1, K2, V> String prettyPrint(NestedMap2<K1, K2, V> nestedMap2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NestedMap2: \n");
        String string = "";
        for (Triple<K1, K2, V> triple : nestedMap2.entrySet()) {
            stringBuilder.append(string);
            stringBuilder.append(String.format("\t%-80s : \t %-40s : \t %s", triple.getFirst(), triple.getSecond(), triple.getThird()));
            string = "\n";
        }
        return stringBuilder.toString();
    }

    public static <T> T[] concat(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return TArray2;
        }
        if (TArray2 == null) {
            return TArray;
        }
        if (TArray.length == 0) {
            return TArray2;
        }
        if (TArray2.length == 0) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    public static <T> List<T> concat(List<T> list, List<T> list2) {
        if (list == null) {
            return list2;
        }
        if (list2 == null) {
            return list;
        }
        if (list.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size() + list2.size() + 1);
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static <T> Collection<Set<T>> powerSet(Set<T> set) {
        ArrayList<Set<T>> arrayList = new ArrayList<Set<T>>();
        ArrayList<T> arrayList2 = new ArrayList<T>(set);
        double d = Math.pow(2.0, set.size());
        int n = 0;
        while ((double)n < d) {
            HashSet hashSet = new HashSet();
            char[] cArray = Integer.toBinaryString(n).toCharArray();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '1') {
                    hashSet.add(arrayList2.get(n2 + set.size() - cArray.length));
                } else assert (cArray[n2] == '0');
                ++n2;
            }
            arrayList.add(hashSet);
            ++n;
        }
        return arrayList;
    }

    public static <K, V> Map<V, K> constructReverseMapping(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <E> boolean isDifferent(Set<E> set, Set<E> set2) {
        if (set.isEmpty() && set2.isEmpty()) {
            return false;
        }
        if (set.size() != set2.size()) {
            return true;
        }
        return set.stream().anyMatch(object -> !set2.contains(object));
    }

    public static <T> boolean differenceIsEmpty(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray.length == 0) {
            return true;
        }
        if (TArray2 == null || TArray2.length == 0) {
            return false;
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(TArray2));
        T[] TArray3 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray3[n2];
            if (!hashSet.contains(t)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <T> List<List<T>> crossProduct(List<List<T>> list, List<List<T>> list2) {
        if (list.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>(list.size() * list2.size());
        for (List<T> list3 : list) {
            for (List<T> list4 : list2) {
                arrayList.add(DataStructureUtils.concat(list3, list4));
            }
        }
        return arrayList;
    }

    public static <E> E getOneAndOnly(Iterable<E> iterable, String string) {
        Iterator<E> iterator = iterable.iterator();
        assert (iterator.hasNext()) : "Must have at least one " + string;
        E e = iterator.next();
        assert (!iterator.hasNext()) : "Only one " + string + " allowed";
        return e;
    }

    public static <E> Optional<E> getOnly(Iterable<E> iterable, String string) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        E e = iterator.next();
        assert (!iterator.hasNext()) : string;
        return Optional.of(e);
    }

    public static <E> Stream<E> filteredCast(Stream<?> stream, Class<E> clazz) {
        return stream.filter(object -> clazz.isAssignableFrom(object.getClass())).map(clazz::cast);
    }

    public static <T> Set<T> asSet(Stream<T> stream) {
        Object[] objectArray = stream.toArray();
        return Set.of(objectArray);
    }

    public static <T> Set<T> getUnmodifiable(Set<T> set) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        if (set.size() == 1) {
            return Collections.singleton(set.iterator().next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> List<E> copyAllButOne(List<E> list, int n) {
        if (n < 0 || n >= list.size()) {
            throw new IllegalArgumentException("Index where we remove must be inside array");
        }
        ArrayList<E> arrayList = new ArrayList<E>(list.size() - 1);
        int n2 = 0;
        for (E e : list) {
            if (n2 != n) {
                arrayList.add(e);
            }
            ++n2;
        }
        assert (n2 == list.size());
        assert (arrayList.size() == list.size() - 1);
        return arrayList;
    }
}

