/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ImmutableSet<E>
implements Set<E> {
    private static final String ERROR_MSG = "Set is immutable";
    private static final ImmutableSet EMPTY_SET = new ImmutableSet(Collections.emptySet());
    private final Set<E> mUnderlying;
    private int mHash;
    private boolean mHashCached;

    private ImmutableSet(Set<E> set) {
        this.mUnderlying = Objects.requireNonNull(set);
    }

    public static <E> ImmutableSet<E> empty() {
        return EMPTY_SET;
    }

    public static <E> ImmutableSet<E> singleton(E e) {
        return ImmutableSet.of(Collections.singleton(e));
    }

    public static <E> ImmutableSet<E> of(Set<E> set) {
        if (set.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        return new ImmutableSet<E>(set);
    }

    public static <E> ImmutableSet<E> copyOf(Collection<E> collection) {
        if (collection.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (collection instanceof ImmutableSet) {
            return (ImmutableSet)collection;
        }
        return new ImmutableSet<E>(new HashSet<E>(collection));
    }

    public static <E> ImmutableSet<E> orderedCopyOf(Collection<E> collection) {
        if (collection.isEmpty()) {
            return ImmutableSet.empty();
        }
        if (collection instanceof ImmutableSet) {
            return (ImmutableSet)collection;
        }
        return new ImmutableSet<E>(new LinkedHashSet<E>(collection));
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> collector() {
        return ImmutableSet.collector(Collectors.toSet(), new Collector.Characteristics[]{Collector.Characteristics.UNORDERED}, true);
    }

    public static <T, A extends Set<T>> Collector<T, A, ImmutableSet<T>> collector(Collector<T, A, Set<T>> collector) {
        EnumSet<Collector.Characteristics> enumSet = EnumSet.noneOf(Collector.Characteristics.class);
        if (collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            enumSet.add(Collector.Characteristics.UNORDERED);
        }
        if (collector.characteristics().contains((Object)Collector.Characteristics.CONCURRENT)) {
            enumSet.add(Collector.Characteristics.CONCURRENT);
        }
        boolean bl = collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH);
        return ImmutableSet.collector(collector, (Collector.Characteristics[])enumSet.toArray(Collector.Characteristics[]::new), bl);
    }

    private static <T, A extends Set<T>> Collector<T, A, ImmutableSet<T>> collector(Collector<T, A, Set<T>> collector, Collector.Characteristics[] characteristicsArray, boolean bl) {
        Function<Set<Object>, ImmutableSet> function = bl ? ImmutableSet::of : collector.finisher().andThen(ImmutableSet::of);
        return Collector.of(collector.supplier(), collector.accumulator(), collector.combiner(), function, characteristicsArray);
    }

    @Override
    public boolean contains(Object object) {
        return this.mUnderlying.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mUnderlying.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof ImmutableSet) {
            ImmutableSet immutableSet = (ImmutableSet)object;
            if (this.mHashCached && immutableSet.mHashCached && this.mHash != immutableSet.mHash) {
                return false;
            }
            return this.mUnderlying.equals(immutableSet.mUnderlying);
        }
        return this.mUnderlying.equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.mHashCached) {
            this.mHash = this.mUnderlying.hashCode();
            this.mHashCached = true;
        }
        assert (this.mUnderlying.hashCode() == this.mHash) : "Immutable set was modified";
        return this.mHash;
    }

    @Override
    public boolean isEmpty() {
        return this.mUnderlying.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<E> iterator = this.mUnderlying.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(ImmutableSet.ERROR_MSG);
            }
        };
    }

    @Override
    public int size() {
        return this.mUnderlying.size();
    }

    @Override
    public Object[] toArray() {
        return this.mUnderlying.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.mUnderlying.toArray(TArray);
    }

    public String toString() {
        return this.mUnderlying.toString();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(ERROR_MSG);
    }
}

