/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence;

import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence.CongruenceDomainEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence.CongruenceDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence.CongruenceDomainValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence.CongruencePostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;

public class CongruenceDomain
implements IAbstractDomain<CongruenceDomainState, IcfgEdge> {
    private final BoogieSymbolTable mSymbolTable;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final BoogieIcfgContainer mRootAnnotation;
    private NonrelationalPostOperator<CongruenceDomainState, CongruenceDomainValue> mPostOperator;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IBoogieSymbolTableVariableProvider mBpl2SmtSymbolTable;

    public CongruenceDomain(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, BoogieSymbolTable boogieSymbolTable, BoogieIcfgContainer boogieIcfgContainer, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mLogger = iLogger;
        this.mSymbolTable = boogieSymbolTable;
        this.mServices = iUltimateServiceProvider;
        this.mCfgSmtToolkit = boogieIcfgContainer.getCfgSmtToolkit();
        this.mRootAnnotation = boogieIcfgContainer;
        this.mBpl2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
    }

    public CongruenceDomainState createTopState() {
        return new CongruenceDomainState(this.mLogger, false);
    }

    public CongruenceDomainState createBottomState() {
        return new CongruenceDomainState(this.mLogger, true);
    }

    public IAbstractStateBinaryOperator<CongruenceDomainState> getWideningOperator() {
        return (congruenceDomainState, congruenceDomainState2) -> congruenceDomainState.union(congruenceDomainState2);
    }

    public NonrelationalPostOperator<CongruenceDomainState, CongruenceDomainValue> getPostOperator() {
        if (this.mPostOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            int n = iPreferenceProvider.getInt("Parallel states before merging");
            int n2 = iPreferenceProvider.getInt("Maximum recursion depth of evaluation operations");
            Boogie2SMT boogie2SMT = this.mRootAnnotation.getBoogie2SMT();
            CongruenceDomainEvaluator congruenceDomainEvaluator = new CongruenceDomainEvaluator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, n2);
            this.mPostOperator = new CongruencePostOperator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, boogie2SMT, this.mCfgSmtToolkit, congruenceDomainEvaluator);
        }
        return this.mPostOperator;
    }

    public void beforeFixpointComputation(Object ... objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof AbsIntBenchmark) {
                AbsIntBenchmark absIntBenchmark = (AbsIntBenchmark)object;
                this.getPostOperator().setAbsIntBenchmark(absIntBenchmark);
            }
            ++n2;
        }
    }
}

