/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class OctValue
implements Comparable<OctValue> {
    public static final OctValue INFINITY = new OctValue();
    public static final OctValue ONE = new OctValue(BigDecimal.ONE);
    public static final OctValue ZERO = new OctValue(BigDecimal.ZERO);
    private BigDecimal mValue;

    private OctValue() {
    }

    public OctValue(IntervalValue intervalValue) {
        this.mValue = intervalValue.isInfinity() ? null : intervalValue.getValue();
    }

    public OctValue(BigDecimal bigDecimal) {
        assert (bigDecimal != null) : "Use constant INFINITY to represent infinity.";
        this.mValue = bigDecimal;
    }

    public OctValue(int n) {
        this.mValue = new BigDecimal(n);
    }

    public static OctValue parse(String string) {
        if ("inf".equals(string)) {
            return INFINITY;
        }
        return new OctValue(AbsIntUtil.sanitizeBigDecimalValue(string));
    }

    public IntervalValue toIvlValue() {
        return this.mValue == null ? new IntervalValue() : new IntervalValue(this.mValue);
    }

    public boolean isInfinity() {
        return this.mValue == null;
    }

    public BigDecimal getValue() {
        return this.mValue;
    }

    public Rational toRational() {
        if (this.mValue == null) {
            return Rational.POSITIVE_INFINITY;
        }
        return SmtUtils.toRational((BigDecimal)this.mValue);
    }

    public OctValue add(OctValue octValue) {
        if (this.mValue == null || octValue.mValue == null) {
            return INFINITY;
        }
        return new OctValue(this.mValue.add(octValue.mValue));
    }

    public OctValue subtract(OctValue octValue) {
        if (octValue.mValue == null) {
            throw new IllegalArgumentException("Cannot subtract infinity.");
        }
        if (this.mValue == null) {
            return INFINITY;
        }
        return new OctValue(this.mValue.subtract(octValue.mValue));
    }

    public OctValue negate() {
        if (this.mValue == null) {
            throw new IllegalStateException("Cannot negate infinity.");
        }
        return new OctValue(this.mValue.negate());
    }

    public OctValue negateIfNotInfinity() {
        if (this.mValue == null) {
            return this;
        }
        return new OctValue(this.mValue.negate());
    }

    public OctValue half() {
        if (this.mValue == null) {
            return INFINITY;
        }
        return new OctValue(this.mValue.divide(new BigDecimal(2)));
    }

    public OctValue floor() {
        if (this.mValue == null) {
            return INFINITY;
        }
        return new OctValue(this.mValue.setScale(0, RoundingMode.FLOOR));
    }

    public int signum() {
        return this.mValue == null ? 1 : this.mValue.signum();
    }

    @Override
    public int compareTo(OctValue octValue) {
        if (this == octValue || this.mValue == octValue.mValue) {
            return 0;
        }
        if (this.mValue == null) {
            return 1;
        }
        if (octValue.mValue == null) {
            return -1;
        }
        return this.mValue.compareTo(octValue.mValue);
    }

    public int hashCode() {
        return 31 + (this.mValue == null ? 0 : this.mValue.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OctValue octValue = (OctValue)object;
        return !(this.mValue == null ? octValue.mValue != null : !this.mValue.equals(octValue.mValue));
    }

    public String toString() {
        if (this.mValue == null) {
            return "inf";
        }
        return this.mValue.toString();
    }

    public static OctValue min(OctValue octValue, OctValue octValue2) {
        return octValue.compareTo(octValue2) <= 0 ? octValue : octValue2;
    }

    public static OctValue max(OctValue octValue, OctValue octValue2) {
        return octValue.compareTo(octValue2) >= 0 ? octValue : octValue2;
    }
}

