/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.SMTSolver;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.MotzkinTransformation;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class StemOverapproximator
implements AutoCloseable {
    private final boolean mAnnotateTerms;
    private static final boolean s_less_efficient_and_more_complete = false;
    private static final boolean s_return_true_if_approximation_fails = false;
    private Script mScript;
    private final IUltimateServiceProvider mServices;

    public StemOverapproximator(ILassoRankerPreferences iLassoRankerPreferences, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        this.mServices = iUltimateServiceProvider;
        this.mAnnotateTerms = iLassoRankerPreferences.isAnnotateTerms();
        this.mScript = SMTSolver.newScript(iLassoRankerPreferences, "SimplifySIs", iUltimateServiceProvider);
        this.mScript.setLogic(Logics.QF_LRA);
    }

    @Override
    public void close() {
        if (this.mScript != null) {
            this.mScript.exit();
            this.mScript = null;
        }
    }

    public LinearTransition overapproximate(LinearTransition linearTransition) {
        if (linearTransition.getNumPolyhedra() < 2) {
            return linearTransition;
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(linearTransition.getPolyhedra().get(0));
        hashSet.addAll(linearTransition.getPolyhedra().get(1));
        ArrayList<LinearInequality> arrayList = new ArrayList<LinearInequality>();
        for (LinearInequality linearInequality : hashSet) {
            this.mScript.push(1);
            for (List<LinearInequality> list : linearTransition.getPolyhedra()) {
                MotzkinTransformation motzkinTransformation = new MotzkinTransformation(this.mServices, this.mScript, AnalysisType.LINEAR, this.mAnnotateTerms);
                motzkinTransformation.addInequalities(list);
                LinearInequality linearInequality2 = new LinearInequality(linearInequality);
                linearInequality2.negate();
                motzkinTransformation.addInequality(linearInequality2);
                motzkinTransformation.mAnnotation = "stem implies candidate linear inequality";
                this.mScript.assertTerm(motzkinTransformation.transform(new Rational[0]));
            }
            if (this.mScript.checkSat().equals((Object)Script.LBool.SAT)) {
                arrayList.add(linearInequality);
            }
            this.mScript.pop(1);
        }
        if (arrayList.isEmpty()) {
            return linearTransition;
        }
        return new LinearTransition(Collections.singletonList(arrayList), linearTransition.getInVars(), linearTransition.getOutVars());
    }
}

