/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaSuccessorStateProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LevelRankingState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.StateWithRankInfo;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.WaToBuchiWrapper;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.BuchiWaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.StateWaNCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementNcsbStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BuchiComplementNCSBSimpleNwa<LETTER, STATE>
implements INwaSuccessorStateProvider<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final SetOfStates<STATE> mSetOfStates;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final IBuchiComplementNcsbStateFactory<STATE> mStateFactory;
    private final StateWithRankInfo<STATE> mEmptyStackStateWri;
    private final BuchiWaComplement mComplementBuchi;
    private final Map<LETTER, Integer> mLetterIdMap;
    private final Map<Integer, STATE> mIdStateMap;
    private final Map<STATE, Integer> mStateIdMap;
    private final WaToBuchiWrapper<LETTER, STATE> mOperandBuchi;
    private final Map<LevelRankingState<LETTER, STATE>, STATE> mDet2res = new HashMap<LevelRankingState<LETTER, STATE>, STATE>();
    private final Map<Integer, LevelRankingState<LETTER, STATE>> mInt2LevelRanks = new HashMap<Integer, LevelRankingState<LETTER, STATE>>();

    public BuchiComplementNCSBSimpleNwa(AutomataLibraryServices automataLibraryServices, IBuchiComplementNcsbStateFactory<STATE> iBuchiComplementNcsbStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iBuchiComplementNcsbStateFactory;
        this.mSetOfStates = new SetOfStates(this.mStateFactory.createEmptyStackState());
        this.mIdStateMap = new HashMap<Integer, STATE>();
        this.mStateIdMap = new HashMap<STATE, Integer>();
        int n = 0;
        this.mLetterIdMap = new HashMap<LETTER, Integer>();
        for (Object LETTER : iNwaOutgoingLetterAndTransitionProvider.getAlphabet()) {
            this.mLetterIdMap.put(LETTER, n);
            ++n;
        }
        this.mEmptyStackStateWri = new StateWithRankInfo<STATE>(this.mSetOfStates.getEmptyStackState());
        this.mOperandBuchi = new WaToBuchiWrapper<LETTER, STATE>(this.mLetterIdMap.size(), this.mLetterIdMap, iNwaOutgoingLetterAndTransitionProvider);
        this.mComplementBuchi = new BuchiWaComplement(this.mOperandBuchi);
        this.constructInitialState();
        Options.lazyB = false;
        Options.lazyS = false;
    }

    private void constructInitialState() {
        IntSet intSet = this.mComplementBuchi.getInitialStates();
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            this.getOrAdd(true, n);
        }
    }

    protected STATE getRelatedSTATE(int n) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.constructLevelRankingState(n);
        STATE STATE = this.mStateFactory.buchiComplementNcsb(levelRankingState);
        this.mDet2res.put(levelRankingState, STATE);
        return STATE;
    }

    public NCSB getRelatedNCSB(STATE STATE) {
        int n = this.mStateIdMap.get(STATE);
        StateWaNCSB stateWaNCSB = (StateWaNCSB)this.mComplementBuchi.getState(n);
        return stateWaNCSB.getNCSB();
    }

    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected LevelRankingState<LETTER, STATE> constructLevelRankingState(int n) {
        LevelRankingState<LETTER, STATE> levelRankingState = this.mInt2LevelRanks.get(n);
        if (levelRankingState != null) {
            return levelRankingState;
        }
        StateWaNCSB stateWaNCSB = (StateWaNCSB)this.mComplementBuchi.getState(n);
        NCSB nCSB = stateWaNCSB.getNCSB();
        levelRankingState = new LevelRankingState<LETTER, STATE>(this.mOperand);
        IntSet intSet = nCSB.getBSet();
        IntSet intSet2 = nCSB.getNSet();
        this.addLevelRankingState(levelRankingState, intSet2, 3, false);
        intSet2 = nCSB.copyCSet();
        intSet2.andNot(intSet);
        this.addLevelRankingState(levelRankingState, intSet2, 2, false);
        intSet2 = nCSB.copyCSet();
        intSet2.and(intSet);
        this.addLevelRankingState(levelRankingState, intSet2, 2, true);
        this.addLevelRankingState(levelRankingState, nCSB.getSSet(), 1, false);
        return levelRankingState;
    }

    private void addLevelRankingState(LevelRankingState<LETTER, STATE> levelRankingState, IntSet intSet, int n, boolean bl) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            levelRankingState.addRank(this.mEmptyStackStateWri, this.mOperandBuchi.getNwaSTATE(n2), n, bl);
        }
    }

    private STATE getOrAdd(boolean bl, int n) {
        STATE STATE = this.mIdStateMap.get(n);
        if (STATE == null) {
            STATE = this.getRelatedSTATE(n);
            this.mIdStateMap.put(n, STATE);
            this.mStateIdMap.put(STATE, n);
            this.mSetOfStates.addState(bl, this.mComplementBuchi.isFinal(n), STATE);
        } else assert (!bl);
        return STATE;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    @Override
    public int size() {
        return this.mSetOfStates.getStates().size();
    }

    @Override
    public String sizeInformation() {
        return "State size: " + this.size();
    }

    @Override
    public Collection<STATE> internalSuccessors(STATE STATE, LETTER LETTER) {
        int n = this.mLetterIdMap.get(LETTER);
        IStateWa iStateWa = this.mComplementBuchi.getState(this.mStateIdMap.get(STATE));
        IntSet intSet = iStateWa.getSuccessors(n);
        IntIterator intIterator = intSet.iterator();
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        while (intIterator.hasNext()) {
            STATE STATE2 = this.getOrAdd(false, intIterator.next());
            arrayList.add(STATE2);
        }
        return arrayList;
    }

    @Override
    public Collection<STATE> callSuccessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<STATE> returnSuccessorsGivenHier(STATE STATE, STATE STATE2, LETTER LETTER) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
        throw new UnsupportedOperationException();
    }

    public boolean coveredBy(STATE STATE, STATE STATE2) {
        int n = this.mStateIdMap.get(STATE);
        NCSB nCSB = ((StateWaNCSB)this.mComplementBuchi.getState(n)).getNCSB();
        int n2 = this.mStateIdMap.get(STATE2);
        NCSB nCSB2 = ((StateWaNCSB)this.mComplementBuchi.getState(n2)).getNCSB();
        return nCSB.coveredBy(nCSB2);
    }
}

