/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IStateNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateNwa
implements IStateNwa,
Comparable<StateNwa> {
    private final IBuchiNwa mBuchi;
    private final int mId;
    private final Map<Integer, IntSet> mSuccessorsInternal;
    private final Map<Integer, IntSet> mSuccessorsCall;
    private final Map<Integer, Map<Integer, IntSet>> mSuccessorsReturn;

    public StateNwa(IBuchiNwa iBuchiNwa, int n) {
        this.mBuchi = iBuchiNwa;
        this.mId = n;
        this.mSuccessorsCall = new HashMap<Integer, IntSet>();
        this.mSuccessorsInternal = new HashMap<Integer, IntSet>();
        this.mSuccessorsReturn = new HashMap<Integer, Map<Integer, IntSet>>();
    }

    @Override
    public int getId() {
        return this.mId;
    }

    private void addSuccessors(Map<Integer, IntSet> map, int n, int n2) {
        IntSet intSet = map.get(n);
        if (intSet == null) {
            intSet = UtilIntSet.newIntSet();
        }
        intSet.set(n2);
        map.put(n, intSet);
    }

    @Override
    public void addSuccessorInternal(int n, int n2) {
        assert (this.mBuchi.getAlphabetInternal().get(n));
        this.addSuccessors(this.mSuccessorsInternal, n, n2);
    }

    @Override
    public void addSuccessorCall(int n, int n2) {
        assert (this.mBuchi.getAlphabetCall().get(n));
        this.addSuccessors(this.mSuccessorsCall, n, n2);
    }

    @Override
    public void addSuccessorReturn(int n, int n2, int n3) {
        assert (this.mBuchi.getAlphabetReturn().get(n2));
        Map<Integer, IntSet> map = this.mSuccessorsReturn.get(n2);
        if (map == null) {
            map = new HashMap<Integer, IntSet>();
        }
        this.addSuccessors(map, n, n3);
        this.mSuccessorsReturn.put(n2, map);
    }

    private IntSet getSuccessors(Map<Integer, IntSet> map, int n) {
        IntSet intSet = map.get(n);
        if (intSet == null) {
            return UtilIntSet.newIntSet();
        }
        return intSet.clone();
    }

    @Override
    public IntSet getSuccessorsInternal(int n) {
        assert (this.mBuchi.getAlphabetInternal().get(n));
        return this.getSuccessors(this.mSuccessorsInternal, n);
    }

    @Override
    public IntSet getSuccessorsCall(int n) {
        assert (this.mBuchi.getAlphabetCall().get(n));
        return this.getSuccessors(this.mSuccessorsCall, n);
    }

    @Override
    public IntSet getSuccessorsReturn(int n, int n2) {
        assert (this.mBuchi.getAlphabetReturn().get(n2));
        Map<Integer, IntSet> map = this.mSuccessorsReturn.get(n2);
        if (map == null) {
            return UtilIntSet.newIntSet();
        }
        return this.getSuccessors(map, n);
    }

    @Override
    public Set<Integer> getEnabledLettersInternal() {
        return this.mSuccessorsInternal.keySet();
    }

    @Override
    public Set<Integer> getEnabledLettersCall() {
        return this.mSuccessorsCall.keySet();
    }

    @Override
    public Set<Integer> getEnabledLettersReturn() {
        return this.mSuccessorsReturn.keySet();
    }

    @Override
    public Set<Integer> getEnabledHiersReturn(int n) {
        Map<Integer, IntSet> map = this.mSuccessorsReturn.get(n);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    public int compareTo(StateNwa stateNwa) {
        return this.mId - stateNwa.mId;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StateNwa stateNwa = (StateNwa)object;
        return stateNwa.mId == this.mId;
    }

    @Override
    public int hashCode() {
        return this.mId;
    }

    @Override
    public String toString() {
        return "s" + this.mId;
    }

    @Override
    public void toDot(PrintStream printStream, List<String> list) {
        Object object;
        Object object22;
        Object object3;
        Set<Integer> set = this.getEnabledLettersCall();
        for (Integer object42 : set) {
            object3 = this.getSuccessorsCall(object42);
            this.transToDot(printStream, list, (IntSet)object3, list.get(object42) + "<");
        }
        Set<Integer> set2 = this.getEnabledLettersInternal();
        for (Object object22 : set2) {
            object = this.getSuccessorsInternal((Integer)object22);
            this.transToDot(printStream, list, (IntSet)object, list.get((Integer)object22).toString());
        }
        object22 = this.getEnabledLettersReturn();
        object = object22.iterator();
        while (object.hasNext()) {
            object3 = (Integer)object.next();
            Set<Integer> set3 = this.getEnabledHiersReturn((Integer)object3);
            for (Integer n : set3) {
                IntSet intSet = this.getSuccessorsReturn(n, (Integer)object3);
                this.transToDot(printStream, list, intSet, String.valueOf(n) + ",>" + list.get((Integer)object3));
            }
        }
    }

    private void transToDot(PrintStream printStream, List<String> list, IntSet intSet, String string) {
        for (Integer n : intSet.iterable()) {
            printStream.print("  " + this.getId() + " -> " + String.valueOf(n) + " [label=\"" + string.replace("\"", "") + "\"];\n");
        }
    }
}

