/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class LoopDetector<LETTER, STATE> {
    private final AGameGraph<LETTER, STATE> mGameGraph;
    private final ILogger mLogger;
    private final IProgressAwareTimer mProgressAwareTimer;

    public LoopDetector(AGameGraph<LETTER, STATE> aGameGraph, ILogger iLogger, IProgressAwareTimer iProgressAwareTimer) {
        this.mGameGraph = aGameGraph;
        this.mLogger = iLogger;
        this.mProgressAwareTimer = iProgressAwareTimer;
    }

    public boolean canVertexReachDestination(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2) throws AutomataOperationCanceledException {
        return !this.isLoopVertex(vertex, vertex2, null);
    }

    public boolean isLoopVertex(Vertex<LETTER, STATE> vertex, Vertex<LETTER, STATE> vertex2, Vertex<LETTER, STATE> vertex3) throws AutomataOperationCanceledException {
        LinkedList<Vertex<LETTER, STATE>> linkedList = new LinkedList<Vertex<LETTER, STATE>>();
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        linkedList.add(vertex);
        boolean bl = false;
        while (!linkedList.isEmpty() && !bl) {
            Set<Vertex<LETTER, STATE>> set;
            Vertex vertex4 = (Vertex)linkedList.poll();
            if (vertex4 == null) continue;
            if (vertex4.equals(vertex2)) {
                bl = true;
            }
            boolean bl2 = !hashSet.add(vertex4);
            boolean bl3 = vertex4.equals(vertex3);
            if (!(bl || bl2 || bl3 || (set = this.mGameGraph.getSuccessors(vertex4)) == null)) {
                linkedList.addAll(this.mGameGraph.getSuccessors(vertex4));
            }
            if (this.mProgressAwareTimer == null || this.mProgressAwareTimer.continueProcessing()) continue;
            this.mLogger.debug((Object)"Stopped in isLoopVertex");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        return !bl;
    }
}

