/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferencePetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferenceSynchronizationInformation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.FinitePrefix;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class DifferencePairwiseOnDemand<LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & INwaInclusionStateFactory<PLACE>>
extends GeneralOperation<LETTER, PLACE, CRSF> {
    private static final boolean ADD_FINITE_PREFIX_STATISTICS = true;
    private final IPetriNetSuccessorProvider<LETTER, PLACE> mMinuend;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> mSubtrahend;
    private final FinitePrefix<LETTER, PLACE> mFinitePrefixOfDifference;
    private final BoundedPetriNet<LETTER, PLACE> mResult;
    private final DifferenceSynchronizationInformation<LETTER, PLACE> mDifferenceSynchronizationInformation;
    private Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> mTransitionBacktranslation;

    public DifferencePairwiseOnDemand(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, PLACE> iPetriNetSuccessorProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> iNwaOutgoingLetterAndTransitionProvider, Set<LETTER> set) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        Set<LETTER> set2;
        this.mMinuend = iPetriNetSuccessorProvider;
        this.mSubtrahend = iNwaOutgoingLetterAndTransitionProvider;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        if (set != null) {
            set2 = set;
            if (this.mLogger.isInfoEnabled()) {
                var6_6 = set2.size();
                var7_8 = this.mSubtrahend.getAlphabet().size();
                this.mLogger.info((Object)"Universal subtrahend loopers provided by user.");
                this.mLogger.info((Object)("Number of universal subtrahend loopers: " + var6_6 + " of " + var7_8));
            }
        } else if (this.mSubtrahend instanceof INestedWordAutomaton) {
            set2 = DifferencePairwiseOnDemand.determineUniversalLoopers((INestedWordAutomaton)this.mSubtrahend);
            if (this.mLogger.isInfoEnabled()) {
                var6_6 = set2.size();
                var7_8 = this.mSubtrahend.getAlphabet().size();
                this.mLogger.info((Object)("Number of universal subtrahend loopers: " + var6_6 + " of " + var7_8));
            }
        } else {
            set2 = null;
            this.mLogger.info((Object)"Subtrahend is not yet constructed. Will not use universal subtrahend loopers optimization.");
        }
        DifferencePetriNet differencePetriNet = new DifferencePetriNet(this.mServices, this.mMinuend, this.mSubtrahend, set2);
        this.mFinitePrefixOfDifference = new FinitePrefix<LETTER, PLACE>(this.mServices, differencePetriNet);
        this.mResult = differencePetriNet.getYetConstructedPetriNet();
        this.mTransitionBacktranslation = differencePetriNet.getTransitionBacktranslation();
        Set set3 = ((BranchingProcess)this.mFinitePrefixOfDifference.getResult()).computeVitalTransitions();
        this.mDifferenceSynchronizationInformation = differencePetriNet.computeDifferenceSynchronizationInformation(set3, true);
        int n = differencePetriNet.getYetConstructedPetriNet().getTransitions().size();
        int n2 = n - set3.size();
        int n3 = this.mMinuend.getAlphabet().size() - this.mDifferenceSynchronizationInformation.getChangerLetters().size();
        this.mLogger.info((Object)(n3 + "/" + this.mMinuend.getAlphabet().size() + " looper letters, " + this.mDifferenceSynchronizationInformation.getSelfloops().size() + " selfloop transitions, " + this.mDifferenceSynchronizationInformation.getStateChangers().size() + " changer transitions " + n2 + "/" + n + " dead transitions."));
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    public DifferencePairwiseOnDemand(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<LETTER, PLACE> iPetriNetSuccessorProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, PLACE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iPetriNetSuccessorProvider, iNwaOutgoingLetterAndTransitionProvider, null);
    }

    public Map<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> getTransitionBacktranslation() {
        return this.mTransitionBacktranslation;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". First operand " + this.mMinuend.sizeInformation() + ". Second operand " + this.mSubtrahend.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        automataOperationStatistics.addAllStatistics(this.mFinitePrefixOfDifference.getAutomataOperationStatistics());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_ALPHABET, this.mResult.getAlphabet().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_PLACES, this.mResult.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_TRANSITIONS, this.mResult.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_FLOW, this.mResult.flowSize());
        if (this.mMinuend instanceof IPetriNet) {
            IPetriNet iPetriNet = (IPetriNet)this.mMinuend;
            automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_PLACES, iPetriNet.getPlaces().size());
            automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_TRANSITIONS, iPetriNet.getTransitions().size());
            automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_FLOW, iPetriNet.flowSize());
        }
        if (this.mSubtrahend instanceof INestedWordAutomaton) {
            automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_SUBTRAHEND_STATES, ((INestedWordAutomaton)this.mSubtrahend).getStates().size());
        }
        return automataOperationStatistics;
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    public FinitePrefix<LETTER, PLACE> getFinitePrefixOfDifference() {
        return this.mFinitePrefixOfDifference;
    }

    public DifferenceSynchronizationInformation<LETTER, PLACE> getDifferenceSynchronizationInformation() {
        return this.mDifferenceSynchronizationInformation;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of " + this.getOperationName()));
        }
        Object object = this.mSubtrahend instanceof INestedWordAutomaton ? (INestedWordAutomaton)this.mSubtrahend : new RemoveDeadEnds<LETTER, PLACE>(this.mServices, this.mSubtrahend).getResult();
        if (!(this.mMinuend instanceof IPetriNetTransitionProvider)) {
            throw new UnsupportedOperationException("Convert minuend to fully constructed net");
        }
        boolean bl = PetriNetUtils.doDifferenceLanguageCheck(this.mServices, CRSF, (IPetriNetTransitionProvider)this.mMinuend, object, this.mResult);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    private static <LETTER, STATE> Set<LETTER> determineUniversalLoopers(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNestedWordAutomaton)) {
            throw new UnsupportedOperationException("call and return not implemented yet");
        }
        return iNestedWordAutomaton.getAlphabet().stream().filter(object -> DifferencePairwiseOnDemand.isUniversalLooper(object, iNestedWordAutomaton)).collect(Collectors.toSet());
    }

    private static <LETTER, STATE> boolean isUniversalLooper(LETTER LETTER, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        return iNestedWordAutomaton.getStates().stream().allMatch(object2 -> DifferencePairwiseOnDemand.hasSelfloop(LETTER, object2, iNestedWordAutomaton));
    }

    private static <LETTER, STATE> boolean hasSelfloop(LETTER LETTER, STATE STATE, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        Iterator<OutgoingInternalTransition<LETTER, STATE>> iterator = iNestedWordAutomaton.internalSuccessors(STATE, LETTER).iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("automaton is nondeterministic");
        }
        return outgoingInternalTransition.getSucc().equals(STATE);
    }
}

