/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RabinUnion<LETTER, STATE>
implements IRabinAutomaton<LETTER, STATE> {
    private final IRabinAutomaton<LETTER, STATE> mFirstAutomaton;
    private final IRabinAutomaton<LETTER, STATE> mSecondAutomaton;
    private final IBlackWhiteStateFactory<STATE> mFactory;
    private Set<STATE> mInitialStates;
    HashMap<STATE, Pair<Boolean, STATE>> mAutomatonMap = new HashMap();

    public RabinUnion(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, IRabinAutomaton<LETTER, STATE> iRabinAutomaton2, IBlackWhiteStateFactory<STATE> iBlackWhiteStateFactory) {
        this.mFirstAutomaton = iRabinAutomaton;
        this.mSecondAutomaton = iRabinAutomaton2;
        this.mFactory = iBlackWhiteStateFactory;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        assert (this.mFirstAutomaton.getAlphabet().equals(this.mSecondAutomaton.getAlphabet()));
        return this.mFirstAutomaton.getAlphabet();
    }

    @Override
    public int size() {
        return this.mFirstAutomaton.size() + this.mSecondAutomaton.size();
    }

    @Override
    public String sizeInformation() {
        return "Number of states: " + this.size() + "\nof these there are: " + this.mFirstAutomaton.size() + " from firstAutomaton and: " + this.mSecondAutomaton.size() + " from secondAutomaton";
    }

    private Set<STATE> constructInitialStates() {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (STATE STATE : this.mFirstAutomaton.getInitialStates()) {
            hashSet.add(this.getUnionState(STATE, true));
        }
        for (STATE STATE : this.mSecondAutomaton.getInitialStates()) {
            hashSet.add(this.getUnionState(STATE, false));
        }
        return hashSet;
    }

    @Override
    public Set<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialStates();
        }
        return this.mInitialStates;
    }

    @Override
    public boolean isAccepting(STATE STATE) {
        Pair<Boolean, STATE> pair = this.mAutomatonMap.get(STATE);
        return this.getSubautomaton((Boolean)pair.getFirst()).isAccepting(pair.getSecond());
    }

    @Override
    public boolean isFinite(STATE STATE) {
        Pair<Boolean, STATE> pair = this.mAutomatonMap.get(STATE);
        return this.getSubautomaton((Boolean)pair.getFirst()).isFinite(pair.getSecond());
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE) {
        Pair<Boolean, STATE> pair = this.mAutomatonMap.get(STATE);
        boolean bl = (Boolean)pair.getFirst();
        return this.constructSuccessors(this.getSubautomaton(bl).getSuccessors(pair.getSecond()), bl);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE, LETTER LETTER) {
        Pair<Boolean, STATE> pair = this.mAutomatonMap.get(STATE);
        boolean bl = (Boolean)pair.getFirst();
        return this.constructSuccessors(this.getSubautomaton(bl).getSuccessors(pair.getSecond(), LETTER), bl);
    }

    private Iterable<OutgoingInternalTransition<LETTER, STATE>> constructSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, boolean bl) {
        return () -> new TransformIterator(iterable.iterator(), outgoingInternalTransition -> new OutgoingInternalTransition(outgoingInternalTransition.getLetter(), this.getUnionState(outgoingInternalTransition.getSucc(), bl)));
    }

    private STATE getUnionState(STATE STATE, boolean bl) {
        STATE STATE2 = bl ? this.mFactory.getBlackContent(STATE) : this.mFactory.getWhiteContent(STATE);
        if (this.mAutomatonMap.containsKey(STATE2)) {
            return STATE2;
        }
        this.mAutomatonMap.put(STATE2, new Pair((Object)bl, STATE));
        return STATE2;
    }

    private IRabinAutomaton<LETTER, STATE> getSubautomaton(boolean bl) {
        if (bl) {
            return this.mFirstAutomaton;
        }
        return this.mSecondAutomaton;
    }
}

