/*
 * Decompiled with CFR 0.152.
 */
package ap.interpolants;

import ap.Signature;
import ap.interpolants.SoftwareInterpolationFramework;
import ap.interpolants.WolverineInterpolantLineariser;
import ap.parser.IExpression$;
import ap.parser.IFormula;
import ap.parser.PartName;
import ap.parser.PartName$;
import ap.proof.ModelSearchProver;
import ap.proof.certificates.Certificate;
import ap.terfor.TermOrder;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.conjunctions.Conjunction$;
import ap.util.Debug;
import ap.util.Debug$;
import ap.util.Debug$AC_INTERPOLATION_IMPLICATION_CHECKS$;
import ap.util.Debug$AC_MAIN$;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class WolverineInterfaceMain$
extends SoftwareInterpolationFramework {
    public static WolverineInterfaceMain$ MODULE$;
    private final BoxedUnit nothing;
    private final Debug$AC_MAIN$ AC;
    private boolean assertions;
    private final WolverineInterpolantLineariser wolverineLineariser;

    static {
        new WolverineInterfaceMain$();
    }

    public void nothing() {
    }

    private Debug$AC_MAIN$ AC() {
        return this.AC;
    }

    private boolean assertions() {
        return this.assertions;
    }

    private void assertions_$eq(boolean x$1) {
        this.assertions = x$1;
    }

    private WolverineInterpolantLineariser wolverineLineariser() {
        return this.wolverineLineariser;
    }

    public void main(String[] args) {
        Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println();
            Predef$.MODULE$.println((Object)"Waiting for input ...");
            Predef$.MODULE$.println((Object)"-> Terminate each problem with \"interpolate.\" or \"checkValidity.\"");
            Predef$.MODULE$.println((Object)"   in a separate line");
            Predef$.MODULE$.println((Object)"-> Specify options using the environment variable \"WERE_PRINCESS_OPTIONS\"");
            Predef$.MODULE$.println((Object)"-> Stop Princess with a \"quit.\" in a separate line");
            ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newCachedThreadPool());
            while (true) {
                PipedOutputStream stdinOutputStream = new PipedOutputStream();
                PipedInputStream stdinInputStream = new PipedInputStream(stdinOutputStream);
                Future lastLine = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ObjectRef line;
                    block5: {
                        try {
                            line = ObjectRef.create((Object)Console$.MODULE$.in().readLine());
                            Console$.MODULE$.withOut((OutputStream)stdinOutputStream, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                while ((String)line$1.elem != null && !((String)line$1.elem).endsWith(".")) {
                                    Predef$.MODULE$.println((Object)((String)line$1.elem));
                                    line$1.elem = Console$.MODULE$.in().readLine();
                                }
                            });
                            stdinOutputStream.close();
                            String string = (String)line.elem;
                            if (!(string == null ? true : "quit.".equals(string))) break block5;
                            System.exit(0);
                            return "";
                        }
                        catch (IOException e) {
                            Predef$.MODULE$.println((Object)e.getMessage());
                            System.exit(1);
                            return "";
                        }
                    }
                    String string = (String)line.elem;
                    return string;
                }, (ExecutionContext)ec);
                Tuple2<Map<PartName, Conjunction>, Signature> tuple2 = MODULE$.parseAndSimplify(new BufferedReader(new InputStreamReader(stdinInputStream)));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Map transitionParts = (Map)tuple2._1();
                Signature sig = (Signature)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)transitionParts, (Object)sig);
                Map transitionParts2 = (Map)tuple22._1();
                Signature sig2 = (Signature)tuple22._2();
                String string = (String)Await$.MODULE$.result((Awaitable)lastLine, (Duration)Duration$.MODULE$.Inf());
                if ("interpolate.".equals(string)) {
                    MODULE$.doInterpolation((Map<PartName, Conjunction>)transitionParts2, sig2);
                } else if ("checkValidity.".equals(string)) {
                    MODULE$.doCheckValidity((Map<PartName, Conjunction>)transitionParts2, sig2);
                } else if (string != null) {
                    String string2 = string;
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append("Unknown command: ").append(string2).toString());
                    System.exit(1);
                } else {
                    throw new MatchError((Object)string);
                }
                Console$.MODULE$.withOut(System.out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)"."));
            }
        });
    }

    private void doInterpolation(Map<PartName, Conjunction> transitionParts, Signature sig) {
        Seq<PartName> names = this.sortNamesLex(transitionParts);
        Seq parts = (Seq)names.map((Function1 & Serializable & scala.Serializable)n -> (Conjunction)transitionParts.apply(n), Seq$.MODULE$.canBuildFrom());
        Either<Conjunction, Iterator<Conjunction>> res = this.genInterpolants((Seq<Conjunction>)parts, (Conjunction)transitionParts.getOrElse((Object)PartName$.MODULE$.NO_NAME(), (Function0 & Serializable & scala.Serializable)() -> Conjunction$.MODULE$.TRUE()), sig.order());
        Console$.MODULE$.withOut(System.out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Either either = res;
            if (either instanceof Left) {
                Left left = (Left)either;
                Conjunction counterexample = (Conjunction)left.value();
                Predef$.MODULE$.println((Object)"INVALID");
                Predef$.MODULE$.println((Object)counterexample);
                return;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Iterator interpolants = (Iterator)right.value();
                Predef$.MODULE$.println((Object)"VALID");
                ObjectRef lastInterpolant = ObjectRef.create((Object)IExpression$.MODULE$.Boolean2IFormula(true));
                ModelSearchProver.IncProver interpolantImpChecker = MODULE$.validityCheckProver().conclude((Iterable<Conjunction>)transitionParts.get((Object)PartName$.MODULE$.NO_NAME()).toList(), sig.order());
                MODULE$.dumpInterpolationProblem(transitionParts, sig);
                interpolants.zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)WolverineInterfaceMain$.$anonfun$doInterpolation$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    WolverineInterfaceMain$.$anonfun$doInterpolation$5(lastInterpolant, sig, interpolantImpChecker, transitionParts, names, x$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    private void doCheckValidity(Map<PartName, Conjunction> transitionParts, Signature sig) {
        Either<Conjunction, Certificate> res = this.validityCheckProver().conclude((Iterable<Conjunction>)transitionParts.values().toList(), sig.order()).checkValidity(false);
        Console$.MODULE$.withOut(System.out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            Left left = null;
            Either either = res;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Conjunction conjunction = (Conjunction)left.value();
                Conjunction conjunction2 = Conjunction$.MODULE$.FALSE();
                Conjunction conjunction3 = conjunction;
                if (!(conjunction2 != null ? !((Object)conjunction2).equals(conjunction3) : conjunction3 != null)) {
                    Predef$.MODULE$.println((Object)"VALID");
                    return;
                }
            }
            if (bl) {
                Conjunction counterexample = (Conjunction)left.value();
                Predef$.MODULE$.println((Object)"INVALID");
                Predef$.MODULE$.println((Object)counterexample);
                return;
            }
            Predef$.MODULE$.assert(false);
        });
    }

    public static final /* synthetic */ void $anonfun$new$1(Regex DumpInterpolationProblems$1, String option) {
        String string = option;
        if ("noAssertions".equals(string)) {
            MODULE$.assertions_$eq(false);
            return;
        }
        Option option2 = DumpInterpolationProblems$1.unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
            String filename = (String)((LinearSeqOptimized)option2.get()).apply(0);
            MODULE$.interpolationProblemBasename_$eq(filename);
            return;
        }
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Unknown option: ").append(string).toString());
            Predef$.MODULE$.println((Object)"Possible options are: noAssertions");
            System.exit(1);
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$3(Debug.ASSERTION_TYPE x0$1, Debug.ASSERTION_CATEGORY x1$1) {
        Debug.ASSERTION_CATEGORY aSSERTION_CATEGORY;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null && Debug$AC_INTERPOLATION_IMPLICATION_CHECKS$.MODULE$.equals(aSSERTION_CATEGORY = (Debug.ASSERTION_CATEGORY)tuple2._2())) {
            return false;
        }
        return MODULE$.assertions();
    }

    public static final /* synthetic */ boolean $anonfun$doInterpolation$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$doInterpolation$5(ObjectRef lastInterpolant$1, Signature sig$1, ModelSearchProver.IncProver interpolantImpChecker$1, Map transitionParts$1, Seq names$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Conjunction i = (Conjunction)tuple2._1();
            int num = tuple2._2$mcI$sp();
            IFormula simpInter = MODULE$.toInputAbsyAndSimplify(i);
            MODULE$.wolverineLineariser().visit(simpInter, Nil$.MODULE$);
            Predef$.MODULE$.println();
            Debug$.MODULE$.assertIntFast(MODULE$.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                Tuple2<Conjunction, TermOrder> tuple2 = MODULE$.toInternal(((IFormula)lastInterpolant$1.elem).$eq$eq$greater(simpInter), sig$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Conjunction implication = (Conjunction)tuple2._1();
                TermOrder order = (TermOrder)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)implication, (Object)order);
                Conjunction implication2 = (Conjunction)tuple22._1();
                TermOrder order2 = (TermOrder)tuple22._2();
                Either<Conjunction, Certificate> either = interpolantImpChecker$1.conclude((Conjunction)transitionParts$1.apply(names$1.apply(num)), order2).conclude(implication2, order2).checkValidity(false);
                Left left = package$.MODULE$.Left().apply((Object)Conjunction$.MODULE$.FALSE());
                return !(either != null ? !either.equals((Object)left) : left != null);
            });
            lastInterpolant$1.elem = simpInter;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private WolverineInterfaceMain$() {
        BoxedUnit nothing;
        this.nothing = nothing = (BoxedUnit)Console$.MODULE$.withOut(Console$.MODULE$.err(), (Function0)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.println((Object)"________       _____");
                Predef$.MODULE$.println((Object)"___  __ \\_________(_)________________________________");
                Predef$.MODULE$.println((Object)"__  /_/ /_  ___/_  /__  __ \\  ___/  _ \\_  ___/_  ___/");
                Predef$.MODULE$.println((Object)"_  ____/_  /   _  / _  / / / /__ /  __/(__  )_(__  )");
                Predef$.MODULE$.println((Object)"/_/     /_/    /_/  /_/ /_/\\___/ \\___//____/ /____/");
                Predef$.MODULE$.println();
                Predef$.MODULE$.println((Object)"(The Princess in the wolf skin)");
                Predef$.MODULE$.println();
            }
        });
        MODULE$ = this;
        this.AC = Debug$AC_MAIN$.MODULE$;
        this.assertions = true;
        String string = System.getenv("WERE_PRINCESS_OPTIONS");
        if (string == null) {
        } else {
            Regex DumpInterpolationProblems = new StringOps(Predef$.MODULE$.augmentString("dumpInterpolationProblems=(.+)")).r();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(string)).split(','))).foreach((Function1 & Serializable & scala.Serializable)option -> {
                WolverineInterfaceMain$.$anonfun$new$1(DumpInterpolationProblems, option);
                return BoxedUnit.UNIT;
            });
        }
        Debug$.MODULE$.enabledAssertions().value_$eq((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)WolverineInterfaceMain$.$anonfun$new$3(x0$1, x1$1)));
        this.wolverineLineariser = new WolverineInterpolantLineariser();
    }
}

