/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.ArrayList;

public class FiniteSortInterpretation
implements SortInterpretation {
    private final Model mModel;
    private final ArrayList<Term> mValues;

    public FiniteSortInterpretation(Model model) {
        this.mModel = model;
        this.mValues = new ArrayList();
    }

    @Override
    public Term toSMTLIB(Theory theory, Sort sort) {
        TermVariable termVariable = theory.createTermVariable("@v", sort);
        Term[] termArray = new Term[this.mValues.size()];
        int n = 0;
        while (n < this.mValues.size()) {
            termArray[n] = theory.equals(new Term[]{termVariable, this.mValues.get(n)});
            ++n;
        }
        return theory.forall(new TermVariable[]{termVariable}, theory.or(termArray));
    }

    @Override
    public void register(Term term) {
        assert (((ApplicationTerm)term).getFunction().isModelValue());
    }

    @Override
    public Term extendFresh(Sort sort) {
        Theory theory = sort.getTheory();
        int n = this.mModel.getFreshModelValue();
        Term term = theory.term(theory.getFunctionWithResult("@" + n, null, sort, new Sort[0]), new Term[0]);
        this.mValues.add(term);
        return term;
    }

    @Override
    public Term getModelValue(int n, Sort sort) {
        while (n >= this.mValues.size()) {
            this.extendFresh(sort);
        }
        return this.mValues.get(n);
    }
}

