/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.util.ArrayDeque;
import java.util.Collections;

public class LiteralReason
extends LAReason {
    private final Literal mLiteral;
    ArrayDeque<LAReason> mDependents;
    private LiteralReason mOldLiteralReason;

    public LiteralReason(LinVar linVar, LiteralReason literalReason, InfinitesimalNumber infinitesimalNumber, boolean bl, Literal literal, LiteralReason literalReason2) {
        super(linVar, infinitesimalNumber, bl, literalReason2);
        this.mOldLiteralReason = literalReason;
        this.mLiteral = literal;
    }

    public LiteralReason(LinVar linVar, LiteralReason literalReason, InfinitesimalNumber infinitesimalNumber, boolean bl, Literal literal) {
        this(linVar, literalReason, infinitesimalNumber, bl, literal, null);
    }

    public Literal getLiteral() {
        return this.mLiteral;
    }

    public void addDependent(LAReason lAReason) {
        assert (this.getLastLiteral() == this);
        if (this.mDependents == null) {
            this.mDependents = new ArrayDeque();
        }
        this.mDependents.addFirst(lAReason);
    }

    public Iterable<LAReason> getDependents() {
        if (this.mDependents == null) {
            return Collections.emptySet();
        }
        return this.mDependents;
    }

    @Override
    InfinitesimalNumber explain(Explainer explainer, InfinitesimalNumber infinitesimalNumber, Rational rational) {
        if (!explainer.canExplainWith(this.mLiteral)) {
            assert (this.getBound().equals(this.getOldReason().getBound()));
            return this.getOldReason().explain(explainer, infinitesimalNumber, rational);
        }
        assert (this.mLiteral.getAtom().getDecideStatus() == this.mLiteral);
        if (this.mLiteral.negate() instanceof LAEquality) {
            InfinitesimalNumber infinitesimalNumber2 = infinitesimalNumber.sub(this.getVar().getEpsilon());
            if (infinitesimalNumber2.compareTo(InfinitesimalNumber.ZERO) > 0) {
                return this.getOldReason().explain(explainer, infinitesimalNumber2, rational);
            }
            explainer.addEQAnnotation(this, rational);
            return infinitesimalNumber;
        }
        explainer.addLiteral(this.mLiteral.negate(), rational);
        return infinitesimalNumber;
    }

    public int getDecideLevel() {
        return this.getLiteral().getAtom().getDecideLevel();
    }

    public int getStackPosition() {
        return this.getLiteral().getAtom().getStackPosition();
    }

    public LiteralReason getOldLiteralReason() {
        return this.mOldLiteralReason;
    }

    public void setOldLiteralReason(LiteralReason literalReason) {
        this.mOldLiteralReason = literalReason;
    }
}

