/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GeometricNonTerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.NoResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TimeoutResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnsupportedSyntaxResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.BacktranslationUtil;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.NonterminationArgumentStatistics;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.AffineTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposedLexicographicTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.LexicographicTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.MultiphaseTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.NestedTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ParallelTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.PiecewiseTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.LassoExtractorBuchi;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.PreferencesInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker.TermVariableRenamer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.RankVarConstructor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.preferences.RcfgPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LassoRankerStarter {
    private final ILogger mLogger;
    private static final String LASSO_ERROR_MSG = "This is not a lasso program (a lasso program is a program consisting of a stem and a loop transition)";
    private final IIcfg<IcfgLocation> mIcfg;
    private final IcfgLocation mHonda;
    private final NestedWord<IIcfgTransition<IcfgLocation>> mStem;
    private final NestedWord<IIcfgTransition<IcfgLocation>> mLoop;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final RankVarConstructor mRankVarConstructor;

    public LassoRankerStarter(IIcfg<IcfgLocation> iIcfg, IUltimateServiceProvider iUltimateServiceProvider) throws IOException {
        TerminationAnalysisSettings terminationAnalysisSettings;
        UnmodifiableTransFormula unmodifiableTransFormula;
        LassoExtractorBuchi lassoExtractorBuchi;
        this.mIcfg = Objects.requireNonNull(iIcfg);
        this.mServices = Objects.requireNonNull(iUltimateServiceProvider);
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        LassoRankerPreferences lassoRankerPreferences = PreferencesInitializer.getLassoRankerPreferences(this.mServices);
        this.mCsToolkit = this.mIcfg.getCfgSmtToolkit();
        this.mRankVarConstructor = new RankVarConstructor(this.mIcfg.getCfgSmtToolkit());
        this.mPredicateFactory = new PredicateFactory(this.mServices, this.mCsToolkit.getManagedScript(), this.mRankVarConstructor.getCsToolkitWithRankVariables().getSymbolTable());
        try {
            lassoExtractorBuchi = new LassoExtractorBuchi(this.mServices, iIcfg, this.mCsToolkit, this.mPredicateFactory, this.mLogger);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw new AssertionError((Object)"timeout while searching lasso");
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException.toString());
        }
        if (!lassoExtractorBuchi.wasLassoFound()) {
            this.reportUnuspportedSyntax((IIcfgElement)lassoExtractorBuchi.getSomeNoneForErrorReport(), LASSO_ERROR_MSG);
            this.mStem = null;
            this.mLoop = null;
            this.mHonda = null;
            return;
        }
        this.mStem = lassoExtractorBuchi.getStem();
        this.mLoop = lassoExtractorBuchi.getLoop();
        this.mHonda = lassoExtractorBuchi.getHonda();
        ManagedScript managedScript = this.mCsToolkit.getManagedScript();
        TermVariableRenamer termVariableRenamer = new TermVariableRenamer(managedScript);
        if (this.mStem == null) {
            unmodifiableTransFormula = null;
        } else {
            unmodifiableTransFormula = this.constructTransformula(this.mStem);
            unmodifiableTransFormula = termVariableRenamer.renameVars(unmodifiableTransFormula, "Stem");
        }
        UnmodifiableTransFormula unmodifiableTransFormula2 = this.constructTransformula(this.mLoop);
        unmodifiableTransFormula2 = termVariableRenamer.renameVars(unmodifiableTransFormula2, "Loop");
        SmtFunctionsAndAxioms smtFunctionsAndAxioms = this.mIcfg.getCfgSmtToolkit().getSmtFunctionsAndAxioms();
        Set set = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(this.mHonda.getProcedure());
        LassoAnalysis lassoAnalysis = null;
        try {
            lassoAnalysis = new LassoAnalysis(this.mIcfg.getCfgSmtToolkit(), unmodifiableTransFormula, unmodifiableTransFormula2, set, smtFunctionsAndAxioms, (ILassoRankerPreferences)lassoRankerPreferences, this.mServices, this.mSimplificationTechnique);
        }
        catch (TermException termException) {
            this.reportUnuspportedSyntax((IIcfgElement)this.mHonda, termException.getMessage());
            return;
        }
        NonTerminationAnalysisSettings nonTerminationAnalysisSettings = PreferencesInitializer.getNonTerminationAnalysisSettings(this.mServices);
        if (nonTerminationAnalysisSettings.getAnalysis() != AnalysisType.DISABLED) {
            try {
                terminationAnalysisSettings = lassoAnalysis.checkNonTermination(nonTerminationAnalysisSettings);
                if (terminationAnalysisSettings != null) {
                    if (!this.lassoWasOverapproximated().isEmpty()) {
                        this.reportFailBecauseOfOverapproximationResult();
                        return;
                    }
                    this.reportResult((IResult)new StatisticsResult("LassoRanker", NonterminationArgumentStatistics.class.getSimpleName(), (ICsvProviderProvider)new NonterminationArgumentStatistics((NonTerminationArgument)terminationAnalysisSettings)));
                    this.reportNonTerminationResult((GeometricNonTerminationArgument)terminationAnalysisSettings, this.mStem, this.mLoop);
                    return;
                }
            }
            catch (SMTLIBException sMTLIBException) {
                this.mLogger.error((Object)sMTLIBException);
            }
            catch (TermException termException) {
                this.mLogger.error((Object)termException);
            }
        }
        terminationAnalysisSettings = PreferencesInitializer.getTerminationAnalysisSettings(this.mServices);
        LassoAnalysis lassoAnalysis2 = null;
        try {
            lassoAnalysis2 = new LassoAnalysis(this.mIcfg.getCfgSmtToolkit(), unmodifiableTransFormula, unmodifiableTransFormula2, set, smtFunctionsAndAxioms, (ILassoRankerPreferences)lassoRankerPreferences, this.mServices, this.mSimplificationTechnique);
        }
        catch (TermException termException) {
            this.reportUnuspportedSyntax((IIcfgElement)this.mHonda, termException.getMessage());
            return;
        }
        RankingTemplate[] rankingTemplateArray = terminationAnalysisSettings.getAnalysis() == AnalysisType.DISABLED ? new RankingTemplate[]{} : this.getTemplates();
        RankingTemplate[] rankingTemplateArray2 = rankingTemplateArray;
        int n = rankingTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            RankingTemplate rankingTemplate = rankingTemplateArray2[n2];
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                this.reportTimeoutResult(rankingTemplateArray, rankingTemplate);
                return;
            }
            try {
                TerminationArgument terminationArgument = lassoAnalysis2.tryTemplate(rankingTemplate, terminationAnalysisSettings);
                if (terminationArgument != null) {
                    this.reportTerminationResult(terminationArgument);
                    return;
                }
            }
            catch (TermException termException) {
                this.mLogger.error((Object)termException);
                throw new AssertionError((Object)termException);
            }
            catch (SMTLIBException sMTLIBException) {
                this.mLogger.error((Object)sMTLIBException);
                throw new AssertionError((Object)sMTLIBException);
            }
            ++n2;
        }
        this.reportNoResult(rankingTemplateArray);
    }

    private HashRelation<String, ILocation> lassoWasOverapproximated() {
        HashRelation hashRelation = new HashRelation();
        hashRelation.addAll((AbstractRelation)Overapprox.getOverapproximations((List)this.mStem.asList()));
        hashRelation.addAll((AbstractRelation)Overapprox.getOverapproximations((List)this.mLoop.asList()));
        return hashRelation;
    }

    public UnmodifiableTransFormula constructTransformula(NestedWord<IIcfgTransition<IcfgLocation>> nestedWord) {
        List list = Collections.unmodifiableList(nestedWord.asList());
        return SequentialComposition.getInterproceduralTransFormula((CfgSmtToolkit)this.mCsToolkit, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, list, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
    }

    private RankingTemplate[] getTemplates() {
        int n;
        AffineTemplate[] affineTemplateArray;
        int n2;
        int n3;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iPreferenceProvider.getBoolean("Affine template")) {
            arrayList.add(new AffineTemplate());
        }
        if (iPreferenceProvider.getBoolean("Nested template")) {
            n3 = iPreferenceProvider.getInt("Nested template size");
            n2 = 2;
            while (n2 <= n3) {
                arrayList.add(new NestedTemplate(n2));
                ++n2;
            }
        }
        if (iPreferenceProvider.getBoolean("Multiphase template")) {
            n3 = iPreferenceProvider.getInt("Multiphase template size");
            n2 = 2;
            while (n2 <= n3) {
                arrayList.add(new MultiphaseTemplate(n2));
                ++n2;
            }
        }
        if (iPreferenceProvider.getBoolean("Lexicographic template")) {
            n3 = iPreferenceProvider.getInt("Lexicographic template size");
            n2 = 2;
            while (n2 <= n3) {
                affineTemplateArray = new AffineTemplate[n2];
                n = 0;
                while (n < n2) {
                    affineTemplateArray[n] = new AffineTemplate();
                    ++n;
                }
                arrayList.add(new ComposedLexicographicTemplate((ComposableTemplate[])affineTemplateArray));
                ++n2;
            }
        }
        if (iPreferenceProvider.getBoolean("Piecewise template")) {
            n3 = iPreferenceProvider.getInt("Piecewise template size");
            n2 = 2;
            while (n2 <= n3) {
                arrayList.add(new PiecewiseTemplate(n2));
                ++n2;
            }
        }
        if (iPreferenceProvider.getBoolean("Parallel template")) {
            n3 = iPreferenceProvider.getInt("Parallel template size");
            n2 = 2;
            while (n2 <= n3) {
                arrayList.add(new ParallelTemplate(n2));
                ++n2;
            }
        }
        if (iPreferenceProvider.getBoolean("Multilex template")) {
            n3 = iPreferenceProvider.getInt("Multilex template size");
            n2 = 2;
            while (n2 <= n3) {
                affineTemplateArray = new ComposableTemplate[n2];
                n = 0;
                while (n < n2) {
                    affineTemplateArray[n] = new MultiphaseTemplate(n2);
                    ++n;
                }
                arrayList.add(new ComposedLexicographicTemplate((ComposableTemplate[])affineTemplateArray));
                ++n2;
            }
        }
        return arrayList.toArray(new RankingTemplate[arrayList.size()]);
    }

    private RankingTemplate[] getTemplatesExactly() {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iPreferenceProvider.getBoolean("Affine template")) {
            arrayList.add(new AffineTemplate());
        }
        if (iPreferenceProvider.getBoolean("Nested template")) {
            arrayList.add(new NestedTemplate(iPreferenceProvider.getInt("Nested template size")));
        }
        if (iPreferenceProvider.getBoolean("Multiphase template")) {
            arrayList.add(new MultiphaseTemplate(iPreferenceProvider.getInt("Multiphase template size")));
        }
        if (iPreferenceProvider.getBoolean("Lexicographic template")) {
            arrayList.add(new LexicographicTemplate(iPreferenceProvider.getInt("Lexicographic template size")));
        }
        if (iPreferenceProvider.getBoolean("Piecewise template")) {
            arrayList.add(new PiecewiseTemplate(iPreferenceProvider.getInt("Piecewise template size")));
        }
        if (iPreferenceProvider.getBoolean("Parallel template")) {
            arrayList.add(new ParallelTemplate(iPreferenceProvider.getInt("Parallel template size")));
        }
        return arrayList.toArray(new RankingTemplate[arrayList.size()]);
    }

    private IBacktranslationService getTranslatorSequence() {
        return this.mServices.getBacktranslationService();
    }

    private void reportTerminationResult(TerminationArgument terminationArgument) {
        SupportingInvariant supportingInvariant2;
        RankingFunction rankingFunction = terminationArgument.getRankingFunction();
        Collection collection = terminationArgument.getSupportingInvariants();
        Script script = this.mCsToolkit.getManagedScript().getScript();
        Object[] objectArray = new Term[collection.size()];
        int n = 0;
        for (SupportingInvariant supportingInvariant2 : collection) {
            objectArray[n] = supportingInvariant2.asTerm(script);
            ++n;
        }
        supportingInvariant2 = new TerminationArgumentResult((IElement)this.mHonda, "LassoRanker", (Object[])rankingFunction.asLexTerm(script), rankingFunction.getName(), objectArray, this.getTranslatorSequence(), Term.class);
        this.reportResult((IResult)supportingInvariant2);
    }

    private void reportNonTerminationResult(GeometricNonTerminationArgument geometricNonTerminationArgument, NestedWord<IIcfgTransition<IcfgLocation>> nestedWord, NestedWord<IIcfgTransition<IcfgLocation>> nestedWord2) {
        IcfgProgramExecution icfgProgramExecution = IcfgProgramExecution.create((List)nestedWord.asList(), Collections.emptyMap());
        IcfgProgramExecution icfgProgramExecution2 = IcfgProgramExecution.create((List)nestedWord2.asList(), Collections.emptyMap());
        IcfgEdge icfgEdge = (IcfgEdge)nestedWord2.getSymbol(0);
        ArrayList<Map> arrayList = new ArrayList<Map>();
        arrayList.add(geometricNonTerminationArgument.getStateInit());
        arrayList.add(geometricNonTerminationArgument.getStateHonda());
        arrayList.addAll(geometricNonTerminationArgument.getGEVs());
        List list = BacktranslationUtil.rank2Rcfg(arrayList);
        GeometricNonTerminationArgumentResult geometricNonTerminationArgumentResult = new GeometricNonTerminationArgumentResult((IElement)icfgEdge, "LassoRanker", (Map)list.get(0), (Map)list.get(1), list.subList(2, list.size()), geometricNonTerminationArgument.getLambdas(), geometricNonTerminationArgument.getNus(), this.getTranslatorSequence(), Term.class, (IProgramExecution)icfgProgramExecution, (IProgramExecution)icfgProgramExecution2);
        this.reportResult((IResult)geometricNonTerminationArgumentResult);
    }

    private void reportNoResult(RankingTemplate[] rankingTemplateArray) {
        NoResult noResult = new NoResult((IElement)this.mHonda, "LassoRanker", this.getTranslatorSequence());
        noResult.setShortDescription("LassoRanker could not prove termination");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LassoRanker could not prove termination or nontermination of the given linear lasso program.\n");
        stringBuilder.append("Templates:");
        RankingTemplate[] rankingTemplateArray2 = rankingTemplateArray;
        int n = rankingTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            RankingTemplate rankingTemplate = rankingTemplateArray2[n2];
            stringBuilder.append(" ");
            stringBuilder.append(rankingTemplate.getClass().getSimpleName());
            ++n2;
        }
        noResult.setLongDescription(stringBuilder.toString());
        this.mLogger.info((Object)stringBuilder.toString());
        this.reportResult((IResult)noResult);
    }

    private void reportFailBecauseOfOverapproximationResult() {
        NoResult noResult = new NoResult((IElement)this.mHonda, "LassoRanker", this.getTranslatorSequence());
        noResult.setShortDescription("LassoRanker could not prove termination");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LassoRanker could not prove termination or nontermination of the given linear lasso program.\n");
        stringBuilder.append("The reason might be that LassoRanker had to use an overapproximation of the original lasso.");
        noResult.setLongDescription(stringBuilder.toString());
        this.mLogger.info((Object)stringBuilder.toString());
        this.reportResult((IResult)noResult);
    }

    private void reportTimeoutResult(RankingTemplate[] rankingTemplateArray, RankingTemplate rankingTemplate) {
        RankingTemplate rankingTemplate2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LassoRanker could not prove termination or nontermination of the given linear lasso program.\n");
        stringBuilder.append("Templates:");
        RankingTemplate[] rankingTemplateArray2 = rankingTemplateArray;
        int n = rankingTemplateArray.length;
        int n2 = 0;
        while (n2 < n) {
            rankingTemplate2 = rankingTemplateArray2[n2];
            stringBuilder.append(" ");
            stringBuilder.append(rankingTemplate2.getClass().getSimpleName());
            ++n2;
        }
        rankingTemplate2 = new TimeoutResultAtElement((IElement)this.mHonda, "LassoRanker", this.getTranslatorSequence(), stringBuilder.toString());
        this.mLogger.info((Object)stringBuilder.toString());
        this.reportResult((IResult)rankingTemplate2);
    }

    private void reportUnuspportedSyntax(IIcfgElement iIcfgElement, String string) {
        this.mLogger.error((Object)string);
        UnsupportedSyntaxResult unsupportedSyntaxResult = new UnsupportedSyntaxResult((IElement)iIcfgElement, "LassoRanker", this.getTranslatorSequence(), string);
        this.reportResult((IResult)unsupportedSyntaxResult);
    }

    private void reportResult(IResult iResult) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
    }

    private void checkRCFGBuilderSettings() {
        IPreferenceProvider iPreferenceProvider = RcfgPreferenceInitializer.getPreferences((IUltimateServiceProvider)this.mServices);
        boolean bl = iPreferenceProvider.getBoolean("Remove goto edges from RCFG");
        RcfgPreferenceInitializer.CodeBlockSize codeBlockSize = (RcfgPreferenceInitializer.CodeBlockSize)iPreferenceProvider.getEnum("Size of a code block", RcfgPreferenceInitializer.CodeBlockSize.class);
        if (codeBlockSize != RcfgPreferenceInitializer.CodeBlockSize.LoopFreeBlock) {
            throw new UnsupportedOperationException("Unsupported input: Use the large block encoding of the RCFGBuilder");
        }
        if (!bl) {
            throw new UnsupportedOperationException("Unsupported input: Let RCFGBuilder remove goto edges");
        }
    }
}

