/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.Acc;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class AccGenBuchi
implements Acc {
    protected final TIntObjectMap<IntSet> mAccStateMap = new TIntObjectHashMap();
    protected final int mAccSize;

    public AccGenBuchi(int n) {
        this.mAccSize = n;
    }

    public AccGenBuchi(IntSet intSet) {
        this.mAccSize = 1;
        this.mAccStateMap.put(0, (Object)intSet.clone());
    }

    @Override
    public boolean isAccepted(IntSet intSet) {
        IntSet intSet2 = UtilIntSet.newIntSet();
        for (int n : intSet.iterable()) {
            IntSet intSet3 = (IntSet)this.mAccStateMap.get(n);
            if (intSet3 == null) continue;
            intSet2.or(intSet3);
            if (intSet2.cardinality() != this.mAccSize) continue;
            return true;
        }
        return false;
    }

    @Override
    public IntSet getLabels(int n) {
        IntSet intSet = (IntSet)this.mAccStateMap.get(n);
        intSet = intSet == null ? UtilIntSet.newIntSet() : intSet.clone();
        return intSet;
    }

    @Override
    public void setLabel(int n, int n2) {
        assert (this.checkLabelConsistency(n2));
        IntSet intSet = (IntSet)this.mAccStateMap.get(n);
        if (intSet == null) {
            intSet = UtilIntSet.newIntSet();
        }
        intSet.set(n2);
        this.mAccStateMap.put(n, (Object)intSet);
    }

    @Override
    public void setLabel(int n, IntSet intSet) {
        if (intSet == null) {
            return;
        }
        IntSet intSet2 = (IntSet)this.mAccStateMap.get(n);
        if (intSet2 == null) {
            intSet2 = UtilIntSet.newIntSet();
        }
        assert (this.checkLabelConsistency(intSet));
        intSet2.or(intSet);
        this.mAccStateMap.put(n, (Object)intSet2);
    }

    @Override
    public int getAccSize() {
        return this.mAccSize;
    }

    private boolean checkLabelConsistency(IntSet intSet) {
        for (int n : intSet.iterable()) {
            if (this.checkLabelConsistency(n)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLabelConsistency(int n) {
        return n >= 0 && n < this.mAccSize;
    }
}

