/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.DirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.DirectNwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.NwaSimulationUtil;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;

public final class DirectNwaSimulation<LETTER, STATE>
extends DirectSimulation<LETTER, STATE> {
    public DirectNwaSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, DirectNwaGameGraph<LETTER, STATE> directNwaGameGraph) throws AutomataOperationCanceledException {
        super(iProgressAwareTimer, iLogger, bl, iStateFactory, directNwaGameGraph);
    }

    @Override
    public void doSimulation() throws AutomataOperationCanceledException {
        super.doSimulation();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Simulation results (filtered):");
            for (Vertex vertex : this.getGameGraph().getSpoilerVertices()) {
                int n = vertex.getPM(null, this.getGameGraph().getGlobalInfinity());
                if (!(vertex instanceof SpoilerNwaVertex) || n >= this.getGameGraph().getGlobalInfinity() && vertex.getQ0() != vertex.getQ1() || n < this.getGameGraph().getGlobalInfinity() && vertex.getQ0() == vertex.getQ1()) continue;
                String string = Integer.toString(n);
                if (n >= this.getGameGraph().getGlobalInfinity()) {
                    string = "inf";
                }
                this.getLogger().debug((Object)("\t(" + String.valueOf(vertex.getQ0()) + "," + String.valueOf(vertex.getQ1()) + ") = " + string));
            }
        }
    }

    @Override
    protected void retrieveGeneralAutomataPerformance() {
        super.retrieveGeneralAutomataPerformance();
        NwaSimulationUtil.retrieveGeneralNwaAutomataPerformance(this.getSimulationPerformance(), this.getGameGraph().getAutomaton(), this.getResult(), this.getGameGraph().getServices());
    }
}

