/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.DepthFirstTraversal;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.ISleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMap;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMapReduction;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.AcceptingRunSearchVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.ReachabilityCheckVisitor;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class OptimisticBudget<L, S, R>
implements SleepMapReduction.IBudgetFunction<L, R> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final IDfsOrder<L, R> mOrder;
    private final ISleepMapStateFactory<L, S, R> mStateFactory;
    private final Supplier<IDfsVisitor<L, R>> mMakeVisitor;
    private final SleepMapReduction<L, ?, R> mReduction;
    private final Set<R> mSuccessful = new HashSet<R>();
    private final Set<R> mUnsuccessful = new HashSet<R>();

    public OptimisticBudget(AutomataLibraryServices automataLibraryServices, IDfsOrder<L, R> iDfsOrder, ISleepMapStateFactory<L, S, R> iSleepMapStateFactory, Supplier<IDfsVisitor<L, R>> supplier, SleepMapReduction<L, ?, R> sleepMapReduction) {
        this.mServices = automataLibraryServices;
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(OptimisticBudget.class);
        this.mOrder = iDfsOrder;
        this.mStateFactory = iSleepMapStateFactory;
        this.mMakeVisitor = supplier;
        this.mReduction = sleepMapReduction;
    }

    @Override
    public int computeBudget(R r, L l) {
        int n;
        if (this.mReduction == null) {
            throw new UnsupportedOperationException("Optimistic budget cannot be used without setting reduction automaton");
        }
        this.mLogger.debug("Determining budget for %s under input %s", new Object[]{r, l});
        SleepMap<L, S> sleepMap = this.mStateFactory.getSleepMap(r);
        if (sleepMap.contains(l)) {
            n = sleepMap.getPrice(l);
            assert (n <= this.mStateFactory.getBudget(r)) : "invalid state: " + String.valueOf(r);
        } else {
            n = this.mStateFactory.getBudget(r);
        }
        this.mLogger.debug("maximum budget: %d", new Object[]{n});
        int n2 = 0;
        while (n2 < n) {
            this.mLogger.debug("trying with budget %d", new Object[]{n2});
            R r2 = this.mReduction.computeSuccessorWithBudget(r, l, n2);
            if (r2 == null) {
                this.mLogger.debug((Object)"No successor for given letter exists");
                break;
            }
            this.mLogger.debug("running nested DFS from %s under input %s with assumed budget %d", new Object[]{r, l, n2});
            if (this.isSuccessful(r2)) {
                this.mLogger.debug("determined budget %d for %s under input %s", new Object[]{n2, r, l});
                return n2;
            }
            ++n2;
        }
        this.mLogger.debug("determined budget %d (max) for %s under input %s", new Object[]{n, r, l});
        return n;
    }

    private boolean isSuccessful(R r) {
        if (this.mSuccessful.contains(r)) {
            return true;
        }
        if (this.mUnsuccessful.contains(r)) {
            return false;
        }
        boolean bl = this.checkIsSuccessful(r);
        assert (bl && this.mSuccessful.contains(r) || !bl && this.mUnsuccessful.contains(r));
        return bl;
    }

    private boolean checkIsSuccessful(R r) {
        boolean bl;
        ReachabilityCheckVisitor reachabilityCheckVisitor = new ReachabilityCheckVisitor(this.mMakeVisitor.get(), this.mUnsuccessful, this.mSuccessful);
        try {
            new DepthFirstTraversal<L, R>(this.mServices, this.mReduction, this.mOrder, reachabilityCheckVisitor, r);
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw new ToolchainCanceledException(this.getClass());
        }
        NestedRun nestedRun = ((AcceptingRunSearchVisitor)reachabilityCheckVisitor.getBaseVisitor()).getAcceptingRun();
        if (nestedRun != null) {
            this.mUnsuccessful.addAll(nestedRun.getStateSequence());
            return false;
        }
        boolean bl2 = bl = !reachabilityCheckVisitor.reachabilityConfirmed();
        if (bl) {
            this.mSuccessful.add(r);
        } else assert (this.mUnsuccessful.contains(r));
        return bl;
    }
}

