/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.PetriNetVisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import java.util.Map;

public final class EventNode<LETTER, PLACE>
extends PetriNetVisualizationNode {
    private static final long serialVersionUID = -2531826841396458461L;

    public EventNode(Event<LETTER, PLACE> event) {
        super(EventNode.generateNodeLabel(event));
        Transition<LETTER, PLACE> transition = event.getTransition();
        DefaultAnnotations defaultAnnotations = new DefaultAnnotations();
        defaultAnnotations.put("SerialNumber", (Object)event.getSerialNumber());
        defaultAnnotations.put("Ancestors", (Object)event.getAncestors());
        defaultAnnotations.put("Transition", transition);
        defaultAnnotations.put("Companion", event.getCompanion());
        defaultAnnotations.put("ByLocalConfigurationRepresentedMarking", event.getMark());
        defaultAnnotations.put("HashCode", (Object)event.hashCode());
        Map map = this.getPayload().getAnnotations();
        map.put(LibraryIdentifiers.PLUGIN_ID, defaultAnnotations);
        LETTER LETTER = transition.getSymbol();
        if (LETTER instanceof IAnnotations) {
            defaultAnnotations.put("Symbol", LETTER);
        }
    }

    private static <LETTER, PLACE> String generateNodeLabel(Event<LETTER, PLACE> event) {
        return "e" + event.getSerialNumber() + ":" + event.getTransition().getSymbol().toString();
    }
}

