/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.CommonExternalFormatWriter;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public interface IPetriAtsFormatter<LETTER, PLACE> {
    public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> var1);

    public Map<PLACE, String> getPlacesMapping(Collection<PLACE> var1);

    public static class ToString<LETTER, PLACE>
    implements IPetriAtsFormatter<LETTER, PLACE> {
        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
            HashMap<LETTER, String> hashMap = new HashMap<LETTER, String>();
            for (LETTER LETTER : collection) {
                hashMap.put(LETTER, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(LETTER));
            }
            return hashMap;
        }

        @Override
        public Map<PLACE, String> getPlacesMapping(Collection<PLACE> collection) {
            HashMap<PLACE, String> hashMap = new HashMap<PLACE, String>();
            for (PLACE PLACE : collection) {
                hashMap.put(PLACE, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(PLACE));
            }
            return hashMap;
        }
    }

    public static class ToStringWithUniqueNumber<LETTER, PLACE>
    implements IPetriAtsFormatter<LETTER, PLACE> {
        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
            int n = 0;
            HashMap<LETTER, String> hashMap = new HashMap<LETTER, String>();
            for (LETTER LETTER : collection) {
                hashMap.put(LETTER, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(LETTER, Integer.toString(n)));
                ++n;
            }
            return hashMap;
        }

        @Override
        public Map<PLACE, String> getPlacesMapping(Collection<PLACE> collection) {
            int n = 0;
            HashMap<PLACE, String> hashMap = new HashMap<PLACE, String>();
            for (PLACE PLACE : collection) {
                hashMap.put(PLACE, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(PLACE, Integer.toString(n)));
                ++n;
            }
            return hashMap;
        }
    }

    public static class UniqueId<LETTER, PLACE>
    implements IPetriAtsFormatter<LETTER, PLACE> {
        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
            return CommonExternalFormatWriter.constructAlphabetMapping(collection, 'a');
        }

        @Override
        public Map<PLACE, String> getPlacesMapping(Collection<PLACE> collection) {
            int n = 0;
            HashMap<PLACE, CallSite> hashMap = new HashMap<PLACE, CallSite>();
            for (PLACE PLACE : collection) {
                hashMap.put(PLACE, (CallSite)((Object)("p" + Integer.toString(n))));
                ++n;
            }
            return hashMap;
        }
    }
}

