/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class BuildStoreInfos
extends NonRecursive {
    private final EdgeInfo mEdge;
    private final Map<Term, ArrayGroup> mTermToArrayGroup;
    private final ManagedScript mMgdScript;
    private final Map<SubtreePosition, StoreInfo> mCollectedStoreInfos = new HashMap<SubtreePosition, StoreInfo>();
    private final MemlocArrayManager mLocArrayManager;
    private int mSiidCtr;
    private final Map<SubtreePosition, ArrayEqualityLocUpdateInfo> mPositionToLocArrayUpdateInfos = new HashMap<SubtreePosition, ArrayEqualityLocUpdateInfo>();
    private final Map<HeapSepProgramConst, StoreInfo> mLocLitToStoreInfo = new HashMap<HeapSepProgramConst, StoreInfo>();
    private final Set<IProgramVar> mDefinitelyUnconstrainedVariables;

    BuildStoreInfos(EdgeInfo edgeInfo, Map<Term, ArrayGroup> map, ManagedScript managedScript, MemlocArrayManager memlocArrayManager, int n, Set<IProgramVar> set) {
        this.mEdge = edgeInfo;
        this.mTermToArrayGroup = map;
        this.mMgdScript = managedScript;
        this.mLocArrayManager = memlocArrayManager;
        this.mSiidCtr = n;
        this.mDefinitelyUnconstrainedVariables = set;
    }

    public Map<HeapSepProgramConst, StoreInfo> getLocLitToStoreInfo() {
        return this.mLocLitToStoreInfo;
    }

    public Map<SubtreePosition, ArrayEqualityLocUpdateInfo> getLocArrayUpdateInfos() {
        return this.mPositionToLocArrayUpdateInfos;
    }

    public void buildStoreInfos() {
        this.run((NonRecursive.Walker)new BuildStoreInfoWalker(this.mEdge.getEdge().getTransformula().getFormula(), new SubtreePosition(), new ArrayIndex(), null, null));
    }

    public Map<SubtreePosition, ArrayEqualityLocUpdateInfo> getPositionToLocArrayUpdateInfos() {
        return this.mPositionToLocArrayUpdateInfos;
    }

    public int getStoreInfoCounter() {
        return this.mSiidCtr;
    }

    private int getNextStoreInfoId() {
        ++this.mSiidCtr;
        return this.mSiidCtr;
    }

    private HeapSepProgramConst constructLocationLiteral(EdgeInfo edgeInfo, int n, int n2) {
        assert (n > 0) : "use a long if this may overflow";
        this.mMgdScript.lock((Object)this);
        String string = this.getLocationLitName(edgeInfo, n);
        Sort sort = this.mLocArrayManager.getMemlocSort(n2);
        this.mMgdScript.declareFun((Object)this, string, new Sort[0], sort);
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mMgdScript.term((Object)this, string, new Term[0]);
        this.mMgdScript.unlock((Object)this);
        return new HeapSepProgramConst(applicationTerm);
    }

    private String getLocationLitName(EdgeInfo edgeInfo, int n) {
        return "lit_" + String.valueOf(edgeInfo.getSourceLocation()) + "_" + n;
    }

    private class BuildStoreInfoWalker
    extends NonRecursive.TermWalker {
        private final ArrayIndex mEnclosingStoreIndices;
        private final SubtreePosition mSubTreePosition;
        private final SubtreePosition mRelativePosition;
        private final ArrayEqualityLocUpdateInfo mEnclosingEquality;

        public BuildStoreInfoWalker(Term term, SubtreePosition subtreePosition, ArrayIndex arrayIndex, ArrayEqualityLocUpdateInfo arrayEqualityLocUpdateInfo, SubtreePosition subtreePosition2) {
            super(term);
            this.mEnclosingStoreIndices = arrayIndex;
            this.mSubTreePosition = subtreePosition;
            this.mEnclosingEquality = arrayEqualityLocUpdateInfo;
            this.mRelativePosition = subtreePosition2;
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(annotatedTerm.getSubterm(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            String string;
            switch (string = applicationTerm.getFunction().getName()) {
                case "store": {
                    ArrayGroup arrayGroup = BuildStoreInfos.this.mTermToArrayGroup.get(SmtUtils.getBasicArrayTerm((Term)applicationTerm));
                    if (arrayGroup == null) break;
                    int n = BuildStoreInfos.this.getNextStoreInfoId();
                    int n2 = this.mEnclosingStoreIndices.size() + 1;
                    HeapSepProgramConst heapSepProgramConst = BuildStoreInfos.this.constructLocationLiteral(BuildStoreInfos.this.mEdge, n, n2);
                    StoreInfo storeInfo = StoreInfo.buildStoreInfo(n, BuildStoreInfos.this.mEdge, this.mSubTreePosition, applicationTerm, arrayGroup, this.mEnclosingStoreIndices, (IProgramConst)heapSepProgramConst, this.mEnclosingEquality, this.mRelativePosition);
                    BuildStoreInfos.this.mLocLitToStoreInfo.put(heapSepProgramConst, storeInfo);
                    BuildStoreInfos.this.mCollectedStoreInfos.put(this.mSubTreePosition, storeInfo);
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(applicationTerm.getParameters()[0], this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
                    arrayGroup = this.mEnclosingStoreIndices.append(applicationTerm.getParameters()[1]);
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(applicationTerm.getParameters()[2], this.mSubTreePosition.append(2), (ArrayIndex)arrayGroup, this.mEnclosingEquality, this.mRelativePosition.append(2)));
                    break;
                }
                case "=": {
                    if (!applicationTerm.getParameters()[0].getSort().isArraySort()) break;
                    assert (this.mEnclosingEquality == null);
                    ArrayEqualityLocUpdateInfo arrayEqualityLocUpdateInfo = new ArrayEqualityLocUpdateInfo(BuildStoreInfos.this.mMgdScript, applicationTerm, BuildStoreInfos.this.mEdge, BuildStoreInfos.this.mLocArrayManager, BuildStoreInfos.this.mDefinitelyUnconstrainedVariables);
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(applicationTerm.getParameters()[0], this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, arrayEqualityLocUpdateInfo, new SubtreePosition().append(0)));
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(applicationTerm.getParameters()[1], this.mSubTreePosition.append(1), this.mEnclosingStoreIndices, arrayEqualityLocUpdateInfo, new SubtreePosition().append(1)));
                    BuildStoreInfos.this.mPositionToLocArrayUpdateInfos.put(this.mSubTreePosition, arrayEqualityLocUpdateInfo);
                    break;
                }
                default: {
                    if (!"Bool".equals(applicationTerm.getSort().getName()) || !SmtUtils.allParamsAreBool((ApplicationTerm)applicationTerm)) break;
                    assert (this.mEnclosingEquality == null);
                    int n = 0;
                    while (n < applicationTerm.getParameters().length) {
                        Term term = applicationTerm.getParameters()[n];
                        nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term, this.mSubTreePosition.append(n), this.mEnclosingStoreIndices, null, null));
                        ++n;
                    }
                    break block4;
                }
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(letTerm.getSubTerm(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            assert (this.mEnclosingEquality == null);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(quantifiedFormula.getSubformula(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, null, null));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

