/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class StoreLocationBlock {
    private final ArrayGroup mArrayGroup;
    private final int mDimension;
    private final Set<StoreInfo> mStoreInfos;

    public StoreLocationBlock(Set<StoreInfo> set, ArrayGroup arrayGroup, int n) {
        this.mStoreInfos = Collections.unmodifiableSet(set);
        this.mArrayGroup = arrayGroup;
        this.mDimension = n;
    }

    public boolean contains(StoreInfo storeInfo) {
        return this.mStoreInfos.contains(storeInfo);
    }

    public String toString() {
        return "locs_" + this.mStoreInfos.hashCode() % 100;
    }

    public Set<StoreInfo> getLocations() {
        return this.mStoreInfos;
    }

    public ArrayGroup getArrayGroup() {
        return this.mArrayGroup;
    }

    public int getDimension() {
        return this.mDimension;
    }

    public int hashCode() {
        return Objects.hash(this.mArrayGroup, this.mDimension, this.mStoreInfos);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StoreLocationBlock storeLocationBlock = (StoreLocationBlock)object;
        if (this.mArrayGroup == null ? storeLocationBlock.mArrayGroup != null : !this.mArrayGroup.equals(storeLocationBlock.mArrayGroup)) {
            return false;
        }
        if (this.mDimension != storeLocationBlock.mDimension) {
            return false;
        }
        return !(this.mStoreInfos == null ? storeLocationBlock.mStoreInfos != null : !this.mStoreInfos.equals(storeLocationBlock.mStoreInfos));
    }
}

