/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;

public class ParametricOctValue {
    private final BigDecimal mCoefficient;
    private final BigDecimal mSummand;
    private final TermVariable mVar;
    private final BigDecimal mIncrement;

    ParametricOctValue() {
        this.mCoefficient = new BigDecimal("0");
        this.mSummand = new BigDecimal("0");
        this.mVar = null;
        this.mIncrement = null;
    }

    ParametricOctValue(BigDecimal bigDecimal, BigDecimal bigDecimal2, TermVariable termVariable) {
        this(bigDecimal, bigDecimal2, termVariable, BigDecimal.ZERO);
    }

    ParametricOctValue(BigDecimal bigDecimal, BigDecimal bigDecimal2, TermVariable termVariable, BigDecimal bigDecimal3) {
        this.mCoefficient = bigDecimal;
        this.mSummand = bigDecimal2;
        this.mVar = termVariable;
        this.mIncrement = bigDecimal3;
    }

    BigDecimal getCoefficient() {
        return this.mCoefficient;
    }

    BigDecimal getSummand() {
        return this.mSummand;
    }

    TermVariable getVariable() {
        return this.mVar;
    }

    BigDecimal getIncrement() {
        return this.mIncrement;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.mCoefficient.toString() + " * ");
        if (this.mIncrement.equals(BigDecimal.ZERO)) {
            stringBuilder.append(this.mVar.toString());
        } else {
            stringBuilder.append("(" + this.mVar.toString() + "+" + this.mIncrement.toString() + ")");
        }
        stringBuilder.append(" + " + this.mSummand.toString());
        return stringBuilder.toString();
    }

    public ParametricOctValue add(ParametricOctValue parametricOctValue) {
        return new ParametricOctValue(this.mCoefficient.add(parametricOctValue.getCoefficient()), this.mSummand.add(parametricOctValue.getSummand()), this.mVar, this.mIncrement);
    }

    public ParametricOctValue add(BigDecimal bigDecimal) {
        return new ParametricOctValue(this.mCoefficient, this.mSummand.add(bigDecimal), this.mVar, this.mIncrement);
    }

    public ParametricOctValue multipy(BigDecimal bigDecimal) {
        return new ParametricOctValue(this.mCoefficient.multiply(bigDecimal), this.mSummand.multiply(bigDecimal), this.mVar, this.mIncrement);
    }

    public Object add(Object object) {
        if (object instanceof ParametricOctValue) {
            return this.add((ParametricOctValue)object);
        }
        return this.add((BigDecimal)object);
    }

    public Term getTerm(Script script) {
        TermVariable termVariable = this.mIncrement.equals(BigDecimal.ZERO) ? this.mVar : script.term("+", new Term[]{this.mVar, script.decimal(this.mIncrement)});
        Term term = this.mCoefficient.equals(BigDecimal.ZERO) ? script.decimal(BigDecimal.ZERO) : script.term("*", new Term[]{script.decimal(this.mCoefficient), termVariable});
        return this.mSummand.equals(BigDecimal.ZERO) ? term : script.term("+", new Term[]{term, script.decimal(this.mSummand)});
    }
}

