/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.emptinesscheck;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.DummyStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppHyperEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.EmptyStackSymbol;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.emptinesscheck.IEmptinessCheck;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NWAEmptinessCheck
implements IEmptinessCheck {
    private final IUltimateServiceProvider mServices;

    public NWAEmptinessCheck(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    @Override
    public NestedRun<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> checkForEmptiness(AnnotatedProgramPoint annotatedProgramPoint) {
        MyNWA myNWA = new MyNWA(annotatedProgramPoint);
        try {
            return new IsEmpty(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)new RemoveUnreachable(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)myNWA).getResult()).getNestedRun();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw new ToolchainCanceledException((IRunningTaskStackProvider)automataOperationCanceledException, new RunningTaskInfo(NWAEmptinessCheck.class, "checking for new error trace"));
        }
    }

    private static final class MyNWA
    implements INwaOutgoingLetterAndTransitionProvider<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> {
        private final Set<IIcfgTransition<IcfgLocation>> mAlphabet = new HashSet<IIcfgTransition<IcfgLocation>>();
        private final Set<IIcfgTransition<IcfgLocation>> mInternalAlphabet = new HashSet<IIcfgTransition<IcfgLocation>>();
        private final Set<IIcfgTransition<IcfgLocation>> mCallAlphabet = new HashSet<IIcfgTransition<IcfgLocation>>();
        private final Set<IIcfgTransition<IcfgLocation>> mReturnAlphabet = new HashSet<IIcfgTransition<IcfgLocation>>();
        private final VpAlphabet<IIcfgTransition<IcfgLocation>> mVpAlphabet = new VpAlphabet(this.mInternalAlphabet, this.mCallAlphabet, this.mReturnAlphabet);
        private final IStateFactory<AnnotatedProgramPoint> mStateFactory = new DummyStateFactory();
        private final Map<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>> mStateToLettersInternal = new HashMap<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>>();
        private final Map<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>> mStateToLettersCall = new HashMap<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>>();
        private final Map<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>> mStateToLettersReturn = new HashMap<AnnotatedProgramPoint, Set<IIcfgTransition<IcfgLocation>>>();
        private final Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>> mStateToLetterToOutgoingInternalTransitions = new HashMap<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>>();
        private final Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>> mStateToLetterToOutgoingCallTransitions = new HashMap<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>>();
        private final Map<AnnotatedProgramPoint, Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>>> mStateToHierToLetterToOutgoingReturnTransitions = new HashMap<AnnotatedProgramPoint, Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>>>();
        private final AnnotatedProgramPoint mEmptyStackSymbol = new EmptyStackSymbol();
        private final List<AnnotatedProgramPoint> mInitialStates;
        private int mSize = 0;

        public MyNWA(AnnotatedProgramPoint annotatedProgramPoint) {
            this.mInitialStates = Collections.singletonList(annotatedProgramPoint);
            this.exploreGraph(annotatedProgramPoint);
        }

        void exploreGraph(AnnotatedProgramPoint annotatedProgramPoint) {
            HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
            ArrayDeque<AnnotatedProgramPoint> arrayDeque = new ArrayDeque<AnnotatedProgramPoint>();
            arrayDeque.add(annotatedProgramPoint);
            while (!arrayDeque.isEmpty()) {
                AnnotatedProgramPoint annotatedProgramPoint2 = (AnnotatedProgramPoint)((Object)arrayDeque.pollFirst());
                assert (!hashSet.contains((Object)annotatedProgramPoint2));
                hashSet.add(annotatedProgramPoint2);
                assert (hashSet.contains((Object)annotatedProgramPoint2));
                for (AppEdge appEdge : annotatedProgramPoint2.getOutgoingEdges()) {
                    AnnotatedProgramPoint annotatedProgramPoint3 = (AnnotatedProgramPoint)appEdge.getTarget();
                    IIcfgTransition<IcfgLocation> iIcfgTransition = appEdge.getStatement();
                    if (!hashSet.contains((Object)annotatedProgramPoint3) && !arrayDeque.contains((Object)annotatedProgramPoint3)) {
                        arrayDeque.add(annotatedProgramPoint3);
                    }
                    ++this.mSize;
                    if (iIcfgTransition instanceof IIcfgCallTransition) {
                        this.mCallAlphabet.add(iIcfgTransition);
                        if (this.mStateToLettersCall.get((Object)annotatedProgramPoint2) == null) {
                            this.mStateToLettersCall.put(annotatedProgramPoint2, new HashSet());
                        }
                        this.mStateToLettersCall.get((Object)annotatedProgramPoint2).add(iIcfgTransition);
                        if (this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint2) == null) {
                            this.mStateToLetterToOutgoingCallTransitions.put(annotatedProgramPoint2, new HashMap());
                        }
                        if (this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint2).get(iIcfgTransition) == null) {
                            this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint2).put(iIcfgTransition, new ArrayList());
                        }
                        this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint2).get(iIcfgTransition).add((OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>)new OutgoingCallTransition(iIcfgTransition, (Object)annotatedProgramPoint3));
                        continue;
                    }
                    if (iIcfgTransition instanceof IIcfgReturnTransition) {
                        this.mReturnAlphabet.add(iIcfgTransition);
                        if (this.mStateToLettersReturn.get((Object)annotatedProgramPoint2) == null) {
                            this.mStateToLettersReturn.put(annotatedProgramPoint2, new HashSet());
                        }
                        this.mStateToLettersReturn.get((Object)annotatedProgramPoint2).add(iIcfgTransition);
                        AppHyperEdge appHyperEdge = (AppHyperEdge)appEdge;
                        AnnotatedProgramPoint annotatedProgramPoint4 = appHyperEdge.getHier();
                        assert (annotatedProgramPoint4 != null);
                        if (this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2) == null) {
                            this.mStateToHierToLetterToOutgoingReturnTransitions.put(annotatedProgramPoint2, new HashMap());
                        }
                        if (this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2).get((Object)annotatedProgramPoint4) == null) {
                            this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2).put(annotatedProgramPoint4, new HashMap());
                        }
                        if (this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2).get((Object)annotatedProgramPoint4).get(iIcfgTransition) == null) {
                            this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2).get((Object)annotatedProgramPoint4).put(iIcfgTransition, new ArrayList());
                        }
                        assert (this.isOutReturnTransitionNotContained(annotatedProgramPoint2, annotatedProgramPoint4, iIcfgTransition, annotatedProgramPoint3));
                        this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint2).get((Object)annotatedProgramPoint4).get(iIcfgTransition).add((OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>)new OutgoingReturnTransition((Object)annotatedProgramPoint4, iIcfgTransition, (Object)annotatedProgramPoint3));
                        continue;
                    }
                    this.mInternalAlphabet.add(iIcfgTransition);
                    if (this.mStateToLettersInternal.get((Object)annotatedProgramPoint2) == null) {
                        this.mStateToLettersInternal.put(annotatedProgramPoint2, new HashSet());
                    }
                    this.mStateToLettersInternal.get((Object)annotatedProgramPoint2).add(iIcfgTransition);
                    if (this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint2) == null) {
                        this.mStateToLetterToOutgoingInternalTransitions.put(annotatedProgramPoint2, new HashMap());
                    }
                    if (this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint2).get(iIcfgTransition) == null) {
                        this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint2).put(iIcfgTransition, new ArrayList());
                    }
                    this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint2).get(iIcfgTransition).add((OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>)new OutgoingInternalTransition(iIcfgTransition, (Object)annotatedProgramPoint3));
                }
            }
            this.mAlphabet.addAll(this.mCallAlphabet);
            this.mAlphabet.addAll(this.mReturnAlphabet);
            this.mAlphabet.addAll(this.mInternalAlphabet);
        }

        private boolean isOutReturnTransitionNotContained(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2, IIcfgTransition<IcfgLocation> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint3) {
            boolean bl = true;
            for (OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint> outgoingReturnTransition : this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint).get((Object)annotatedProgramPoint2).get(iIcfgTransition)) {
                bl &= outgoingReturnTransition.getHierPred() != annotatedProgramPoint2 || outgoingReturnTransition.getLetter() != iIcfgTransition || outgoingReturnTransition.getSucc() != annotatedProgramPoint3;
            }
            return bl;
        }

        public int size() {
            return this.mSize;
        }

        public Set<IIcfgTransition<IcfgLocation>> getAlphabet() {
            return this.mAlphabet;
        }

        public String sizeInformation() {
            return "no size info available";
        }

        public VpAlphabet<IIcfgTransition<IcfgLocation>> getVpAlphabet() {
            return this.mVpAlphabet;
        }

        public IStateFactory<AnnotatedProgramPoint> getStateFactory() {
            return this.mStateFactory;
        }

        public AnnotatedProgramPoint getEmptyStackState() {
            return this.mEmptyStackSymbol;
        }

        public Iterable<AnnotatedProgramPoint> getInitialStates() {
            return this.mInitialStates;
        }

        public boolean isInitial(AnnotatedProgramPoint annotatedProgramPoint) {
            return this.mInitialStates.contains((Object)annotatedProgramPoint);
        }

        public boolean isFinal(AnnotatedProgramPoint annotatedProgramPoint) {
            return annotatedProgramPoint.isErrorLocation();
        }

        public Set<IIcfgTransition<IcfgLocation>> lettersInternal(AnnotatedProgramPoint annotatedProgramPoint) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptySet();
            }
            return map.keySet();
        }

        public Set<IIcfgTransition<IcfgLocation>> lettersCall(AnnotatedProgramPoint annotatedProgramPoint) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptySet();
            }
            return this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint).keySet();
        }

        public Set<IIcfgTransition<IcfgLocation>> lettersReturn(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2) {
            Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>> map = this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptySet();
            }
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map2 = map.get(map);
            return map2.keySet();
        }

        public Iterable<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> internalSuccessors(AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<IcfgLocation> iIcfgTransition) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            return map.get(iIcfgTransition);
        }

        public Iterable<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> internalSuccessors(AnnotatedProgramPoint annotatedProgramPoint) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingInternalTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            ArrayList<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> arrayList = new ArrayList<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>();
            for (List<OutgoingInternalTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> list : map.values()) {
                arrayList.addAll(list);
            }
            return arrayList;
        }

        public Iterable<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> callSuccessors(AnnotatedProgramPoint annotatedProgramPoint, IIcfgTransition<IcfgLocation> iIcfgTransition) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            return this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint).get(iIcfgTransition);
        }

        public Iterable<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> callSuccessors(AnnotatedProgramPoint annotatedProgramPoint) {
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map = this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            ArrayList<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> arrayList = new ArrayList<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>();
            for (List<OutgoingCallTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> list : this.mStateToLetterToOutgoingCallTransitions.get((Object)annotatedProgramPoint).values()) {
                arrayList.addAll(list);
            }
            return arrayList;
        }

        public Iterable<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> returnSuccessors(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2, IIcfgTransition<IcfgLocation> iIcfgTransition) {
            Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>> map = this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map2 = this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint).get((Object)annotatedProgramPoint2);
            if (map2 == null) {
                return Collections.emptyList();
            }
            return this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint).get((Object)annotatedProgramPoint2).get(iIcfgTransition);
        }

        public Iterable<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> returnSuccessorsGivenHier(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2) {
            Map<AnnotatedProgramPoint, Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>>> map = this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint);
            if (map == null) {
                return Collections.emptyList();
            }
            Map<IIcfgTransition<IcfgLocation>, List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>> map2 = this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint).get((Object)annotatedProgramPoint2);
            if (map2 == null) {
                return Collections.emptyList();
            }
            ArrayList<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> arrayList = new ArrayList<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>>();
            for (List<OutgoingReturnTransition<IIcfgTransition<IcfgLocation>, AnnotatedProgramPoint>> list : this.mStateToHierToLetterToOutgoingReturnTransitions.get((Object)annotatedProgramPoint).get((Object)annotatedProgramPoint2).values()) {
                arrayList.addAll(list);
            }
            return arrayList;
        }

        public IElement transformToUltimateModel(AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException {
            return null;
        }
    }
}

