/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationResultReporter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.LinkedScopedHashMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTSimpleDeclaration;

public class DetermineNecessaryDeclarations
extends ASTVisitor {
    private final LinkedScopedHashMap<String, IASTDeclaration> mLocalSymbolTable;
    private final Map<String, IASTNode> mFunctionTable;
    private final Stack<IASTDeclaration> mCurrentDeclarationStack;
    private final Map<IASTDeclaration, LinkedHashSet<IASTDeclaration>> mDependencyGraph;
    private final Map<String, IASTDeclaration> mDependencyGraphPreliminaryInverse;
    private final LinkedHashSet<IASTDeclaration> mReachableDeclarations;
    private final String mEntryFunction;
    private IASTTranslationUnit mTranslationUnit;
    private final Set<String> mFunctions;
    private final CTranslationResultReporter mReporter;

    public DetermineNecessaryDeclarations(String string, CTranslationResultReporter cTranslationResultReporter, Map<String, IASTNode> map, Set<String> set) {
        this.mReporter = cTranslationResultReporter;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitStatements = true;
        this.shouldVisitEnumerators = true;
        this.mLocalSymbolTable = new LinkedScopedHashMap();
        this.mFunctionTable = map;
        this.mDependencyGraph = new LinkedHashMap<IASTDeclaration, LinkedHashSet<IASTDeclaration>>();
        this.mDependencyGraphPreliminaryInverse = new LinkedHashMap<String, IASTDeclaration>();
        this.mReachableDeclarations = new LinkedHashSet();
        this.mCurrentDeclarationStack = new Stack();
        this.mEntryFunction = string;
        this.mFunctions = set;
    }

    public int visit(IASTDeclSpecifier iASTDeclSpecifier) {
        if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.mLocalSymbolTable.beginScope();
        }
        return super.visit(iASTDeclSpecifier);
    }

    public int leave(IASTDeclSpecifier iASTDeclSpecifier) {
        if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.mLocalSymbolTable.endScope();
        }
        return super.leave(iASTDeclSpecifier);
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator iASTEnumerator) {
        this.mLocalSymbolTable.put((Object)iASTEnumerator.getName().toString(), (Object)((IASTDeclaration)iASTEnumerator.getParent().getParent()));
        return super.visit(iASTEnumerator);
    }

    public int visit(IASTParameterDeclaration iASTParameterDeclaration) {
        IASTParameterDeclaration iASTParameterDeclaration2;
        IASTDeclSpecifier iASTDeclSpecifier = iASTParameterDeclaration.getDeclSpecifier();
        IASTDeclaration iASTDeclaration = null;
        if (!this.mCurrentDeclarationStack.isEmpty()) {
            iASTDeclaration = this.mCurrentDeclarationStack.peek();
        } else {
            iASTParameterDeclaration2 = iASTParameterDeclaration;
            while (!(iASTParameterDeclaration2 instanceof IASTSimpleDeclaration)) {
                iASTParameterDeclaration2 = iASTParameterDeclaration2.getParent();
            }
            iASTDeclaration = (IASTDeclaration)iASTParameterDeclaration2;
        }
        if (iASTDeclSpecifier instanceof IASTElaboratedTypeSpecifier) {
            iASTParameterDeclaration2 = (IASTElaboratedTypeSpecifier)iASTDeclSpecifier;
            String string = DetermineNecessaryDeclarations.getKindStringFromCompositeOrElaboratedTS((IASTDeclSpecifier)iASTParameterDeclaration2) + iASTParameterDeclaration2.getName().toString();
            IASTDeclaration iASTDeclaration2 = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
            if (iASTDeclaration2 != null) {
                this.addDependency(iASTDeclaration, iASTDeclaration2);
            }
        } else if (iASTDeclSpecifier instanceof IASTNamedTypeSpecifier) {
            iASTParameterDeclaration2 = (IASTNamedTypeSpecifier)iASTDeclSpecifier;
            String string = iASTParameterDeclaration2.getName().toString();
            IASTDeclaration iASTDeclaration3 = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
            if (iASTDeclaration3 != null) {
                this.addDependency(iASTDeclaration, iASTDeclaration3);
            }
        } else if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) assert (false) : "a parameter type with composite type specifier: this seems to be an exotic case..";
        return super.visit(iASTParameterDeclaration);
    }

    public int visit(IASTTypeId iASTTypeId) {
        IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier;
        Object object = "";
        if (iASTTypeId.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
            object = ((IASTNamedTypeSpecifier)iASTTypeId.getDeclSpecifier()).getName().toString();
        } else if (iASTTypeId.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
            iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTTypeId.getDeclSpecifier();
            object = DetermineNecessaryDeclarations.getKindStringFromCompositeOrElaboratedTS((IASTDeclSpecifier)iASTElaboratedTypeSpecifier) + iASTElaboratedTypeSpecifier.getName().toString();
        }
        if (((String)object).isEmpty()) {
            return super.visit(iASTTypeId);
        }
        iASTElaboratedTypeSpecifier = (IASTDeclaration)this.mLocalSymbolTable.get(object);
        if (iASTElaboratedTypeSpecifier != null) {
            this.addDependency(this.mCurrentDeclarationStack.peek(), (IASTDeclaration)iASTElaboratedTypeSpecifier);
        } else {
            this.mDependencyGraphPreliminaryInverse.put((String)object, this.mCurrentDeclarationStack.peek());
        }
        return super.visit(iASTTypeId);
    }

    public int visit(IASTExpression iASTExpression) {
        if (iASTExpression instanceof IASTIdExpression) {
            return this.visit((IASTIdExpression)iASTExpression);
        }
        if (iASTExpression instanceof IASTFunctionCallExpression) {
            return this.visit((IASTFunctionCallExpression)iASTExpression);
        }
        return super.visit(iASTExpression);
    }

    public int visit(IASTIdExpression iASTIdExpression) {
        String string = iASTIdExpression.getName().toString();
        IASTDeclaration iASTDeclaration = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
        IASTNode iASTNode = this.mFunctionTable.get(string);
        if (iASTDeclaration != null) {
            this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration);
        } else if (iASTNode != null) {
            this.addDependency(this.mCurrentDeclarationStack.peek(), DetermineNecessaryDeclarations.getDeclarationFromFuncDefinitionOrFuncDeclarator(iASTNode));
        } else {
            this.mDependencyGraphPreliminaryInverse.put(string, this.mCurrentDeclarationStack.peek());
        }
        return super.visit((IASTExpression)iASTIdExpression);
    }

    public int visit(IASTFunctionCallExpression iASTFunctionCallExpression) {
        IASTExpression iASTExpression = iASTFunctionCallExpression.getFunctionNameExpression();
        if (iASTExpression instanceof IASTIdExpression) {
            IASTDeclaration iASTDeclaration;
            IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpression;
            IASTDeclaration iASTDeclaration2 = DetermineNecessaryDeclarations.getDeclarationFromFuncDefinitionOrFuncDeclarator(this.mFunctionTable.get(iASTIdExpression.getName().toString()));
            if (iASTDeclaration2 != null) {
                this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration2);
            }
            if ((iASTDeclaration = (IASTDeclaration)this.mLocalSymbolTable.get((Object)iASTIdExpression.getName().toString())) != null) {
                this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration);
            }
            if (iASTDeclaration == null || iASTDeclaration2 == null) {
                this.mDependencyGraphPreliminaryInverse.put(iASTIdExpression.getName().toString(), this.mCurrentDeclarationStack.peek());
            }
        } else {
            for (String string : this.mFunctions) {
                this.addDependency(this.mCurrentDeclarationStack.peek(), DetermineNecessaryDeclarations.getDeclarationFromFuncDefinitionOrFuncDeclarator(this.mFunctionTable.get(string)));
            }
        }
        return super.visit((IASTExpression)iASTFunctionCallExpression);
    }

    private static IASTDeclaration getDeclarationFromFuncDefinitionOrFuncDeclarator(IASTNode iASTNode) {
        if (iASTNode == null) {
            return null;
        }
        if (iASTNode instanceof IASTFunctionDefinition) {
            return (IASTDeclaration)iASTNode;
        }
        if (iASTNode instanceof IASTFunctionDeclarator) {
            IASTNode iASTNode2 = iASTNode.getParent();
            while (!(iASTNode2 instanceof IASTDeclaration)) {
                iASTNode2 = iASTNode2.getParent();
            }
            return (IASTDeclaration)iASTNode2;
        }
        assert (false) : "should not happen";
        return null;
    }

    public int visit(IASTDeclaration iASTDeclaration) {
        if (iASTDeclaration instanceof CASTSimpleDeclaration) {
            Object object;
            boolean bl = iASTDeclaration.getParent() instanceof IASTTranslationUnit;
            CASTSimpleDeclaration cASTSimpleDeclaration = (CASTSimpleDeclaration)iASTDeclaration;
            IASTDeclSpecifier iASTDeclSpecifier = cASTSimpleDeclaration.getDeclSpecifier();
            if (bl) {
                Object object2;
                if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
                    object = (IASTCompositeTypeSpecifier)iASTDeclSpecifier;
                    object2 = object.getName().toString();
                    if (!((String)object2).isEmpty()) {
                        String string = DetermineNecessaryDeclarations.getKindStringFromCompositeOrElaboratedTS((IASTDeclSpecifier)object);
                        object2 = string + (String)object2;
                        this.mLocalSymbolTable.put(object2, (Object)iASTDeclaration);
                    }
                    this.addIfNecessaryPrelimInverseDependency(iASTDeclaration, (String)object2);
                } else if (iASTDeclSpecifier instanceof IASTEnumerationSpecifier && !((String)(object2 = (object = (IASTEnumerationSpecifier)iASTDeclSpecifier).getName().toString())).isEmpty()) {
                    this.mLocalSymbolTable.put((Object)("enum " + (String)object2), (Object)iASTDeclaration);
                }
                IASTDeclarator[] iASTDeclaratorArray = cASTSimpleDeclaration.getDeclarators();
                int n = iASTDeclaratorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = iASTDeclaratorArray[n2];
                    IASTDeclarator iASTDeclarator = DetermineNecessaryDeclarations.getInnermostFromNestedDeclarators((IASTDeclarator)object);
                    String string = iASTDeclarator.getName().toString();
                    this.mLocalSymbolTable.put((Object)string, (Object)iASTDeclaration);
                    this.addIfNecessaryPrelimInverseDependency(iASTDeclaration, string);
                    ++n2;
                }
            } else if (iASTDeclSpecifier instanceof IASTElaboratedTypeSpecifier) {
                object = (IASTElaboratedTypeSpecifier)iASTDeclSpecifier;
                String string = DetermineNecessaryDeclarations.getKindStringFromCompositeOrElaboratedTS((IASTDeclSpecifier)object) + object.getName().toString();
                IASTDeclaration iASTDeclaration2 = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
                if (iASTDeclaration2 != null) {
                    this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration2);
                } else {
                    this.mDependencyGraphPreliminaryInverse.put(string, this.mCurrentDeclarationStack.peek());
                }
            } else if (iASTDeclSpecifier instanceof IASTNamedTypeSpecifier) {
                object = (IASTNamedTypeSpecifier)iASTDeclSpecifier;
                String string = object.getName().toString();
                IASTDeclaration iASTDeclaration3 = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
                if (iASTDeclaration3 != null) {
                    this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration3);
                } else {
                    this.mDependencyGraphPreliminaryInverse.put(string, this.mCurrentDeclarationStack.peek());
                }
            } else {
                this.addDependency(this.mCurrentDeclarationStack.peek(), iASTDeclaration);
            }
            object = "";
            if (!(iASTDeclSpecifier instanceof IASTSimpleDeclSpecifier)) {
                if (iASTDeclSpecifier instanceof IASTElaboratedTypeSpecifier) {
                    IASTElaboratedTypeSpecifier iASTElaboratedTypeSpecifier = (IASTElaboratedTypeSpecifier)iASTDeclSpecifier;
                    object = DetermineNecessaryDeclarations.getKindStringFromCompositeOrElaboratedTS((IASTDeclSpecifier)iASTElaboratedTypeSpecifier) + iASTElaboratedTypeSpecifier.getName().toString();
                    IASTDeclaration iASTDeclaration4 = (IASTDeclaration)this.mLocalSymbolTable.get(object);
                    if (iASTDeclaration4 != null) {
                        this.addDependency(iASTDeclaration, (IASTDeclaration)this.mLocalSymbolTable.get(object));
                    } else if (bl) {
                        this.mDependencyGraphPreliminaryInverse.put((String)object, iASTDeclaration);
                    }
                } else if (iASTDeclSpecifier instanceof IASTNamedTypeSpecifier) {
                    this.registerNamedTypeSpecifier(iASTDeclaration, bl, iASTDeclSpecifier);
                } else if (!(iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) && !(iASTDeclSpecifier instanceof IASTEnumerationSpecifier)) assert (false) : "missed a case?";
            }
            this.mCurrentDeclarationStack.push(iASTDeclaration);
            return super.visit(iASTDeclaration);
        }
        if (iASTDeclaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition iASTFunctionDefinition = (IASTFunctionDefinition)iASTDeclaration;
            IASTDeclSpecifier iASTDeclSpecifier = iASTFunctionDefinition.getDeclSpecifier();
            if (iASTDeclSpecifier instanceof IASTNamedTypeSpecifier) {
                this.registerNamedTypeSpecifier(iASTDeclaration, true, iASTDeclSpecifier);
            }
            if (iASTDeclaration.getParent() instanceof IASTTranslationUnit) {
                this.addIfNecessaryPrelimInverseDependency(iASTDeclaration, iASTFunctionDefinition.getDeclarator().getName().toString());
            }
            this.mLocalSymbolTable.beginScope();
            if (iASTFunctionDefinition.getDeclarator() instanceof CASTFunctionDeclarator) {
                CASTFunctionDeclarator cASTFunctionDeclarator = (CASTFunctionDeclarator)iASTFunctionDefinition.getDeclarator();
                IASTParameterDeclaration[] iASTParameterDeclarationArray = cASTFunctionDeclarator.getParameters();
                int n = iASTParameterDeclarationArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IASTParameterDeclaration iASTParameterDeclaration = iASTParameterDeclarationArray[n3];
                    String string = iASTParameterDeclaration.getDeclarator().getName().toString();
                    this.mLocalSymbolTable.put((Object)string, (Object)iASTDeclaration);
                    ++n3;
                }
            }
            this.mCurrentDeclarationStack.push((IASTDeclaration)iASTFunctionDefinition);
            int n = super.visit(iASTDeclaration);
            return n;
        }
        return super.visit(iASTDeclaration);
    }

    private void addIfNecessaryPrelimInverseDependency(IASTDeclaration iASTDeclaration, String string) {
        for (Map.Entry<String, IASTDeclaration> entry : this.mDependencyGraphPreliminaryInverse.entrySet()) {
            if (!string.equals(entry.getKey())) continue;
            this.addDependency(entry.getValue(), iASTDeclaration);
        }
    }

    protected void registerNamedTypeSpecifier(IASTDeclaration iASTDeclaration, boolean bl, IASTDeclSpecifier iASTDeclSpecifier) {
        IASTNamedTypeSpecifier iASTNamedTypeSpecifier = (IASTNamedTypeSpecifier)iASTDeclSpecifier;
        String string = iASTNamedTypeSpecifier.getName().toString();
        IASTDeclaration iASTDeclaration2 = (IASTDeclaration)this.mLocalSymbolTable.get((Object)string);
        if (iASTDeclaration2 != null) {
            this.addDependency(iASTDeclaration, iASTDeclaration2);
        } else if (bl) {
            this.mDependencyGraphPreliminaryInverse.put(string, iASTDeclaration);
        }
    }

    private static IASTDeclarator getInnermostFromNestedDeclarators(IASTDeclarator iASTDeclarator) {
        IASTDeclarator iASTDeclarator2 = iASTDeclarator;
        while (iASTDeclarator2.getNestedDeclarator() != null) {
            iASTDeclarator2 = iASTDeclarator2.getNestedDeclarator();
        }
        return iASTDeclarator2;
    }

    private static String getKindStringFromCompositeOrElaboratedTS(IASTDeclSpecifier iASTDeclSpecifier) {
        if (iASTDeclSpecifier instanceof IASTCompositeTypeSpecifier) {
            switch (((IASTCompositeTypeSpecifier)iASTDeclSpecifier).getKey()) {
                case 1: {
                    return "struct ";
                }
                case 2: {
                    return "union ";
                }
            }
            assert (false) : "??";
        } else if (iASTDeclSpecifier instanceof IASTElaboratedTypeSpecifier) {
            switch (((IASTElaboratedTypeSpecifier)iASTDeclSpecifier).getKind()) {
                case 1: {
                    return "struct ";
                }
                case 2: {
                    return "union ";
                }
                case 0: {
                    return "enum ";
                }
            }
            assert (false) : "??";
        }
        return null;
    }

    public int visit(IASTInitializer iASTInitializer) {
        IASTDeclaration iASTDeclaration;
        if (iASTInitializer instanceof IASTEqualsInitializer && (iASTDeclaration = (IASTDeclaration)iASTInitializer.getParent().getParent()).getParent() instanceof IASTTranslationUnit) {
            this.mCurrentDeclarationStack.push(iASTDeclaration);
        }
        return super.visit(iASTInitializer);
    }

    public int leave(IASTInitializer iASTInitializer) {
        IASTDeclaration iASTDeclaration;
        if (iASTInitializer instanceof IASTEqualsInitializer && (iASTDeclaration = (IASTDeclaration)iASTInitializer.getParent().getParent()).getParent() instanceof IASTTranslationUnit) {
            this.mCurrentDeclarationStack.pop();
        }
        return super.leave(iASTInitializer);
    }

    public int leave(IASTDeclaration iASTDeclaration) {
        if (iASTDeclaration instanceof IASTFunctionDefinition) {
            this.mCurrentDeclarationStack.pop();
            this.mLocalSymbolTable.endScope();
        } else if (iASTDeclaration instanceof IASTSimpleDeclaration) {
            this.mCurrentDeclarationStack.pop();
        }
        return super.leave(iASTDeclaration);
    }

    public int visit(IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTCompoundStatement && !(iASTStatement.getParent() instanceof IASTFunctionDefinition) && !(iASTStatement.getParent() instanceof IASTForStatement)) {
            this.mLocalSymbolTable.beginScope();
        }
        if (iASTStatement instanceof IASTSwitchStatement) {
            this.mLocalSymbolTable.beginScope();
        }
        if (iASTStatement instanceof IASTForStatement) {
            this.mLocalSymbolTable.beginScope();
        }
        return super.visit(iASTStatement);
    }

    public int leave(IASTStatement iASTStatement) {
        if (iASTStatement instanceof IASTCompoundStatement && !(iASTStatement.getParent() instanceof IASTFunctionDefinition) && !(iASTStatement.getParent() instanceof IASTForStatement)) {
            this.mLocalSymbolTable.endScope();
        }
        if (iASTStatement instanceof IASTSwitchStatement) {
            this.mLocalSymbolTable.endScope();
        }
        if (iASTStatement instanceof IASTForStatement) {
            this.mLocalSymbolTable.endScope();
        }
        return super.leave(iASTStatement);
    }

    public int leave(IASTTranslationUnit iASTTranslationUnit) {
        this.mTranslationUnit = iASTTranslationUnit;
        int n = super.leave(iASTTranslationUnit);
        this.computeReachableSetAndUpdateMMRequirements();
        return n;
    }

    private void addDependency(IASTDeclaration iASTDeclaration, IASTDeclaration iASTDeclaration2) {
        assert (iASTDeclaration != null);
        assert (iASTDeclaration2 != null);
        LinkedHashSet<Object> linkedHashSet = this.mDependencyGraph.get(iASTDeclaration);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
        }
        linkedHashSet.add(iASTDeclaration2);
        this.mDependencyGraph.put(iASTDeclaration, linkedHashSet);
    }

    String prettyPrintDependencyGraph() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<IASTDeclaration, LinkedHashSet<IASTDeclaration>> entry : this.mDependencyGraph.entrySet()) {
            for (IASTNode iASTNode : entry.getValue()) {
                stringBuilder.append(entry.getKey() == null ? "null" : entry.getKey().getRawSignature());
                stringBuilder.append("\n -> \n");
                stringBuilder.append(iASTNode == null ? "null" : iASTNode.getRawSignature());
                stringBuilder.append("\n\n--------\n");
            }
        }
        return stringBuilder.toString();
    }

    String prettyPrintDependencyGraphFilter(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<IASTDeclaration, LinkedHashSet<IASTDeclaration>> entry : this.mDependencyGraph.entrySet()) {
            for (IASTNode iASTNode : entry.getValue()) {
                String string2 = entry.getKey() == null ? "null" : entry.getKey().getRawSignature();
                string2 = string2.substring(0, n < string2.length() ? n : string2.length());
                String string3 = iASTNode == null ? "null" : iASTNode.getRawSignature();
                string3 = string3.substring(0, n < string3.length() ? n : string3.length());
                if (!string2.contains(string) && !string3.contains(string)) continue;
                stringBuilder.append(string2);
                stringBuilder.append("\n -> \n");
                stringBuilder.append(string3);
                stringBuilder.append("\n\n--------\n");
            }
        }
        return stringBuilder.toString();
    }

    String prettyPrintReachableSet() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IASTNode iASTNode : this.mReachableDeclarations) {
            stringBuilder.append(iASTNode.getRawSignature());
            stringBuilder.append("\n\n--------\n");
        }
        return stringBuilder.toString();
    }

    String prettyPrintReachableSetFilter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IASTNode iASTNode : this.mReachableDeclarations) {
            String string2 = iASTNode.getRawSignature();
            if (!string2.contains(string)) continue;
            stringBuilder.append(string2);
            stringBuilder.append("\n\n--------\n");
        }
        return stringBuilder.toString();
    }

    String prettyPrintSymbolTable() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : this.mLocalSymbolTable.entrySet()) {
            stringBuilder.append((String)entry.getKey() + " --> " + ((IASTDeclaration)entry.getValue()).getRawSignature() + "\n");
        }
        return stringBuilder.toString();
    }

    void computeReachableSetAndUpdateMMRequirements() {
        Object object;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!this.mEntryFunction.equals("") && this.mFunctionTable.containsKey(this.mEntryFunction)) {
            linkedHashSet.add(this.mEntryFunction);
        } else {
            if (!this.mEntryFunction.equals("") && !this.mFunctionTable.containsKey(this.mEntryFunction)) {
                object = "You specified the starting procedure: " + this.mEntryFunction + "\n The program does not have this method. ULTIMATE will continue in library mode (i.e., each procedure can be starting procedure and global variables are not initialized).";
                this.mReporter.warn(LocationFactory.createIgnoreCLocation((IASTNode)this.mTranslationUnit), (String)object);
            }
            linkedHashSet.addAll(this.mFunctionTable.keySet());
        }
        object = new ArrayDeque();
        for (String string : linkedHashSet) {
            ((ArrayDeque)object).add(DetermineNecessaryDeclarations.getDeclarationFromFuncDefinitionOrFuncDeclarator(this.mFunctionTable.get(string)));
        }
        while (!((ArrayDeque)object).isEmpty()) {
            String string;
            string = (IASTDeclaration)((ArrayDeque)object).pollFirst();
            this.mReachableDeclarations.add((IASTDeclaration)string);
            LinkedHashSet<IASTDeclaration> linkedHashSet2 = this.mDependencyGraph.get(string);
            if (linkedHashSet2 == null) continue;
            Iterator iterator = linkedHashSet2.iterator();
            while (iterator.hasNext()) {
                IASTDeclaration iASTDeclaration = (IASTDeclaration)iterator.next();
                if (this.mReachableDeclarations.contains(iASTDeclaration)) continue;
                ((ArrayDeque)object).add(iASTDeclaration);
            }
        }
    }

    LinkedHashSet<IASTDeclaration> getReachableDeclarationsOrDeclarators() {
        return this.mReachableDeclarations;
    }
}

