/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class AnnotateAndAssertCodeBlocks<L extends IAction> {
    protected final ILogger mLogger;
    protected final Script mScript;
    protected final ManagedScript mMgdScript;
    protected final Object mScriptLockOwner;
    protected final NestedWord<L> mTrace;
    protected Script.LBool mSatisfiable;
    protected final NestedFormulas<L, Term, Term> mSSA;
    protected ModifiableNestedFormulas<L, Term, Term> mAnnotSSA;
    protected static final String SSA = "ssa_";
    protected static final String PRECOND = "precond";
    protected static final String POSTCOND = "postcond";
    protected static final String RETURN = "_return";
    protected static final String LOCVARASSIGN_CALL = "_LocVarAssigCall";
    protected static final String GLOBVARASSIGN_CALL = "_GlobVarAssigCall";
    protected static final String OLDVARASSIGN_CALL = "_OldVarAssigCall";
    protected static final String PENDINGCONTEXT = "_PendingContext";
    protected static final String LOCVARASSIGN_PENDINGCONTEXT = "_LocVarAssignPendingContext";
    protected static final String OLDVARASSIGN_PENDINGCONTEXT = "_OldVarAssignPendingContext";

    public AnnotateAndAssertCodeBlocks(ManagedScript managedScript, TraceCheck.TraceCheckLock traceCheckLock, NestedFormulas<L, Term, Term> nestedFormulas, ILogger iLogger) {
        this.mLogger = iLogger;
        this.mMgdScript = managedScript;
        this.mScriptLockOwner = traceCheckLock;
        this.mScript = managedScript.getScript();
        this.mTrace = nestedFormulas.getTrace();
        this.mSSA = nestedFormulas;
    }

    protected Term annotateAndAssertPrecondition() {
        String string = this.precondAnnotation();
        Term term = this.annotateAndAssertTerm(this.mSSA.getPrecondition(), string);
        return term;
    }

    protected String precondAnnotation() {
        return "ssa_precond";
    }

    protected Term annotateAndAssertPostcondition() {
        String string = this.postcondAnnotation();
        Term term = this.mScript.term("not", new Term[]{this.mSSA.getPostcondition()});
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String postcondAnnotation() {
        return "ssa_postcond";
    }

    protected Term annotateAndAssertNonCall(int n) {
        String string = this.mTrace.isReturnPosition(n) ? this.returnAnnotation(n) : this.internalAnnotation(n);
        Term term = this.mSSA.getFormulaFromNonCallPos(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String internalAnnotation(int n) {
        return SSA + n;
    }

    protected String returnAnnotation(int n) {
        return SSA + n + RETURN;
    }

    protected Term annotateAndAssertLocalVarAssignemntCall(int n) {
        String string = this.localVarAssignemntCallAnnotation(n);
        Term term = this.mSSA.getLocalVarAssignment(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String localVarAssignemntCallAnnotation(int n) {
        return SSA + n + LOCVARASSIGN_CALL;
    }

    protected Term annotateAndAssertGlobalVarAssignemntCall(int n) {
        String string = this.globalVarAssignemntAnnotation(n);
        Term term = this.mSSA.getGlobalVarAssignment(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String globalVarAssignemntAnnotation(int n) {
        return SSA + n + GLOBVARASSIGN_CALL;
    }

    protected Term annotateAndAssertOldVarAssignemntCall(int n) {
        String string = this.oldVarAssignemntCallAnnotation(n);
        Term term = this.mSSA.getOldVarAssignment(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String oldVarAssignemntCallAnnotation(int n) {
        return SSA + n + OLDVARASSIGN_CALL;
    }

    protected Term annotateAndAssertPendingContext(int n, int n2) {
        String string = this.pendingContextAnnotation(n2);
        Term term = this.mSSA.getPendingContext(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String pendingContextAnnotation(int n) {
        return SSA + n + PENDINGCONTEXT;
    }

    protected Term annotateAndAssertLocalVarAssignemntPendingContext(int n, int n2) {
        String string = this.localVarAssignemntPendingReturnAnnotation(n2);
        Term term = this.mSSA.getLocalVarAssignment(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String localVarAssignemntPendingReturnAnnotation(int n) {
        return SSA + n + LOCVARASSIGN_PENDINGCONTEXT;
    }

    protected Term annotateAndAssertOldVarAssignemntPendingContext(int n, int n2) {
        String string = this.oldVarAssignemntPendingReturnAnnotation(n2);
        Term term = this.mSSA.getOldVarAssignment(n);
        Term term2 = this.annotateAndAssertTerm(term, string);
        return term2;
    }

    protected String oldVarAssignemntPendingReturnAnnotation(int n) {
        return SSA + n + OLDVARASSIGN_PENDINGCONTEXT;
    }

    protected Term annotateAndAssertTerm(Term term, String string) {
        assert (term.getFreeVars().length == 0) : "Term has free vars";
        Annotation annotation = new Annotation(":named", (Object)string);
        Term term2 = this.mScript.annotate(term, new Annotation[]{annotation});
        this.mMgdScript.assertTerm(this.mScriptLockOwner, term2);
        Term term3 = this.mScript.term(string, new Term[0]);
        return term3;
    }

    public static class AnnotatedSsaConjunct {
        private final Term mAnnotedTerm;
        private final Term mOriginalTerm;

        public AnnotatedSsaConjunct(Term term, Term term2) {
            this.mAnnotedTerm = term;
            this.mOriginalTerm = term2;
        }

        public Term getAnnotedTerm() {
            return this.mAnnotedTerm;
        }

        public Term getOriginalTerm() {
            return this.mOriginalTerm;
        }

        public String toString() {
            return "AnnotatedSsaConjunct [mAnnotedTerm=" + String.valueOf(this.mAnnotedTerm) + ", mOriginalTerm=" + String.valueOf(this.mOriginalTerm) + "]";
        }
    }
}

