/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class IndexAnalyzer {
    private final ILogger mLogger;
    private final Term mTerm;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final ModifiableTransFormula mTransFormula;
    private final Set<Doubleton<Term>> mDistinctDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mEqualDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mUnknownDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mIgnoredDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final EqualityAnalysisResult mInvariantEqualitiesBefore;
    private final EqualityAnalysisResult mInvariantEqualitiesAfter;
    private final boolean mUseArrayIndexSupportingInvariants = true;

    public IndexAnalyzer(Term term, Set<Doubleton<Term>> set, IIcfgSymbolTable iIcfgSymbolTable, ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult, EqualityAnalysisResult equalityAnalysisResult2, ILogger iLogger, ManagedScript managedScript) {
        this.mLogger = iLogger;
        this.mTerm = term;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mScript = managedScript.getScript();
        this.mManagedScript = managedScript;
        this.mTransFormula = modifiableTransFormula;
        this.mInvariantEqualitiesBefore = equalityAnalysisResult;
        this.mInvariantEqualitiesAfter = equalityAnalysisResult2;
        Set<Doubleton<Term>> set2 = set;
        Set<Doubleton<Term>> set3 = this.preprocessWithInvariants(set2);
        Term term2 = SmtUtils.and((Script)this.mScript, this.mInvariantEqualitiesBefore.constructListOfEqualities(this.mScript));
        Term term3 = SmtUtils.and((Script)this.mScript, this.mInvariantEqualitiesBefore.constructListOfNotEquals(this.mScript));
        Term term4 = ModifiableTransFormulaUtils.translateTermVariablesToInVars(this.mManagedScript, this.mTransFormula, term2, this.mSymbolTable);
        Term term5 = ModifiableTransFormulaUtils.translateTermVariablesToInVars(this.mManagedScript, this.mTransFormula, term3, this.mSymbolTable);
        Term term6 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mTerm, term4, term5});
        this.processDoubletonsWithOwnAnalysis(set3, term6);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Indices for " + String.valueOf(modifiableTransFormula.getFormula())));
            if (!(this.mEqualDoubletons.isEmpty() && this.mDistinctDoubletons.isEmpty() && this.mUnknownDoubletons.isEmpty() && this.mIgnoredDoubletons.isEmpty())) {
                this.mLogger.debug((Object)(this.mEqualDoubletons.size() + " equalDoubletons"));
                this.mLogger.debug((Object)(this.mDistinctDoubletons.size() + " distinctDoubletons"));
                this.mLogger.debug((Object)(this.mUnknownDoubletons.size() + " unknownDoubletons"));
                this.mLogger.debug((Object)(this.mIgnoredDoubletons.size() + " ignoredDoubletons"));
            } else {
                this.mLogger.debug((Object)"No Doubletons");
            }
        }
    }

    public IndexAnalyzer(Term term, HashRelation<Term, ArrayIndex> hashRelation, IIcfgSymbolTable iIcfgSymbolTable, ModifiableTransFormula modifiableTransFormula, EqualityAnalysisResult equalityAnalysisResult, EqualityAnalysisResult equalityAnalysisResult2, ILogger iLogger, ManagedScript managedScript) {
        this(term, IndexAnalyzer.extractDoubletons(hashRelation), iIcfgSymbolTable, modifiableTransFormula, equalityAnalysisResult, equalityAnalysisResult2, iLogger, managedScript);
    }

    private Set<Doubleton<Term>> preprocessWithInvariants(Set<Doubleton<Term>> set) {
        HashSet<Doubleton<Term>> hashSet = new HashSet<Doubleton<Term>>();
        for (Doubleton<Term> doubleton : set) {
            if (this.isInVarDoubleton(doubleton)) {
                this.gradeDoubleton(doubleton, this.mInvariantEqualitiesBefore, this.mEqualDoubletons, this.mDistinctDoubletons, hashSet);
                continue;
            }
            if (this.isOutVarDoubleton(doubleton)) {
                this.gradeDoubleton(doubleton, this.mInvariantEqualitiesAfter, this.mEqualDoubletons, this.mDistinctDoubletons, hashSet);
                continue;
            }
            hashSet.add(doubleton);
        }
        return hashSet;
    }

    private void gradeDoubleton(Doubleton<Term> doubleton, EqualityAnalysisResult equalityAnalysisResult, Set<Doubleton<Term>> set, Set<Doubleton<Term>> set2, Set<Doubleton<Term>> set3) throws AssertionError {
        EqualityStatus equalityStatus;
        Doubleton<Term> doubleton2 = this.constructDefiningDoubleton(doubleton);
        try {
            equalityStatus = equalityAnalysisResult.getEqualityStatus(doubleton2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            set3.add(doubleton);
            return;
        }
        switch (equalityStatus) {
            case EQUAL: {
                set.add(doubleton);
                break;
            }
            case NOT_EQUAL: {
                set2.add(doubleton);
                break;
            }
            case UNKNOWN: {
                set3.add(doubleton);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean isInVarDoubleton(Doubleton<Term> doubleton) {
        boolean bl = ModifiableTransFormulaUtils.allVariablesAreInVars((Term)doubleton.getOneElement(), this.mTransFormula);
        boolean bl2 = ModifiableTransFormulaUtils.allVariablesAreInVars((Term)doubleton.getOtherElement(), this.mTransFormula);
        boolean bl3 = bl && bl2;
        return bl3;
    }

    private boolean isOutVarDoubleton(Doubleton<Term> doubleton) {
        boolean bl = ModifiableTransFormulaUtils.allVariablesAreOutVars((Term)doubleton.getOneElement(), this.mTransFormula);
        boolean bl2 = ModifiableTransFormulaUtils.allVariablesAreOutVars((Term)doubleton.getOtherElement(), this.mTransFormula);
        boolean bl3 = bl && bl2;
        return bl3;
    }

    private static Set<Doubleton<Term>> extractDoubletons(HashRelation<Term, ArrayIndex> hashRelation) {
        HashSet<Doubleton<Term>> hashSet = new HashSet<Doubleton<Term>>();
        for (Term term : hashRelation.getDomain()) {
            Set set = hashRelation.getImage((Object)term);
            ArrayIndex[] arrayIndexArray = set.toArray(new ArrayIndex[set.size()]);
            int n = 0;
            while (n < arrayIndexArray.length) {
                int n2 = n + 1;
                while (n2 < arrayIndexArray.length) {
                    ArrayIndex arrayIndex = arrayIndexArray[n];
                    ArrayIndex arrayIndex2 = arrayIndexArray[n2];
                    assert (arrayIndex.size() == arrayIndex2.size()) : "incompatible size";
                    int n3 = 0;
                    while (n3 < arrayIndex.size()) {
                        hashSet.add((Doubleton<Term>)new Doubleton((Object)arrayIndex.get(n3), (Object)arrayIndex2.get(n3)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return hashSet;
    }

    private void addDistinctDoubleton(Doubleton<Term> doubleton) {
        this.mDistinctDoubletons.add(doubleton);
    }

    private void addEqualDoubleton(Doubleton<Term> doubleton) {
        this.mEqualDoubletons.add(doubleton);
    }

    private void addUnknownDoubleton(Doubleton<Term> doubleton) {
        this.mUnknownDoubletons.add(doubleton);
    }

    private void processDoubletonsWithOwnAnalysis(Set<Doubleton<Term>> set, Term term) {
        this.mScript.echo(new QuotedObject("starting index analysis for TransFormula"));
        this.mScript.push(1);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        hashSet.addAll(CoreUtil.filter(this.mTransFormula.getInVarsReverseMapping().keySet(), TermVariable.class));
        hashSet.addAll(CoreUtil.filter(this.mTransFormula.getOutVarsReverseMapping().keySet(), TermVariable.class));
        Map map = SmtUtils.termVariables2Constants((Script)this.mScript, hashSet, (boolean)true);
        this.mScript.assertTerm(Substitution.apply((ManagedScript)this.mManagedScript, (Map)map, (Term)term));
        for (Doubleton<Term> doubleton : set) {
            if (IndexAnalyzer.allVarsOccurInFormula(doubleton, term)) {
                Term term2 = Substitution.apply((ManagedScript)this.mManagedScript, (Map)map, (Term)SmtUtils.binaryEquality((Script)this.mScript, (Term)((Term)doubleton.getOneElement()), (Term)((Term)doubleton.getOtherElement())));
                this.mScript.push(1);
                this.mScript.assertTerm(term2);
                Script.LBool lBool = this.mScript.checkSat();
                this.mScript.pop(1);
                if (lBool == Script.LBool.UNSAT) {
                    this.addDistinctDoubleton(doubleton);
                    continue;
                }
                Term term3 = SmtUtils.not((Script)this.mScript, (Term)term2);
                this.mScript.push(1);
                this.mScript.assertTerm(term3);
                lBool = this.mScript.checkSat();
                this.mScript.pop(1);
                if (lBool == Script.LBool.UNSAT) {
                    this.addEqualDoubleton(doubleton);
                    continue;
                }
                this.addUnknownDoubleton(doubleton);
                continue;
            }
            this.mIgnoredDoubletons.add(doubleton);
        }
        this.mScript.pop(1);
        this.mScript.echo(new QuotedObject("finished index analysis for TransFormula"));
    }

    private static boolean allVarsOccurInFormula(Doubleton<Term> doubleton, Term term) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(((Term)doubleton.getOneElement()).getFreeVars()));
        hashSet.addAll(Arrays.asList(((Term)doubleton.getOtherElement()).getFreeVars()));
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        return hashSet2.containsAll(hashSet);
    }

    private Doubleton<Term> constructDefiningDoubleton(Doubleton<Term> doubleton) {
        Term term = (Term)doubleton.getOneElement();
        Term term2 = (Term)doubleton.getOtherElement();
        Term term3 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, this.mTransFormula, term);
        Term term4 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, this.mTransFormula, term2);
        return new Doubleton((Object)term3, (Object)term4);
    }

    public IndexAnalysisResult getResult() {
        return new IndexAnalysisResult(Collections.unmodifiableSet(this.mEqualDoubletons), Collections.unmodifiableSet(this.mDistinctDoubletons), Collections.unmodifiableSet(this.mUnknownDoubletons), Collections.unmodifiableSet(this.mIgnoredDoubletons));
    }
}

