/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class SubtermPropertyChecker
extends NonRecursive {
    private Set<Term> mTermsInWhichWeAlreadyDescended;
    private final Predicate<Term> mProperty;
    private boolean mFoundInCurrentSeach;

    public SubtermPropertyChecker(Predicate<Term> predicate) {
        this.mProperty = predicate;
    }

    public boolean isSatisfiedBySomeSubterm(Term term) {
        this.mFoundInCurrentSeach = false;
        this.mTermsInWhichWeAlreadyDescended = new HashSet<Term>();
        this.run((NonRecursive.Walker)new MyWalker(term));
        this.mTermsInWhichWeAlreadyDescended = null;
        return this.mFoundInCurrentSeach;
    }

    class MyWalker
    extends NonRecursive.TermWalker {
        MyWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive nonRecursive) {
            if (!SubtermPropertyChecker.this.mFoundInCurrentSeach && !SubtermPropertyChecker.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                if (SubtermPropertyChecker.this.mProperty.test(this.getTerm())) {
                    SubtermPropertyChecker.this.mFoundInCurrentSeach = true;
                    SubtermPropertyChecker.this.reset();
                } else {
                    super.walk(nonRecursive);
                }
            }
        }

        public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
        }

        public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
            SubtermPropertyChecker.this.mTermsInWhichWeAlreadyDescended.add((Term)annotatedTerm);
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(annotatedTerm.getSubterm()));
        }

        public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
            SubtermPropertyChecker.this.mTermsInWhichWeAlreadyDescended.add((Term)applicationTerm);
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(term));
                ++n2;
            }
        }

        public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
            throw new UnsupportedOperationException("SubtermPropertyChecker does not support LetTerms");
        }

        public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
            nonRecursive.enqueueWalker((NonRecursive.Walker)new MyWalker(quantifiedFormula.getSubformula()));
        }

        public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
        }

        public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
            throw new UnsupportedOperationException();
        }
    }
}

