/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OctagonRelation {
    private final boolean mNegateVar1;
    private final Term mVar1;
    private final boolean mNegateVar2;
    private final Term mVar2;
    private final RelationSymbol mRelationSymbol;
    private final Rational mConstant;

    public OctagonRelation(boolean bl, Term term, boolean bl2, Term term2, RelationSymbol relationSymbol, Rational rational) {
        this.mNegateVar1 = bl;
        this.mVar1 = term;
        this.mNegateVar2 = bl2;
        this.mVar2 = term2;
        this.mRelationSymbol = relationSymbol;
        this.mConstant = rational;
    }

    public static OctagonRelation from(PolynomialRelation polynomialRelation) {
        AbstractGeneralizedAffineTerm<?> abstractGeneralizedAffineTerm = polynomialRelation.getPolynomialTerm();
        if (!abstractGeneralizedAffineTerm.isAffine()) {
            return null;
        }
        AffineTerm affineTerm = (AffineTerm)abstractGeneralizedAffineTerm;
        Set set = affineTerm.getAbstractVariable2Coefficient().keySet();
        for (Term term : set) {
            if (term instanceof TermVariable || SmtUtils.isConstant(term)) continue;
            return null;
        }
        switch (set.size()) {
            case 1: {
                return OctagonRelation.from1Var(affineTerm, polynomialRelation.getRelationSymbol());
            }
            case 2: {
                return OctagonRelation.from2Vars(affineTerm, polynomialRelation.getRelationSymbol());
            }
        }
        return null;
    }

    private static OctagonRelation from1Var(AffineTerm affineTerm, RelationSymbol relationSymbol) {
        OctagonRelation.checkNumberOfVariables(1, affineTerm.getAbstractVariable2Coefficient().size());
        Map.Entry entry = affineTerm.getAbstractVariable2Coefficient().entrySet().iterator().next();
        Term term = (Term)entry.getKey();
        Rational rational = entry.getValue().abs();
        boolean bl = entry.getValue().isNegative();
        Rational rational2 = affineTerm.getConstant().mul(Rational.TWO).div(rational).negate();
        return new OctagonRelation(bl, term, !bl, term, relationSymbol, rational2);
    }

    private static OctagonRelation from2Vars(AffineTerm affineTerm, RelationSymbol relationSymbol) {
        Map map = affineTerm.getAbstractVariable2Coefficient();
        OctagonRelation.checkNumberOfVariables(2, map.size());
        Iterator iterator = map.entrySet().stream().sorted((entry, entry2) -> ((Term)entry.getKey()).toString().compareTo(((Term)entry2.getKey()).toString())).iterator();
        Map.Entry entry3 = (Map.Entry)iterator.next();
        Map.Entry entry4 = (Map.Entry)iterator.next();
        Rational rational = ((Rational)entry3.getValue()).abs();
        if (!rational.equals((Object)((Rational)entry4.getValue()).abs())) {
            return null;
        }
        Rational rational2 = affineTerm.getConstant().div(rational).negate();
        return new OctagonRelation(((Rational)entry3.getValue()).isNegative(), (Term)entry3.getKey(), !((Rational)entry4.getValue()).isNegative(), (Term)entry4.getKey(), relationSymbol, rational2);
    }

    private static void checkNumberOfVariables(int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException("Expected " + n + " variable(s), found " + n2);
        }
    }

    public boolean isNegateVar1() {
        return this.mNegateVar1;
    }

    public Term getVar1() {
        return this.mVar1;
    }

    public boolean isNegateVar2() {
        return this.mNegateVar2;
    }

    public Term getVar2() {
        return this.mVar2;
    }

    public RelationSymbol getRelationSymbol() {
        return this.mRelationSymbol;
    }

    public Rational getConstant() {
        return this.mConstant;
    }

    public String toString() {
        return String.format("(%s%s) - (%s%s) %s %s", new Object[]{Character.valueOf(OctagonRelation.sign(this.mNegateVar1)), this.mVar1, Character.valueOf(OctagonRelation.sign(this.mNegateVar2)), this.mVar2, this.mRelationSymbol, this.mConstant});
    }

    private static char sign(boolean bl) {
        return bl ? (char)'-' : '+';
    }
}

